#pragma once

#include "prelude.hpp"

namespace biscuit
{

template<
	class Parser // width == 1
>
struct complement
{
	template< class State >
	static bool parse(State &state)
	{
		typename State::iterator_type const tmp = state.cur;
		
		if (Parser::parse(state))
		{
			state.cur = tmp;
			return false;
		}
		
		if (eos(state))
			return false;

		++state.cur;
		return true;
	}
	
	typedef complement type;
};

} // namespace biscuit
