#pragma once

#include "prelude.hpp"

namespace biscuit
{

template<
	class Parser
>
struct before
{
	template< class State >
	static bool parse(State &state)
	{
		typename State::iterator_type const tmp = state.cur;

		if (Parser::parse(state))
		{
			state.cur = tmp;
			return true;
		}
		
		return false;
	}
	
	typedef before type;
};

} // namespace biscuit
