#pragma once

#include "prelude.hpp"
#include "nothing.hpp"

namespace biscuit
{

template<
	class Parser0 = nothing, class Parser1 = nothing,
	class Parser2 = nothing, class Parser3 = nothing,
	class Parser4 = nothing, class Parser5 = nothing,
	class Parser6 = nothing, class Parser7 = nothing,
	class Parser8 = nothing, class Parser9 = nothing
>
struct alternative
{
	template< class State >
	static bool parse(State &state)
	{
		return
			Parser0::parse(state)
			|| Parser1::parse(state)
			|| Parser2::parse(state)
			|| Parser3::parse(state)
			|| Parser4::parse(state)
			|| Parser5::parse(state)
			|| Parser6::parse(state)
			|| Parser7::parse(state)
			|| Parser8::parse(state)
			|| Parser9::parse(state)
		;
	}
	
	typedef alternative type;
};

}
