#pragma once

#include "prelude.hpp"

namespace biscuit
{

template<
	class Parser, class FunctorType
>
struct action
{
	template< class State >
	static bool parse(State &state)
	{
		typename State::iterator_type const tmp = state.cur;

		if (Parser::parse(state)) {
			FunctorType()(state);
			return true;
		}
		
		return false;
	}
	
	typedef action type;
};

} // namespace biscuit
