
#pragma once

#include "../cmd_ui.hpp"

namespace ketchup { namespace detail {

///////////////////////////////////////////////////////////////////////////////
// toolbar_cmd_ui
//
struct toolbar_cmd_ui : cmd_ui
{
	CToolBarCtrl m_wndToolBar;

	explicit toolbar_cmd_ui(UINT nID, HWND hWnd)
		: cmd_ui(nID), m_wndToolBar(hWnd)
	{
		assert(m_wndToolBar.IsWindow());
	}

	// overrides
	virtual void enable(bool bOn = true)
	{
		// See: See: MFC7::CToolCmdUI::Enable
		UINT nOldState = m_wndToolBar.GetState(get_id());
		UINT nNewState = nOldState;
		assert(nNewState != -1);
		if (!bOn) {
			nNewState &= ~TBSTATE_ENABLED;
			// WINBUG: If a button is currently pressed and then is disabled
			// COMCTL32.DLL does not unpress the button, even after the mouse
			// button goes up!  We work around this bug by forcing TBBS_PRESSED
			// off when a button is disabled.
			nNewState &= ~TBSTATE_CHECKED;
		}
		else {
			nNewState |= TBSTATE_ENABLED;
		}

		ATLVERIFY(m_wndToolBar.SetState(get_id(), nNewState));
	}

	virtual void set_check(int nCheck = 1)
	{
		assert(nCheck >= 0 && nCheck <= 2); // 0=>off, 1=>on, 2=>indeterminate

		init_cbSize<TBBUTTONINFO>::type tbb;
		tbb.dwMask = TBIF_STATE | TBIF_STYLE;
		ATLVERIFY( m_wndToolBar.GetButtonInfo(get_id(), &tbb) != -1 );

		// add check style
		tbb.fsStyle = tbb.fsStyle | TBSTYLE_CHECK;

		// reset state and...
		tbb.fsState = tbb.fsState &
					~(TBSTATE_CHECKED | TBSTATE_INDETERMINATE);

		if (nCheck == 1)
			tbb.fsState |= TBSTATE_CHECKED;
		else if (nCheck == 2)
			tbb.fsState |= TBSTATE_INDETERMINATE;

		ATLVERIFY(m_wndToolBar.SetButtonInfo(get_id(), &tbb));
	}
};

} } // namespace ketchup::detail
