///////////////////////////////////////////////////////////////////////////////
// gen_process_statement.hpp
//
// Concepts:
//  EntrySeq is...
//    a MPL Sequence of Entry
//  Entry is...
//    a type which has a static member function, 
//    bool process(Args);
//
// Note:
//  gen_process_statement can't touch Args type,
//  so you should choose whether referenced or not.
//

#ifndef KETCHUP_GEN_PROCESS_STATEMENT_H
#define KETCHUP_GEN_PROCESS_STATEMENT_H

#ifdef _MSC_VER
#pragma once
#endif

#include <boost/concept_check.hpp>
#include <boost/mpl/reverse_fold.hpp>

namespace ketchup { namespace detail {

///////////////////////////////////////////////////////////////////////////////
// Note:
//  If EntrySeq has the same Entry, VC7.1 duplicates
//  the static member function, Entry::process (LNK1179 error).
//  I can't understand the problem,
//  but VC7.1 seems to hate static member functions.
//  So I define fold_op_workaround and...
//
// process_entry
//
template< class Entry, class Args >
bool process_entry(Args xs)
{

	return Entry::process(xs);
}

///////////////////////////////////////////////////////////////////////////////
// big_entry
//
template< class EntrySeq, class Args >
struct gen_process_statement
{
	struct fold_init_state
	{
		static bool process(Args xs)
		{
			boost::ignore_unused_variable_warning(xs);
			return false;
		}
	};
	
	/*
	template< class State, class Entry >
	struct fold_op
	{
		static bool process(Args xs)
		{
			if (detail::process_entry<Entry, Args>(xs))
				return true;
			else
				return State::process(xs);
		}
	};
	*/

	// The placeholders say mpl_assert_not_arg, so I define
	struct fold_op_workaround
	{
		template< class State, class Entry >
		struct apply
		{
			static bool process(Args xs)
			{
				if (detail::process_entry<Entry, Args>(xs))
					return true;
				else
					return State::process(xs);
			}

			typedef apply type;
		};
	};

	typedef typename boost::mpl::reverse_fold<EntrySeq,
		fold_init_state,
		// fold_op<boost::mpl::_1, boost::mpl::_2> // makes mpl_assert_not_arg
		fold_op_workaround
	>::type type;
};

} } // namespace ketchup::detail

#endif
