// msg_wm_converter.cpp : R\[ AvP[ṼGg |Cg`܂B
//

#include "stdafx.h"

#include <sstream>
#include <iostream>
#include <fstream>
#include <cassert>
#include <iterator>
#include <boost/spirit/fusion/iterator/detail/iterator_base.hpp>
#include <boost/xpressive/xpressive_static.hpp>
#include <boost/algorithm/string.hpp>

namespace {

using namespace std;
using namespace boost::xpressive;

// tag
mark_tag tag_macro_name(1), tag_macro_body(2), tag_func_args(3), tag_macro_args(4);

// grammar
sregex re_macro_name = -+_ >> +~as_xpr('(');

// sregex re_macro_args = as_xpr('(') >> (tag_macro_args= *~as_xpr(')')) >> as_xpr(')');
// sregex re_macro_args = as_xpr('(') >> (tag_macro_args= -*_) >> as_xpr(')');

sregex re_define =
	as_xpr("#define ") >>
	(tag_macro_name= re_macro_name) >>
	as_xpr('(') >> (tag_macro_args= -*_) >> as_xpr(')') >> -*_ >> _n >>
	(tag_macro_body= ( -+_ >> before( as_xpr('#')|as_xpr("//") ) ) ); //"+~(boost::xpressive::set='#','/')); 

sregex re_macro_body =
	-+_ >>
	as_xpr("func(") >> (tag_func_args= -*_) >> as_xpr(");") >>
	+_;

string get_type_name(bool with_name, string const& arg, string const& func_args, bool bLRESULT);

string get_func_type_name(bool with_name, string const& func_name, string const& func_args, bool func_returns_LRESULT)
{
	stringstream out;

	if (func_returns_LRESULT)
		out << "LRESULT ";
	else
		out << "void ";

	sregex re_argument = (bos|as_xpr(',')) >> *_s >> (s1= +~as_xpr(','));

	out << "(Derived::*";
	
	if (with_name)
		out << func_name;
	
	out << ")(";

	sregex_iterator cur(func_args.begin(), func_args.end(), re_argument);
	sregex_iterator end;
	for( ; cur != end; ++cur) {
		smatch const& what = *cur;
		string func_arg = what[1].str();
		out << get_type_name(false, func_arg, string(""), false) << ",";
	}

	// remove trailing ','s
	string out_ = out.str();
	out_ = regex_replace(out_, (s1= +as_xpr(",") >> eos), string(""));

	return out_ + ")";
}

string get_type_name(bool with_param, string const& arg, string const& func_args, bool func_returns_LRESULT)
{
	string param("");
	if (with_param)
		param = " " + arg;

	smatch what;
	if (regex_match(arg, what, as_xpr('(') >> (s1= -+_) >> as_xpr(')') >> *_)) // cast syntax
		return what[1].str() + param;
	else if (regex_match(arg, "msg" >> *_))
		return "UINT" + param;
	else if (regex_match(arg, "func" >> *_))
		return get_func_type_name(true, arg, func_args, func_returns_LRESULT);
	else if (regex_match(arg, "wParam" >> *_))
		return "WPARAM" + param;
	else if (regex_match(arg, "lParam" >> *_))
		return "LPARAM" + param;
	else if (regex_match(arg, "HIWORD(" >> *_))
		return "WORD" + param;
	else if (regex_match(arg, "LOWORD(" >> *_))
		return "WORD" + param;
	else if (regex_match(arg, "bHandled" >> *_))
		return "BOOL&" + param;

	else if (regex_match(arg, "id" >> *_))
		return "UINT" + param;
	else if (regex_match(arg, "code" >> *_))
		return "UINT" + param;
	else if (regex_match(arg, "cd" >> *_))
		return "UINT" + param;

	else if (regex_match(arg, "uMsg" >> *_))
		return "UINT" + param;

	else if (regex_match(arg, "CSize" >> *_))
		return "CSize const&" + param;
	else if (regex_match(arg, "CPoint" >> *_))
		return "CPoint const&" + param;

	else if (regex_match(arg, "GET_APPCOMMAND_LPARAM" >> *_))
		return "WORD" + param;
	else if (regex_match(arg, "GET_DEVICE_LPARAM" >> *_))
		return "WORD" + param;
	else if (regex_match(arg, "GET_KEYSTATE_WPARAM" >> *_))
		return "WORD" + param;
	else if (regex_match(arg, "GET_KEYSTATE_LPARAM" >> *_))
		return "WORD" + param;

	else if (regex_match(arg, "GET_XBUTTON_WPARAM" >> *_))
		return "WORD" + param;
	else if (regex_match(arg, "GET_NCHITTEST_WPARAM" >> *_))
		return "WORD" + param;

	else if (regex_match(arg, "GET_RAWINPUT_CODE_WPARAM" >> *_))
		return "WORD" + param;

	else if (regex_match(arg, "GET_Y_LPARAM" >> *_)) // easy fix
		return "";

	return "UNKNOWN_TYPE_ERROR";
}

string gen_template_params(string const& macro_args, string const& func_args, bool func_returns_LRESULT)
{
	stringstream out;
	sregex re_argument = (bos|as_xpr(',')) >> *_s >> (s1= +~as_xpr(','));

	sregex_iterator cur(macro_args.begin(), macro_args.end(), re_argument);
	sregex_iterator end;
	for( ; cur != end; ++cur) {
		smatch const& what = *cur;
		string macro_arg = what[1].str();
		out << get_type_name(true, macro_arg, func_args, func_returns_LRESULT) << ",";
	}

	// remove trailing ','s
	string out_ = out.str();
	out_ = regex_replace(out_, (s1= +as_xpr(",") >> eos), string(""));

	return out_;
}

bool is_func_returns_LRESULT(string const& macro_body)
{
	return regex_search(macro_body, "= (LRESULT)func" >> epsilon) ||
		regex_search(macro_body, "= func" >> epsilon);
}

bool is_cracked_handler(string const& macro_name)
{
	return regex_match(macro_name, "MSG_" >> +_);
}

string gen_struct_name(string const& macro_name, int mode)
{
	string name = boost::to_lower_copy(macro_name);
	if (mode == 0)
		return name;
	else if (mode == 1)
		return name + "_hot";
	else if (mode == 2)
		return name + "_not";

	assert(false);
	return name + "_ERROR_UNKNOWN_MODE";
}

string gen_function_body(string const& macro_body, int mode)
{
	string body = macro_body;
	body = regex_replace(body, (s1= bol), string("\t"));
	body = regex_replace(body, (s1= " \\\n"), string("\n"));

	string fmt = "get_$1(xs)";
	body = regex_replace(body, (s1= "hWnd"), fmt);
	body = regex_replace(body, (s1= "uMsg"), fmt);
	body = regex_replace(body, (s1= "wParam"), fmt);
	body = regex_replace(body, (s1= "lParam"), fmt);
	body = regex_replace(body, (s1= "lResult"), fmt);
	body = regex_replace(body, (s1= "dwMsgMapID"), fmt);
	body = regex_replace(body, (s1= "bHandled"), fmt);
	body = regex_replace(body, (s1= "func"), string("(get_derived(xs).*func)"));

	body = regex_replace(body, (s1= "return TRUE"), string("return true"));
	body = regex_replace(body, (s1= "SetMsgHandled(TRUE)"), string("get_derived(xs).set_msg_handled(true)"));
	body = regex_replace(body, (s1= "IsMsgHandled()"), string("get_derived(xs).is_msg_handled()"));

	if (mode == 0) {										// default
		return body;
	}
	else if (mode == 1 || mode == 2) {	// hot or not
		body = regex_replace(body, (s1= "get_bHandled(xs) = TRUE;"), string(""));
		body = regex_replace(body, (s1= "get_derived(xs).set_msg_handled(true);"), string(""));

		body = regex_replace(body, (s1= "if" >> *_s >> "(get_bHandled(xs))"), string(""));
		body = regex_replace(body, (s1= "if" >> *_s >> "(get_derived(xs).is_msg_handled())"), string(""));
		if (mode == 1)										// hot
			return body;
		else															// not
			return regex_replace(body, (s1= "return true;"), string(""));
	}

	assert(false);
	return "ERROR_UNKNOWN_MODE";
}

string parse(string const& in)
{
	stringstream out;
	out << "///////////////////////////////////////////////////////////////////////////////" << endl;
	out << "// GENERATED BY msg_wm_converter" << endl;
	out << "//" << endl << endl;

	sregex_iterator cur(in.begin(), in.end(), re_define);
	string::const_iterator first_pos = in.begin();
	sregex_iterator end;
	for( ; cur != end; ++cur) {
		smatch const& what = *cur;

		{
			// pass unmatched string to output
			string::const_iterator last_pos = in.begin();
			advance(last_pos, what.position(0));
			out << string(first_pos, last_pos);
			first_pos = last_pos; // update first_pos
			advance(first_pos, what.length(0));
		}

		// let's generate!
		string struct_name = gen_struct_name(what[tag_macro_name].str(), 0);
		out << "///////////////////////////////////////////////////////////////////////////////" << endl;
		out << "// " << struct_name << endl;
		out << "//" << endl;

		string macro_args = what[tag_macro_args].str();
		string macro_body = what[tag_macro_body].str();

		smatch what_body;
		if (!regex_match(macro_body, what_body, re_macro_body)) {
			out << "// MANUAL_FIX_REQUIRED_for_NO_FUNC_CALL" << endl << endl << endl;
			continue;
		}

    string func_args = what_body[tag_func_args];

		// out << "// macro_args: " << macro_args << endl;
		// out << "// func_args: " << func_args << endl;

		bool func_returns_LRESULT = is_func_returns_LRESULT(macro_body);

		for (int i = 0; i < 3; ++i) {
			out <<
				"template<"																																<< endl <<
				"\t" << gen_template_params(macro_args, func_args, func_returns_LRESULT)	<< endl <<
				">"																																				<< endl <<
				"struct " << gen_struct_name(what[tag_macro_name].str(), i)								<< endl <<
				"{"																																				<< endl <<
				"\tstatic bool evaluate(arguments_reference xs)"													<< endl <<
				"\t{"																																			<< endl;

				if (is_cracked_handler(what[tag_macro_name].str()))
					out << "\t\tBOOST_STATIC_ASSERT(has_cracked_handlers);"									<< endl;

			out <<
				""																								<< endl <<
				gen_function_body(macro_body, i)									<<
				"\treturn false;"																	<< endl <<
				"\t}"																							<< endl <<
				"};"																							<< endl;
		}
	}

	return out.str();
}

} // namespace

int _tmain(int argc, char* argv[])
{
	if (argc > 1)
	{
		for (int i = 1; i < argc; ++i)
		{
			string filename = argv[i];
			ifstream fin(filename.c_str());
			assert(fin.good());

			string in;
			getline(fin, in, '\0');

			string result = parse(in);

			string out_name(filename);
			out_name += ".ipp";
			ofstream fout(out_name.c_str());
			assert(fout.good());
			fout << result;
		}
	}
	return 0;
}

