///////////////////////////////////////////////////////////////////////////////
// gen_message_map_statement.hpp
//
// Concepts:
//  ConditionSeq is...
//    a MPL Sequence of Condition
//  Condition is...
//    a type which has a static member function, 
//    bool evaluate(Args);
//
// Note:
//  gen_message_map_statement can't touch Args type,
//  so you should choose whether referenced or not.
//

#ifndef KETCHUP_GEN_MESSAGE_MAP_STATEMENT_H
#define KETCHUP_GEN_MESSAGE_MAP_STATEMENT_H

#ifdef _MSC_VER
#pragma once
#endif

#include <boost/concept_check.hpp>
#include <boost/mpl/reverse_fold.hpp>

namespace ketchup { namespace detail {

///////////////////////////////////////////////////////////////////////////////
// Note:
//  If ConditionSeq has the same Condition, VC7.1 duplicates
//  the static member function, Condition::evaluate (LNK1179 error).
//  I can't understand the problem,
//  but VC7.1 seems to hate static member functions.
//  So I define fold_op_workaround and...
//
// evaluate_condition
//
template< class Condition, class Args >
bool evaluate_condition(Args xs)
{
	return Condition::evaluate(xs);
}

///////////////////////////////////////////////////////////////////////////////
// big_condition
//
template< class ConditionSeq, class Args >
struct gen_message_map_statement
{
	struct fold_init_state
	{
		static BOOL compile(Args xs)
		{
			boost::ignore_unused_variable_warning(xs);
			return FALSE;
		}
	};
	
	/*
	template< class State, class Condition >
	struct fold_op
	{
		static BOOL compile(Args xs)
		{
			if (detail::evaluate_condition<Condition, Args>(xs))
				return TRUE;
			else
				return State::compile(xs);
		}
	};
	*/

	// The placeholders say mpl_assert_not_arg, so I define
	struct fold_op_workaround
	{
		template< class State, class Condition >
		struct apply
		{
			static BOOL compile(Args xs)
			{
				if (detail::evaluate_condition<Condition, Args>(xs))
					return TRUE;
				else
					return State::compile(xs);
			}

			typedef apply type;
		};
	};

	typedef typename boost::mpl::reverse_fold<ConditionSeq,
		fold_init_state,
		// fold_op<boost::mpl::_1, boost::mpl::_2> // makes mpl_assert_not_arg
		fold_op_workaround
	>::type type;
};

} } // namespace ketchup::detail

#endif
