# -*-perl-*-
# Keitairc::SessionManager
# $Id: SessionManager.pm,v 1.2 2008/01/09 19:43:25 morimoto Exp $
# $Source: /cvsroot/keitairc/lib/Keitairc/SessionManager.pm,v $
#
# Copyright (c) 2008 Jun Morimoto <morimoto@mrmt.net>
# This program is covered by the GNU General Public License 2

package Keitairc::SessionManager;
use strict;

################################################################
# my $sm = new Keitairc::SessionManager;
# ץ ttl ǽ
# my $sm = new Keitairc::SessionManager({default_ttl => 120});
sub new{
	my $proto = shift;
	my $arg = shift;
	my $me = {};
	$me->{sessions} = {};
	$me->{default_ttl} = $arg->{default_ttl} || 60 * 30;
        bless $me;
}

################################################################
# $sm->verify({session_id => $session_id, user_agent => $user_agent});
# $sm->verify({serial_key => $serial_key, user_agent => $user_agent});
sub verify{
	my $me = shift;
	my $arg = shift;
	my $user_agent = $me->normalize_user_agent($arg->{user_agent});
	my $s;

	::log_debug("sm->verify: sid [$arg->{session_id}] serial_key [$arg->{serial_key}] user_agent [$arg->{user_agent}]");

	if(defined $arg->{serial_key}){
		if($s = $me->search_by_serial_key($arg->{serial_key}, $user_agent)){
			# ˹פͭʥå󤬸Ĥä
			# ॹפ򹹿֤
			return $me->refresh($s->{id}, $user_agent);
		}
	}

	if(defined $arg->{session_id}){
		if($s = $me->search_by_session_id($arg->{session_id}, $user_agent)){
			# ˹פͭʥå󤬸Ĥä
			# ॹפ򹹿֤
			return $me->refresh($s->{id}, $user_agent);
		}
	}
}

################################################################
# ΥåIDʸΥå󤬤뤫Ĵ١
# å󥪥֥Ȥ֤
# $sm->search_by_session_id($session_id, $user_agent);
sub search_by_session_id{
	my $me = shift;
	my $session_id = shift;
	my $user_agent = shift;

	$user_agent = $me->normalize_user_agent($user_agent);
	if(my $s = $me->{sessions}->{$session_id}){
		if($s->{user_agent} eq $user_agent){
			if($s->{last_access_time} + $s->{ttl} >= time){
				return $s;
			}
		}
	}
}

################################################################
# ΥåIDʸΥå󤬤뤫Ĵ١
# å󥪥֥Ȥ֤
# $sm->search_by_serial_key($serial_key, $user_agent);
sub search_by_serial_key{
	my $me = shift;
	my $serial_key = shift;
	my $user_agent = shift;

	$user_agent = $me->normalize_user_agent($user_agent);

	for my $id (keys(%{$me->{sessions}})){
		if($me->{sessions}->{$id}->{serial_key} eq $serial_key){
			if($me->{sessions}->{$id}->{user_agent} eq $user_agent){
				return $me->{sessions}->{$id};
			}
		}
	}
}

################################################################
# ΥåIDʸΥåκǽ򹹿
# å󥪥֥Ȥ֤
# $sm->refresh($session_id, $user_agent);
sub refresh{
	my $me = shift;
	my $session_id = shift;
	my $user_agent = shift;

	$user_agent = $me->normalize_user_agent($user_agent);

	# good time to gc, huh?
	$me->garbage_collect();

	if(my $s = $me->{sessions}->{$session_id}){
		if($s->{user_agent} eq $user_agent){
			$s->{last_access_time} = time;
			return $s;
		}
	}
}

################################################################
# ʥåϤᡢå󥪥֥Ȥ֤
# ǧڤľʤɡͭդʤȤʳˤäƤϤʤ
# $sm->add($user_agent, [$serial_key]);
sub add{
	my $me = shift;
	my $user_agent = shift;
	my $serial_key = shift;

	return unless length $user_agent;

	$user_agent = $me->normalize_user_agent($user_agent);

	my @id_chars = ('a'..'z', 'A'..'Z');
	my $session_id;
	srand(time % $$);
	do{
		$session_id = 'S';
		for(1..10){
			$session_id .= $id_chars[rand(@id_chars)];
		}
	}while(defined $me->{sessions}->{$session_id});

	my $s = $me->{sessions}->{$session_id} = {};
	$s->{id} = $session_id;
	$s->{ttl} = $me->{default_ttl};
	$s->{user_agent} = $user_agent;
	if(defined $serial_key){
		$s->{serial_key} = $serial_key;
	}
	$s->{last_access_time} = time;
	::log_debug("new session: " .
		    "id[$s->{id}]" .
		    "ua[$s->{user_agent}] " .
		    "time[$s->{last_access_time}] " .
		    "serial_key[$s->{serial_key}] " .
		    "ttl[$s->{ttl}]");
	$s;
}

################################################################
# TTL᤮å
# $sm->garbage_collect();
sub garbage_collect{
	my $me = shift;
	for my $id (keys(%{$me->{sessions}})){
		if(($me->{sessions}->{$id}->{last_access_time} +
		    $me->{sessions}->{$id}->{ttl}) < time){
			delete $me->{sessions}->{$id};
			::log_debug("deleted session: id[$id]");
		}
	}
}

################################################################
# USER_AGENTʸ󤫤顢åȽ˸ȤʤǤ
sub normalize_user_agent{
	my $me = shift;
	my $user_agent = shift;

	# ::log_debug("normalize_user_agent: user_agent[$user_agent]");

	# NTT DoCoMoFOMAü¤ֹ (15Υˡʱѿ) 
	# FOMA¤ֹ (20Υˡʱѿ) 
	# http://www.nttdocomo.co.jp/service/imode/make/content/html/tag/utn.html
	# DoCoMo/2.0 P703imyu(c100;TB;W30H15)
	# DoCoMo/2.0 P703imyu(c100;TB;W30H15;ser123451234512345;icc12345678901234567890)
	if($user_agent =~ m|^DoCoMo/|){
		$user_agent =~ s/;ser[0-9A-Z]{15}//;
		$user_agent =~ s/;icc[0-9A-Z]{20}//;
	}

	# SoftBank/Vodafone/J-PHONE
	# http://developers.softbankmobile.co.jp/dp/tool_dl/web/useragent.php
	if($user_agent =~ m!^(SoftBank|Vodafone|J-PHONE|MOT-)/!){
		$user_agent =~ s|/SN[0-9A-Z]+|/|;
	}

	# ::log_debug("normalize_user_agent: user_agent[$user_agent]");
	$user_agent;
}

1;
