# -*-perl-*-
# Keitairc::IrcBuffer
# $Id: IrcBuffer.pm,v 1.2 2008/01/09 18:47:01 morimoto Exp $
# $Source: /cvsroot/keitairc/lib/Keitairc/IrcBuffer.pm,v $
#
# Copyright (c) 2008 Jun Morimoto <morimoto@mrmt.net>
# This program is covered by the GNU General Public License 2

package Keitairc::IrcBuffer;
use strict;
use Encode;

################################################################
sub new{
	my $proto = shift;
	my $arg = shift;
	my $me = {};

	$me->{history} = $arg->{history};

	# join Ƥͥ̾ΤϿϥå (jis)
	$me->{name} = {};

	# join Ƥͥ̾ΤϿϥå (jis)
	$me->{topic} = {};

	# ͥβƤϿϥå (euc-jp)
	$me->{buffer} = {};
	$me->{unread} = {};

	# ƥͥκǽǿȯ
	$me->{mtime} = {};
	# ƥ̤ͥɹԿ
	$me->{unread_lines} = {};

	# chk
	$me->{message_added} = 0;

        bless $me;
}

################################################################
sub channels{
	my $me = shift;
	map {
		$me->{name}->{$_}
	}(sort { $me->mtime($b) <=> $me->mtime($a) } keys %{$me->{name}})
}

################################################################
sub now{
	my ($sec, $min, $hour) = localtime(time);
	sprintf('%02d:%02d', $hour, $min);
}

################################################################
sub canon_name{
	local($_) = shift;
	tr/A-Z[\\]^/a-z{|}~/;
	$_;
}

################################################################
sub part{
	my($me, $channel) = @_;
	my $cc = canon_name($channel);
	delete $me->{name}->{$cc};
}

################################################################
sub join{
	my($me, $channel) = @_;
	my $cc = canon_name($channel);
	$me->{name}->{$cc} = $channel;
}

################################################################
sub mtime{
	my($me, $channel) = @_;
	my $cc = canon_name($channel);
	$me->{mtime}->{$cc};
}

################################################################
sub name{
	my($me, $channel) = @_;
	my $cc = canon_name($channel);
	$me->{name}->{$cc};
}

################################################################
sub message_added{
	my($me, $v) = @_;
	if(defined $v){
		$me->{message_added} = $v;
	}
	$me->{message_added};
}

################################################################
sub unread_lines{
	my($me, $channel) = @_;
	my $cc = canon_name($channel);
	$me->{unread_lines}->{$cc};
}

################################################################
sub unread{
	my($me, $channel) = @_;
	my $cc = canon_name($channel);
	$me->{unread}->{$cc};
}

################################################################
sub clear_unread{
	my($me, $channel) = @_;
	my $cc = canon_name($channel);
	$me->{unread}->{$cc} = '';
	$me->{unread_lines}->{$cc} = 0;
}

################################################################
sub topic{
	my($me, $channel, $topic) = @_;
	my $cc = canon_name($channel);
	if(defined $topic){
		$me->{topic}->{$cc} = $topic;
	}
	$me->{topic}->{$cc};
}

################################################################
sub buffer{
	my($me, $channel) = @_;
	my $cc = canon_name($channel);
	$me->{buffer}->{$cc};
}

################################################################
#  $msg  euc-jp, $channel  jis
sub add_message{
	my($me, $channel, $message, $who) = @_;
	my $cc = canon_name($channel);

	if(length $who){
		$message = sprintf('%s %s> %s', now(), $who, $message);
	}else{
		$message = sprintf('%s %s', now(), $message);
	}

	{
		my @tmp = split("\n", $me->{buffer}->{$cc});
		push @tmp, $message;

		if(@tmp > $me->{history}){
			$me->{buffer}->{$cc} =
				CORE::join("\n", splice(@tmp, -$me->{history}));
		}else{
			$me->{buffer}->{$cc} = CORE::join("\n", @tmp);
		}
	}

	{
		my @tmp = split("\n", $me->{unread}->{$cc});
		push @tmp, $message;

		if(@tmp > $me->{history}){
			$me->{unread}->{$cc} =
				CORE::join("\n", @tmp[1 .. $me->{history}]);
		}else{
			$me->{unread}->{$cc} = CORE::join("\n", @tmp);
		}

		$me->{unread_lines}->{$cc} = scalar(@tmp);
	}

	if($me->{unread_lines}->{$cc} > $me->{history}){
		$me->{unread_lines}->{$cc} = $me->{history};
	}

	$me->{mtime}->{$cc} = time;
}

################################################################
# ͥ̾Τû
sub compact_channel_name{
	my $me = shift;
	my $name = shift;

	$name = decode('jis', $name);

	# #name:*.jp  %name 
	if($name =~ s/:\*\.jp$//){
		$name =~ s/^#/%/;
	}

	# ñȤ @ ϼ (plumץ饰multicast.plmк)
	$name =~ s/\@$//;

	encode('shiftjis', $name);
}

################################################################
sub simple_escape{
	my $me = shift;
        local($_) = shift;
        s/&/&amp;/g;
        s/>/&gt;/g;
        s/</&lt;/g;
        $_;
}

1;
