/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Hiroyuki Ikezoe
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_DOWNLOADER_GRP_H__
#define __KZ_DOWNLOADER_GRP_H__

#include "kz-downloader.h"

G_BEGIN_DECLS

#define KZ_TYPE_DOWNLOADER_GRP		  (kz_downloader_grp_get_type ())
#define KZ_DOWNLOADER_GRP(obj)		  (G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_DOWNLOADER_GRP, KzDownloaderGrp))
#define KZ_DOWNLOADER_GRP_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_DOWNLOADER_GRP, KzDownloaderGrpClass))
#define KZ_IS_DOWNLOADER_GRP(obj)	  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_DOWNLOADER_GRP))
#define KZ_IS_DOWNLOADER_GRP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_DOWNLOADER_GRP))
#define KZ_DOWNLOADER_GRP_GET_CLASS(obj)  (G_TYPE_INSTANCE_CHECK_GET_CLASS ((obj), KZ_TYPE_DOWNLOADER_GRP, KzDownloaderGrpClass))

typedef struct _KzDownloaderGrp      KzDownloaderGrp;
typedef struct _KzDownloaderGrpClass KzDownloaderGrpClass;

struct _KzDownloaderGrp
{
	GObject parent;
	/* downloader item list */
	GSList *items;
};

struct _KzDownloaderGrpClass
{
	GObjectClass parent_class;

	/* -- signals -- */
	void (*add)      (KzDownloaderGrp *downloader);
	void (*remove)   (KzDownloaderGrp *downloader);
	void (*error)    (KzDownloaderGrp *downloader);
	void (*progress) (KzDownloaderGrp *downloader);
};

GType            kz_downloader_grp_get_type (void);
KzDownloaderGrp *kz_downloader_grp_new      (void);

void  kz_downloader_grp_dispose (GObject *object);

/* singleton */
KzDownloaderGrp *kz_downloader_grp_get_instance (void);

void kz_downloader_grp_add_item    (KzDownloaderGrp *dlgrp, KzDownloader *dl);
void kz_downloader_grp_remove_item (KzDownloaderGrp *dlgrp, KzDownloader *dl);

G_END_DECLS

#endif /* __KZ_DOWNLOADER_GRP_H__ */
