/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2002 Hiroyuki Ikezoe
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <glib.h>

#ifndef __KZ_EMBED_EVENT_H__
#define __KZ_EMBED_EVENT_H__

G_BEGIN_DECLS

typedef enum
{
	KZ_ALT_KEY   = (1 << 0),
	KZ_CTRL_KEY  = (1 << 1),
	KZ_SHIFT_KEY = (1 << 2),
	KZ_META_KEY  = (1 << 3),
	KZ_KEY_CODE  = (1 << 4)
} KzEmbedEventKeyModifier;


typedef enum
{
	KZ_CONTEXT_NONE      = 0,
	KZ_CONTEXT_DEFAULT   = (1 << 0),
	KZ_CONTEXT_LINK      = (1 << 1),
	KZ_CONTEXT_IMAGE     = (1 << 2),
	KZ_CONTEXT_DOCUMENT  = (1 << 3),
	KZ_CONTEXT_INPUT     = (1 << 4),
	KZ_CONTEXT_SELECTION = (1 << 5),
	KZ_CONTEXT_OTHER     = (1 << 6),
	KZ_CONTEXT_XUL       = (1 << 7),
	KZ_CONTEXT_FRAME     = (1 << 8)
} KzEmbedEventContext;


typedef enum
{
	KZ_EMBED_EVENT_KEY,
	KZ_EMBED_EVENT_MOUSE
} KzEmbedEventType;

typedef struct
{
	KzEmbedEventType type;

	gint     context;
	gboolean framed_page; /* not used yet */

	gchar *link;
	gchar *linktext;
	gchar *img;
	gchar *frame_src;

} KzEmbedEvent;

typedef struct
{
	KzEmbedEvent cinfo;
	gint key;
	gint modifier;
	gint char_code;
} KzEmbedEventKey;

typedef struct
{
	KzEmbedEvent cinfo;
	gint button;
	gint modifier;
	gint x, y;

	guint timestamp; /* not used yet */
} KzEmbedEventMouse;


KzEmbedEvent *kz_embed_event_new  (KzEmbedEventType type);
void          kz_embed_event_free (KzEmbedEvent    *cinfo);

G_END_DECLS

#endif /* __KZ_EMBED_EVENT_H__ */
