/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef KZ_ENTRY_ACTION_H
#define KZ_ENTRY_ACTION_H

#include <gtk/gtk.h>

G_BEGIN_DECLS

#define KZ_TYPE_ENTRY_ACTION            (kz_entry_action_get_type ())
#define KZ_ENTRY_ACTION(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_ENTRY_ACTION, KzEntryAction))
#define KZ_ENTRY_ACTION_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_ENTRY_ACTION, KzEntryActionClass))
#define KZ_IS_ENTRY_ACTION(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_ENTRY_ACTION))
#define KZ_IS_ENTRY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((obj), KZ_TYPE_ENTRY_ACTION))
#define KZ_ENTRY_ACTION_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), KZ_TYPE_ENTRY_ACTION, KzEntryActionClass))

typedef struct _KzEntryAction      KzEntryAction;
typedef struct _KzEntryActionClass KzEntryActionClass;

struct _KzEntryAction
{
	GtkAction parent;

	gchar *text;
};

struct _KzEntryActionClass
{
	GtkActionClass parent_class;

	GtkEntry *(*get_entry_widget) (KzEntryAction *action,
				       GtkWidget *proxy);
};

GType        kz_entry_action_get_type (void) G_GNUC_CONST;

void         kz_entry_action_set_text (KzEntryAction *action,
				       const gchar *text);
const gchar *kz_entry_action_get_text (KzEntryAction *action);

/* protected */
GtkEntry    *kz_entry_action_get_entry_widget (KzEntryAction *action,
					       GtkWidget *proxy);

G_END_DECLS

#endif /* KZ_ENTRY_ACTION_H */
