/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2004 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#define MOZILLA_INTERNAL_API
#include <nsIServiceManager.h>
#undef MOZILLA_INTERNAL_API
#include <nsIWindowWatcher.h>
#include <nsIWebBrowserChrome.h>
#include <nsIEmbeddingSiteWindow.h>
#include <nsCOMPtr.h>
#define MOZILLA_STRICT_API
#include <nsEmbedString.h>
#undef MOZILLA_STRICT_API

#include "kz-mozutils.h"

/*
 * this codes was taken from embedding/browser/gtk/src/GtkPromptService.cpp 
 * in Mozilla-1.7.3.
 *
 */
GtkWidget *
GetGtkWindowForDOMWindow(nsIDOMWindow* aDOMWindow)
{
	nsCOMPtr<nsIWindowWatcher> wwatch = do_GetService("@mozilla.org/embedcomp/window-watcher;1");

	if (!aDOMWindow)
		return NULL;

	nsCOMPtr<nsIDOMWindow> topWindow;
	aDOMWindow->GetTop(getter_AddRefs(topWindow));
	if (!topWindow)
		return NULL;

	nsCOMPtr<nsIWebBrowserChrome> chrome;
	wwatch->GetChromeForWindow(topWindow, getter_AddRefs(chrome));
	nsCOMPtr<nsIEmbeddingSiteWindow> siteWindow = do_QueryInterface(chrome);

	if (!siteWindow)
		return NULL;

	GtkWidget* parentWidget;
	siteWindow->GetSiteWindow((void**)&parentWidget);

	if (!parentWidget)
		return NULL;

	GtkWidget* gtkWin = gtk_widget_get_toplevel(parentWidget);
	if (GTK_WIDGET_TOPLEVEL(gtkWin))
		return gtkWin;

	return NULL;
}

gboolean  NewURI		    (nsIURI **result,
    				     const char *spec)
{
	nsresult rv;

	nsEmbedCString cSpec(spec);
	nsCOMPtr<nsIIOService> ioService;
	rv = GetIOService (getter_AddRefs (ioService));
	NS_ENSURE_SUCCESS (rv, rv);

	rv = ioService->NewURI (cSpec, nsnull, nsnull, result);

}


