/*
 *  Copyright (C) 2004 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  $Id: MozillaPrivate.h 3177 2007-04-13 06:50:10Z ikezoe $
 */

/*
 * Based on MozillaPrivate.cpp in Epiphany-1.5.1.
 *  Copyright (C) 2003, 2004 Marco Pesenti Gritti
 */

#ifndef __MOZILLA_PRIVATE_H__
#define __MOZILLA_PRIVATE_H__

#include <glib.h>
#include <gtk/gtk.h>
#define MOZILLA_INTERNAL_API
#include <nsIPrintSettings.h>
#include <nsIDOMWindow.h>
#include <nsIDOMDocument.h>
#include <nsIDOMRange.h>
#include <nsISelection.h>
#include <nsIDocShell.h>
#include <nsIBaseWindow.h>
#include <nsIDOMEventReceiver.h>
#undef MOZILLA_INTERNAL_API
#ifdef MOZ_NSICANVASRENDERINGCONTEXTINTERNAL_HAVE_GETINPUTSTREAM_
#include "egg-pixbuf-thumbnail.h"
#endif

namespace MozillaPrivate
{
	GList    *GetPrinterList      ();
	gboolean  CreatePrintSettings (nsIPrintSettings **options);
	gboolean  GetRootRange        (nsIDOMDocument *domDoc, nsIDOMRange *range);
	gboolean  GetSelectedRange    (nsIDOMDocument *domDoc, nsIDOMRange *range,
				       nsISelection *selection, gboolean backward);
	gboolean  SetZoomOnDocShell   (float aZoom, nsIDocShell *DocShell);
	GdkWindow *GetGdkWindow       (nsIBaseWindow *window);
	gboolean  GetEventReceiver    (nsIDOMWindow *domWindow, nsIDOMEventReceiver **receiver);
	gchar    *GetURIForDOMWindow  (nsIDOMWindow *aDOMWindow);
	const char *Unescape          (const char *text);	
#ifdef MOZ_NSICANVASRENDERINGCONTEXTINTERNAL_HAVE_GETINPUTSTREAM_
	gboolean  CreateThumbnail     (nsIDOMWindow *domWindow,
                                       const gchar *uri,
                                       guint last_modified,
                                       EggPixbufThumbSize size);
#endif
}
#endif /* __MOZILLA_PRIVATE_H__ */
