/*
 *  Copyright (C) 2003, 2004 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  $Id: MozillaEmbedPrivate.cpp 2922 2007-03-20 13:37:55Z ikezoe $
 */

/*
 * Based on MozillaPrivate.cpp in Epiphany-1.5.1.
 *  Copyright (C) 2003, 2004 Marco Pesenti Gritti
 */

#include "mozilla-config.h"

#include "config.h"

#include "MozillaEmbedPrivate.h"

#include <nsXPCOM.h>
#include <nsProfileDirServiceProvider.h>

/* IMPORTANT. Put only code that use internal mozilla strings (nsAutoString for
 * example) in this file. Note that you cannot use embed strings here,
 * the header inclusions will conflict.
 */



void    *MozillaEmbedPrivate::sProfileDirServiceProvider = nsnull;
nsIPref *MozillaEmbedPrivate::sPrefs       = nsnull;

MozillaEmbedPrivate::MozillaEmbedPrivate(void)
{
}
MozillaEmbedPrivate::~MozillaEmbedPrivate()
{
}

nsresult
MozillaEmbedPrivate::StartupProfile(const char *sProfileDir, const char *sProfileName)
{
  // initialize profiles
  if (sProfileDir && sProfileName) {
    nsresult rv;
    nsCOMPtr<nsILocalFile> profileDir;
    NS_NewNativeLocalFile(nsDependentCString(sProfileDir), PR_TRUE,
                          getter_AddRefs(profileDir));
    if (!profileDir)
      return NS_ERROR_FAILURE;
    rv = profileDir->AppendNative(nsDependentCString(sProfileName));
    if (NS_FAILED(rv))
      return NS_ERROR_FAILURE;

    nsCOMPtr<nsProfileDirServiceProvider> locProvider;
    NS_NewProfileDirServiceProvider(PR_TRUE, getter_AddRefs(locProvider));
    if (!locProvider)
      return NS_ERROR_FAILURE;
    rv = locProvider->Register();
    if (NS_FAILED(rv))
      return rv;
    rv = locProvider->SetProfileDir(profileDir);
    if (NS_FAILED(rv))
      return rv;
    
    nsProfileDirServiceProvider *provider;
    // Keep a ref so we can shut it down.
    NS_ADDREF(provider = locProvider);
    sProfileDirServiceProvider = (void*)provider;

    // get prefs
    nsCOMPtr<nsIPref> pref;
    pref = do_GetService(NS_PREF_CONTRACTID);
    if (!pref)
      return NS_ERROR_FAILURE;
    sPrefs = pref.get();
    NS_ADDREF(sPrefs);
  }
  return NS_OK;
}

/* static */
void
MozillaEmbedPrivate::ShutdownProfile(void)
{
  if (sProfileDirServiceProvider) {
    nsProfileDirServiceProvider *provider = (nsProfileDirServiceProvider *)sProfileDirServiceProvider;
    provider->Shutdown();
    NS_RELEASE(provider);
    sProfileDirServiceProvider = 0;
  }
  if (sPrefs) {
    NS_RELEASE(sPrefs);
    sPrefs = 0;
  }
}

