/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include <unistd.h>
#include <libxml/parser.h>
#include <gtkmozembed.h>

#include "kz-window.h"
#include "kz-mozembed.h"
#include "prefs.h"
#include "rssbar.h"

static void rssbar_rss_menu_new(KzWindow *kz, GtkWidget* rssbar, RSS *rss);

/**
 * menu_position_under_widget:
 * this function from galeon-1.2.7
 */
static void
menu_position_under_widget (GtkMenu *menu, gint *x, gint *y,
			    gboolean *push_in, gpointer user_data)
{
	GtkWidget *w = GTK_WIDGET(user_data);
	gint wheight;
	gint wx, wy;

	gdk_window_get_origin(w->window, x, y);
	wheight = w->requisition.height;
	wx = w->allocation.x;
	wy = w->allocation.y;
	
	*y = *y + wy + wheight;
	*x = *x + wx;
}

static void
rssbar_button_press_cb(GtkWidget *widget, GdkEvent *event,
		       RSS *rss)
{
	KzWindow *kz;
	GdkEventButton *event_button;
	GSList *items;
	guint item_num, n;
	RSSItem *item = NULL;
	
	kz = g_object_get_data(G_OBJECT(widget), "Kazehakase");
	
	if (event->type == GDK_BUTTON_PRESS) {
		event_button = (GdkEventButton *)event;
		if (event_button->button == 1) {
			gtk_menu_popup(GTK_MENU(rss->SubMenu), NULL, NULL, 
				       menu_position_under_widget,
				       widget,
				       event_button->button, event_button->time);
		} else if (event_button->button == 2) {
			items = rss->items;
			item_num = g_slist_length(rss->items);
			for (n = 1; n < item_num; n++)
			{
				item = (RSSItem*) g_slist_nth_data(items, n);
				if (item->link)
					kz_window_open_new_tab(kz, item->link);
			}
		} else if (event_button->button == 3) {
			kz_window_load_url(kz, rss->rss_link);
		}
	}
}

/* create a new rss menu */
static void
rssbar_rss_menu_new(KzWindow *kz, GtkWidget* toolbar, RSS *rss)
{
	rss->MenuItem = gtk_menu_item_new_with_label(rss->title);
/*	menu_item_image = gtk_image_new_from_stock(GTK_STOCK_REFRESH, 
						   GTK_ICON_SIZE_MENU);
	rss->MenuItem = gtk_image_menu_item_new_with_label(rss->title);
	gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(rss->MenuItem),
				      menu_item_image);
*/	
/*	gtk_menu_shell_append(GTK_MENU_SHELL(toolbar), rss->MenuItem);*/
     	g_object_set_data(G_OBJECT(rss->MenuItem),"Kazehakase", kz);
	g_signal_connect(G_OBJECT(rss->MenuItem), "button_press_event",
			 G_CALLBACK(rssbar_button_press_cb), rss);
	gtk_toolbar_append_widget(GTK_TOOLBAR(toolbar), rss->MenuItem,
				  rss->rss_date, rss->rss_date);

	if (rss->update_interval)
	  gtk_timeout_add(60000 * rss->update_interval, (void *)&rss_update, rss);
}

void
rssbar_parse_site_element (xmlNodePtr cur, KzBookmarkBar *kztoolbar)
{
	RSS *rss=NULL;

	rss = g_new0(RSS,1);
	rss->SubMenu = NULL;
	
	rss->uri             = xmlGetProp(cur, "uri");
	rss->title           = xmlGetProp(cur, "title");
	rss->localfile       = xmlGetProp(cur, "local");
	if (xmlGetProp(cur, "interval"))
		rss->update_interval = atoi(xmlGetProp(cur,"interval"));
	
	rssbar_rss_menu_new(kztoolbar->parent_kazehakase,
			    GTK_WIDGET(kztoolbar), rss);
	g_slist_append(kztoolbar->items, rss);
}
