/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <string.h>
#include <unistd.h>
#include <gtk/gtk.h>
#include <libxml/parser.h>
#include <libxml/xpath.h>
#include <libxml/nanohttp.h>
#include <gtkmozembed.h>

#include "kz-window.h"
#include "kz-mozembed.h"
#include "prefs.h"
#include "rssbar.h"

static RSSItem *rss_item_new(xmlDocPtr doc, xmlNodePtr cur);

static void
rss_menu_button_press_cb(GtkWidget *widget, GdkEventButton *event,
			 RSSItem *item)
{
	KzWindow *kz;

	kz = g_object_get_data(G_OBJECT(widget), "Kazehakase");
	
	if (!item->link) return;

	switch (event->button) {
	case 1:
	case 3:
		kz_window_load_url(kz, item->link);
		break;
	case 2:
		kz_window_open_new_tab(kz, item->link);
		break;
	}
}

static void
rss_file_fetch(RSS *rss)
{
	gchar *contentType;

/*	KzWindow *kz = g_object_get_data(G_OBJECT(rss->MenuItem), "Kazehakase"); */
/*	gtk_widget_set_style(GTK_WIDGET(rss->MenuItem), kz->loading_text_style); */
	xmlNanoHTTPScanProxy(prefs.proxy);
	if (g_file_test(rss->localfile, G_FILE_TEST_EXISTS))
		remove (rss->localfile);
	xmlNanoHTTPFetch(rss->uri, rss->localfile, &contentType);	
}

static void
rss_file_load(RSS *rss)
{
	/* these code from gkrellm-newstikcer */
	xmlDocPtr  doc = NULL;
	xmlNodePtr cur;
	xmlNodePtr cur_child;
	xmlXPathContextPtr context;
	xmlXPathObjectPtr xpath_result;
	int i;

	xmlSubstituteEntitiesDefault(1);

	if (rss->items)
		g_slist_free(rss->items);
	rss->items = g_slist_alloc();

	doc = xmlParseFile(rss->localfile);
	if (!doc) return;

	rss->rss_link = NULL;
	cur = xmlDocGetRootElement(doc);
	if (!cur) return;

	cur = cur->xmlChildrenNode;
	context = xmlXPathNewContext(doc);
	xpath_result = xmlXPathEval((const xmlChar*)"//*", context);
	if (!xpath_result->nodesetval) return;

	for (i = 0; i < xpath_result->nodesetval->nodeNr; ++i)
	{
		/* read url */
		if (!strcmp(xpath_result->nodesetval->nodeTab[i]->name, "channel"))
		{
			cur_child = xpath_result->nodesetval->nodeTab[i]->xmlChildrenNode;
			for (;cur_child; cur_child = cur_child->next)
			{
				if (xmlIsBlankNode(cur_child)) continue;

				if (!xmlStrcmp(cur_child->name, (const xmlChar*) "link"))
					rss->rss_link = xmlNodeListGetString(doc, cur_child->xmlChildrenNode, 1);
				else if(!xmlStrcmp(cur_child->name, (const xmlChar*) "title"))
					rss->rss_title = xmlNodeListGetString(doc, cur_child->xmlChildrenNode, 1);
				else if(!xmlStrcmp(cur_child->name, (const xmlChar*) "description"))
					rss->rss_description = xmlNodeListGetString(doc, cur_child->xmlChildrenNode, 1);
				else if(!xmlStrcmp(cur_child->name, (const xmlChar*) "date"))
					rss->rss_date = xmlNodeListGetString(doc, cur_child->xmlChildrenNode, 1);
			}
		}

		/* read items */
		else if (!strcmp(xpath_result->nodesetval->nodeTab[i]->name, "item"))
		{
			cur_child = xpath_result->nodesetval->nodeTab[i]->xmlChildrenNode;
			g_slist_append(rss->items, rss_item_new(doc, cur_child));
		}
	}
}

static void
rss_menu_item_new(KzWindow *kz, RSS *rss)
{
	GtkWidget *menu_item;
	GSList *items;
	guint item_num, n;
	RSSItem *item = NULL;
	GtkTooltips *tooltip = NULL;
	
	if (rss->SubMenu != NULL)
	{
		gtk_widget_destroy(rss->SubMenu);
		gtk_menu_item_remove_submenu(GTK_MENU_ITEM(rss->MenuItem));
	}

	rss->SubMenu = gtk_menu_new();
	
	items = rss->items;
	item_num = g_slist_length(rss->items);

	for (n = 1; n < item_num; n++)
	{
		item = (RSSItem*) g_slist_nth_data(items, n);

		menu_item = gtk_menu_item_new_with_label(item->title);
		gtk_menu_shell_append(GTK_MENU_SHELL(rss->SubMenu),
				     menu_item);
		g_object_set_data(G_OBJECT(menu_item), "Kazehakase", kz);
		g_signal_connect(G_OBJECT(menu_item), "button_press_event",
				 G_CALLBACK(rss_menu_button_press_cb), item);
		tooltip = gtk_tooltips_new();
		gtk_tooltips_set_tip(tooltip, menu_item, item->description, NULL);
	}
	gtk_menu_item_set_submenu (GTK_MENU_ITEM(rss->MenuItem), rss->SubMenu);
	gtk_widget_show_all(rss->SubMenu);
}

void
rss_menu_update(RSS *rss)
{
	KzWindow *kz = g_object_get_data(G_OBJECT(rss->MenuItem), "Kazehakase");
	rss_file_fetch(rss);
	rss_file_load(rss);
	rss_menu_item_new(kz, rss);
	gtk_widget_show_all(kz->kztoolBar);
/*	g_thread_exit(NULL);*/
}

static RSSItem *
rss_item_new(xmlDocPtr doc, xmlNodePtr cur)
{
	RSSItem *item =NULL;
	item = g_new0(RSSItem, 1);
	
	for (; cur; cur = cur->next)
	{
		if (xmlIsBlankNode(cur)) continue;

		if(!xmlStrcmp(cur->name, (const xmlChar*) "title"))
			item->title  = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
		else if(!xmlStrcmp(cur->name, (const xmlChar*) "description"))
			item->description = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
		else if(!xmlStrcmp(cur->name, (const xmlChar*) "date"))
			item->date = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
		else if(!xmlStrcmp(cur->name, (const xmlChar*) "link"))
			item->link = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	}
	return item;
}

void
rss_update(RSS *rss)
{
/*	GThread *thread;
	if (!g_thread_supported())
	  g_thread_init(NULL);
	
	thread = g_thread_create((void *)&rss_menu_update, rss, FALSE, NULL);
*/
	rss_menu_update(rss);
}
