/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2002 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __MOZILLA_H__
#define __MOZILLA_H__

#include <gtk/gtk.h>
#include <gtkmozembed.h>

G_BEGIN_DECLS

/**
 * MozillaKeyModifier: key modifiers
 */
typedef enum
{
	ALT_KEY   = (1 << 0),
	CTRL_KEY  = (1 << 1),
	SHIFT_KEY = (1 << 2),
	META_KEY  = (1 << 3),
	KEY_CODE  = (1 << 4)
} MozillaKeyModifier;

#define CONTEXT_NONE     0
#define CONTEXT_DEFAULT  1
#define CONTEXT_LINK     2
#define CONTEXT_IMAGE    4
#define CONTEXT_DOCUMENT 8
#define CONTEXT_INPUT    64
#define CONTEXT_OTHER    128
#define CONTEXT_XUL      256

typedef struct
{
	gchar *img;
	gchar *link;
	gchar *linktext;
	
	gboolean framed_page;
	
	gint context;
} ContextInfo;

typedef struct
{
	ContextInfo cinfo;
	int key;
	gint modifier;
} KeyEventInfo;

typedef struct
{
	ContextInfo cinfo;
	gint button;
	gint modifier;
	guint timestamp;
} MouseEventInfo;

gchar    *mozilla_get_title            (GtkMozEmbed *embed);
gchar    *mozilla_get_link_message     (GtkMozEmbed *embed);
glong     mozilla_get_mouse_event_info (GtkMozEmbed *b,
					gpointer event,
					MouseEventInfo *info);
gchar    *mozilla_get_title            (GtkMozEmbed *embed);
gchar    *mozilla_get_link_message     (GtkMozEmbed *embed);
gint      mozilla_get_button           (gpointer event);
gint      mozilla_get_mouse_position   (gpointer event,
					glong *x,
					glong *y);
gint      mozilla_get_key_code         (gpointer event,
					gulong *key_code);
gint      mozilla_get_char_code        (gpointer event,
					gulong *char_code);
gboolean  mozilla_find                 (GtkMozEmbed *b,
					const char *keyword,
					gboolean *didFind);
glong     mozilla_get_key_event_info   (GtkMozEmbed *b,
					gpointer event,
					KeyEventInfo *info);

/* Preferences */
gboolean  mozilla_preference_set         (const char *preference_name,
					  const char *new_value);
G_END_DECLS

#endif /* __MOZILLA_H__ */
