/*
 *  Copyright (C) 2006 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __RD_SNAIL_VIEW_H__
#define __RD_SNAIL_VIEW_H__

#include <gtk/gtk.h>

G_BEGIN_DECLS

#define RD_TYPE_SNAIL_VIEW            (rd_snail_view_get_type ())
#define RD_SNAIL_VIEW(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), RD_TYPE_SNAIL_VIEW, RdSnailView))
#define RD_SNAIL_VIEW_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), RD_TYPE_SNAIL_VIEW, RdSnailViewClass))
#define RD_IS_SNAIL_VIEW(obj)	  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RD_TYPE_SNAIL_VIEW))
#define RD_IS_SNAIL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RD_TYPE_SNAIL_VIEW))
#define RD_SNAIL_VIEW_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), RD_TYPE_SNAIL_VIEW, RdSnailViewClass))

typedef struct _RdSnailView		RdSnailView;
typedef struct _RdSnailViewClass	RdSnailViewClass;

struct _RdSnailView
{
	GtkLayout  parent;
};

struct _RdSnailViewClass
{
	GtkLayoutClass parent_class;
};

GtkType	          rd_snail_view_get_type  (void);

GtkWidget        *rd_snail_view_new       (void);

GtkWidget        *rd_snail_view_new_with_model (GtkTreeModel *model);

void              rd_snail_view_set_model      (RdSnailView *view, GtkTreeModel *model);

void		  rd_snail_view_scroll_to_path (RdSnailView *view, GtkTreePath *path);

void		  rd_snail_view_set_image_column (RdSnailView *view, gint column);

G_END_DECLS

#endif /* __RD_SNAIL_VIEW_H__ */
