#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <glib/gi18n.h>

#include "rendako.h"
#include "gecko.h"
#include "rd-window.h"
#include "rd-entry-window.h"

int
main (int argc, char **argv)
{
	bindtextdomain (GETTEXT_PACKAGE, RENDAKO_LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);

	gtk_init (&argc, &argv);

	if (!gecko_init ())
	{
		g_warning ("Failed to initialize Gecko engine!");
		gecko_term ();
		return 1;
	}
	
	g_set_application_name (_("Rendako"));

	if (argv[1])
	{
		GtkWidget *main_window;

		main_window = rd_window_new();
		gtk_widget_show (main_window);

		if (g_str_has_prefix (argv[1], "http://"))
		{
			rd_window_load_uri (RD_WINDOW (main_window), argv[1]);
		}
		else
		{
			gchar *uri;
			uri = g_strconcat (SEARCH_ENGINE, argv[1], NULL);
			rd_window_load_uri (RD_WINDOW (main_window), uri);
			g_free (uri);
		}
	}
	else
	{
		GtkWidget *entry_window;

		entry_window = rd_entry_window_new ();
		gtk_widget_show (entry_window);
	}

	gtk_main ();

	gecko_term ();

	return 0;
}

