/*
 *  Copyright (C) 2006 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __RD_OPEN_SEARCH_H__
#define __RD_OPEN_SEARCH_H__

#include <glib-object.h>

G_BEGIN_DECLS

#define RD_TYPE_OPEN_SEARCH		(rd_open_search_get_type ())
#define RD_OPEN_SEARCH(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), RD_TYPE_OPEN_SEARCH, RdOpenSearch))
#define RD_OPEN_SEARCH_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass),  RD_TYPE_OPEN_SEARCH, RdOpenSearchClass))
#define RD_IS_OPEN_SEARCH(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), RD_TYPE_OPEN_SEARCH))
#define RD_IS_OPEN_SEARCH_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass),  RD_TYPE_OPEN_SEARCH))
#define RD_OPEN_SEARCH_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj),  RD_TYPE_OPEN_SEARCH, RdOpenSearchClass))

typedef struct _RdOpenSearch		RdOpenSearch;
typedef struct _RdOpenSearchClass	RdOpenSearchClass;

struct _RdOpenSearch
{
	GObject parent;
};

struct _RdOpenSearchClass
{
	GObjectClass parent_class;
	
	/* signals */
	void (*link)         (RdOpenSearch *open_search,
			      const gchar *uri);
};

GType		 rd_open_search_get_type  (void);

RdOpenSearch	*rd_open_search_new       (void);

void		 rd_open_search_keyword   (RdOpenSearch *os, const gchar *keyword);

G_END_DECLS

#endif /* __RD_OPEN_SEARCH_H__ */
