#ifndef __GECKO_THUMBNAILER_H__
#define __GECKO_THUMBNAILER_H__

#include <nsCOMPtr.h>
#include <nsIWebBrowser.h>
#include <nsIBaseWindow.h>
#include <gtk/gtk.h>
#include "GeckoProgress.h"
#include "rd-thumbnailer.h"

class GeckoProgress;

class GeckoThumbnailer
{
public:
	GeckoThumbnailer ();
	~GeckoThumbnailer ();
	NS_IMETHODIMP Init            (RdThumbnailer *owner);
	NS_IMETHODIMP Destroy         ();
	NS_IMETHODIMP AppendQueue     (const char *uri);
	NS_IMETHODIMP GetWebBrowser   (nsIWebBrowser * *aWebBrowser);
	NS_IMETHODIMP SetWebBrowser   (nsIWebBrowser * aWebBrowser);
	NS_IMETHODIMP CreateThumbnail ();
	PRBool	      IsCreating      ();

	nsCOMPtr<nsIWebBrowser> mWebBrowser;
private:
	RdThumbnailer *mOwner;
	gchar *mURI;
	GtkWidget *mParentWidget;
	GtkWidget *mWidget;
	GeckoProgress *mProgress;
	nsCOMPtr<nsISupports> mProgressGuard;
	nsCOMPtr<nsIBaseWindow> mBaseWindow;
	PRBool mCreating;
};

#endif /* __GECKO_THUMBNAILER_H__ */
