#include "GeckoPrivate.h"

#include <nsCOMPtr.h>
#include <nsEmbedString.h>
#include <nsIIOService.h>
#include <nsNetCID.h>

inline const nsGetServiceByCIDWithError
do_GetIOService(nsresult* error = 0)
{
    static NS_DEFINE_CID(kIOServiceCID, NS_IOSERVICE_CID);
    return nsGetServiceByCIDWithError(kIOServiceCID, error);
}

NS_IMETHODIMP
GeckoPrivate::DrawWindow (nsIDOMCanvasRenderingContext2D *domCanvas,
			  nsIDOMWindow *domWindow, PRInt32 w, PRInt32 h)
{
	nsresult rv;

	nsEmbedCString cURI ("rgb(255,255,255)");
	nsEmbedString URI;
	NS_CStringToUTF16 (cURI, NS_CSTRING_ENCODING_UTF8, URI);

	rv = domCanvas->DrawWindow (domWindow, 0, 0, w, h, URI); 

	return rv;
}

NS_IMETHODIMP
GeckoPrivate::LoadURI (nsIWebNavigation *navigation, const char *uri)
{
	nsresult rv;

	nsEmbedCString cURI (uri);
	nsEmbedString URI;
	NS_CStringToUTF16 (cURI, NS_CSTRING_ENCODING_UTF8, URI);

	rv = navigation->LoadURI(URI.get(), nsIWebNavigation::LOAD_FLAGS_NONE, 
				 nsnull, nsnull, nsnull);
	return rv;
}

NS_IMETHODIMP
GeckoPrivate::NewURI (nsIURI **URI, const char *uri)
{
	nsresult rv;

	nsCOMPtr<nsIIOService> ioService;
	ioService = do_GetIOService (&rv);

	rv = ioService->NewURI (nsEmbedCString(uri), nsnull, nsnull, URI);

	return rv;	
}

