/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003-2004 Hiroyuki Ikezoe
 *  Copyright (C) 2003-2004 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copyED of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "kz-embed.h"

#include "gobject-utils.h"

enum {
	LINK_MESSAGE_SIGNAL,
	JS_STATUS_SIGNAL,
	LOCATION_SIGNAL,
	TITLE_SIGNAL,
	NET_START_SIGNAL,
	NET_STOP_SIGNAL,
	LAST_SIGNAL
};

static void kz_embed_base_init (gpointer g_class);
static gint kz_embed_signals[LAST_SIGNAL] = {0};

GType
kz_embed_get_type (void)
{
	static GType type = 0;
	if (!type)
	{
		static const GTypeInfo info = {
			sizeof (KzEmbedIFace),
			kz_embed_base_init, /* base_init :*/
			NULL,               /* base_finalize */
			NULL,               /* class_init */
			NULL,               /* class_finalize */
			NULL,               /* class_data */
			0,
			0,                  /* n_preallocs */
			NULL,               /* instance_init */
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "KzEmbed",
					       &info, 0);
		g_type_interface_add_prerequisite (type,
						   G_TYPE_OBJECT);
	}
	return type;
}

static void
kz_embed_base_init (gpointer g_class)
{
	static gboolean initialized = FALSE;

	if (initialized) return;

	kz_embed_signals[LINK_MESSAGE_SIGNAL]
		= g_signal_new ("link-message",
				KZ_TYPE_EMBED,
				G_SIGNAL_RUN_FIRST,
				G_STRUCT_OFFSET (KzEmbedIFace, link_message),
				NULL, NULL,
				g_cclosure_marshal_VOID__VOID,
				G_TYPE_NONE, 0);

	kz_embed_signals[JS_STATUS_SIGNAL]
		= g_signal_new ("jz-status",
				KZ_TYPE_EMBED,
				G_SIGNAL_RUN_FIRST,
				G_STRUCT_OFFSET (KzEmbedIFace, js_status),
				NULL, NULL,
				g_cclosure_marshal_VOID__VOID,
				G_TYPE_NONE, 0);

	kz_embed_signals[LOCATION_SIGNAL]
		= g_signal_new ("locatoin",
				KZ_TYPE_EMBED,
				G_SIGNAL_RUN_FIRST,
				G_STRUCT_OFFSET (KzEmbedIFace, location),
				NULL, NULL,
				g_cclosure_marshal_VOID__VOID,
				G_TYPE_NONE, 0);

	kz_embed_signals[TITLE_SIGNAL]
		= g_signal_new ("title",
				KZ_TYPE_EMBED,
				G_SIGNAL_RUN_FIRST,
				G_STRUCT_OFFSET (KzEmbedIFace, title),
				NULL, NULL,
				g_cclosure_marshal_VOID__VOID,
				G_TYPE_NONE, 0);

	/* progress */

	/* net_state */

	kz_embed_signals[NET_START_SIGNAL]
		= g_signal_new ("net-start",
				KZ_TYPE_EMBED,
				G_SIGNAL_RUN_FIRST,
				G_STRUCT_OFFSET (KzEmbedIFace, net_start),
				NULL, NULL,
				g_cclosure_marshal_VOID__VOID,
				G_TYPE_NONE, 0);

	kz_embed_signals[NET_STOP_SIGNAL]
		= g_signal_new ("net-stop",
				KZ_TYPE_EMBED,
				G_SIGNAL_RUN_FIRST,
				G_STRUCT_OFFSET (KzEmbedIFace, net_stop),
				NULL, NULL,
				g_cclosure_marshal_VOID__VOID,
				G_TYPE_NONE, 0);

	/* new_window */

	/* visibility */

	/* destroy_embed */

	/* open_uri */

	/* size_to */
}
