/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Takuro Ashie
 *  Copyright (C) 2004 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "prefs_history.h"

#include <string.h>
#include "kazehakase.h"
#include "utils/intl.h"
#include "utils/gtk-utils.h"


#define DATA_KEY "KzPrefsHistory::info"


static GtkWidget     *prefs_history_create      (void);
static void           prefs_history_response    (GtkWidget *widget,
						 gint       response);


static KzPrefsWinPageEntry prefs_entry =
{
	path:            N_("/History"),
	priority_hint:   0,
	ui_level:        ~KZ_UI_LEVEL_BEGINNER,
	create:          prefs_history_create,
	response:        prefs_history_response,
};


typedef struct _KzPrefsHistory
{
	GtkWidget     *main_vbox;
	GtkWidget     *limit_days_check;
	GtkWidget     *limit_days_spin;
	gboolean       changed;
} KzPrefsHistory;


static void
cb_limit_days_toggled(GtkToggleButton *button, KzPrefsHistory *prefsui)
{
	gtk_widget_set_sensitive(prefsui->limit_days_spin,
				 gtk_toggle_button_get_active(button));
	prefsui->changed = TRUE;
}

static void
cb_changed (GtkWidget *widget, KzPrefsHistory *prefsui)
{
	prefsui->changed = TRUE;
}


static void
prefs_history_destroy (gpointer data)
{
	KzPrefsHistory *prefsui = data;

	g_free(prefsui);
}


static GtkWidget *
prefs_history_create (void)
{
	KzPrefsHistory *prefsui = g_new0(KzPrefsHistory, 1);
	GtkWidget *main_vbox, *hbox, *frame;
	GtkWidget *label, *check, *spin;
	GtkAdjustment *adj;
	gboolean limit;
	gint limit_days;

	main_vbox = gtk_vbox_new(FALSE, 0);
	prefsui->main_vbox = main_vbox;
	g_object_set_data_full(G_OBJECT(main_vbox), DATA_KEY,
			       prefsui, prefs_history_destroy);

	label = kz_prefs_ui_utils_create_title(_("History"));
	gtk_box_pack_start(GTK_BOX(main_vbox), label,
			   FALSE, FALSE, 0);
	gtk_widget_show(label);


	/*
	 *  History Cache 
	 */
	frame = gtk_frame_new(_("History cache"));
	gtk_frame_set_label_align(GTK_FRAME(frame), 0.03, 0.5);
	gtk_container_set_border_width(GTK_CONTAINER(frame), 5);
	gtk_box_pack_start(GTK_BOX(main_vbox), frame, FALSE, FALSE, 2);
	gtk_widget_show(frame);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(hbox), 4);
	gtk_container_add(GTK_CONTAINER(frame), hbox);
	gtk_widget_show(hbox);

	limit = TRUE;
	KZ_CONF_GET("History", "limit_cache", limit, BOOL);

	limit_days = 30;
	KZ_CONF_GET("History", "limit_days", limit_days, INT);

	check = gtk_check_button_new_with_mnemonic(_("_Limit days of keeping the history cache"));
	prefsui->limit_days_check = check;
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check), limit);
	gtk_box_pack_start(GTK_BOX(hbox), check, FALSE, FALSE, 2);
	g_signal_connect(G_OBJECT(check), "toggled",
			 G_CALLBACK(cb_limit_days_toggled), prefsui);
	gtk_widget_show(check);

	prefsui->limit_days_spin = spin
		= gtk_spin_button_new_with_range(1, 1000, 1);
	adj = gtk_spin_button_get_adjustment(GTK_SPIN_BUTTON(spin));
	gtk_adjustment_set_value(adj, limit_days);
	gtk_box_pack_start(GTK_BOX(hbox), spin, FALSE, FALSE, 2);
	gtk_widget_set_sensitive(spin, limit);
	g_signal_connect(G_OBJECT(spin), "value-changed",
			 G_CALLBACK(cb_changed), prefsui);
	gtk_widget_show(spin);

	prefsui->changed = FALSE;

	return main_vbox;
}


static void
prefs_history_response (GtkWidget *widget, gint response)
{
	KzPrefsHistory *prefsui = g_object_get_data(G_OBJECT(widget), DATA_KEY);

	g_return_if_fail(prefsui);

	switch (response) {
	case GTK_RESPONSE_ACCEPT:
	case GTK_RESPONSE_APPLY:
	{
		GtkAdjustment *adj;
		gint limit_days;
		gboolean limit;

		if (!prefsui->changed)
			break;

		limit = gtk_toggle_button_get_active
				(GTK_TOGGLE_BUTTON(prefsui->limit_days_check));
		KZ_CONF_SET("History", "limit_cache", limit, BOOL);

		adj = gtk_spin_button_get_adjustment
			(GTK_SPIN_BUTTON(prefsui->limit_days_spin));
		limit_days = gtk_adjustment_get_value(adj);
		KZ_CONF_SET("History", "limit_days", limit_days, INT);

		prefsui->changed = FALSE;

		break;
	}
	case GTK_RESPONSE_REJECT:
		break;
	case KZ_RESPONSE_UI_LEVEL_MEDIUM:
		break;
	case KZ_RESPONSE_UI_LEVEL_EXPERT:
		break;
	case KZ_RESPONSE_UI_LEVEL_CUSTOM:
		break;
	default:
		break;
	}
}


KzPrefsWinPageEntry *
prefs_history_get_entry (gint idx)
{
	if (idx == 0)
		return &prefs_entry;
	else
		return NULL;
}
