/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Hiroyuki Ikezoe
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_HTTP_H__
#define __KZ_HTTP_H__

#include <glib-object.h>
#include "kz-io.h"

G_BEGIN_DECLS

#define KZ_TYPE_HTTP		(kz_http_get_type ())
#define KZ_HTTP(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_HTTP, KzHTTP))
#define KZ_HTTP_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass),  KZ_TYPE_HTTP, KzHTTPClass))
#define KZ_IS_HTTP(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_HTTP))
#define KZ_IS_HTTP_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass),  KZ_TYPE_HTTP))
#define KZ_HTTP_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj),  KZ_TYPE_HTTP, KzHTTPClass))

#define KZ_TYPE_HTTP_METHOD_TYPE (kz_http_method_type_get_type())

typedef struct _KzHTTP KzHTTP;
typedef struct _KzHTTPClass KzHTTPClass;
typedef struct _KzHTTPPrivate KzHTTPPrivate;

typedef enum {
	KZ_HTTP_METHOD_GET,
	KZ_HTTP_METHOD_HEAD
} KzHTTPMethodType;


struct _KzHTTP
{
	KzIO parent;
	
	KzHTTPPrivate *priv;
};

struct _KzHTTPClass
{
	KzIOClass parent_class;
};

GType   kz_http_method_type_get_type (void);

GType   kz_http_get_type (void);
KzHTTP *kz_http_new             (const gchar *uri);

G_END_DECLS

#endif /* __KZ_HTTP_H__ */
