unit Katjusha;
{ `ANZXpNX }

interface

uses Windows, Classes, StrUtils, SysUtils, Contnrs, IniFiles, Variants, SyncObjs, HashList, Dialogs,
	IdHttp, IdHTTPHeaderInfo, IdException, XDOM_2_3_J3;

type
	EKatjushaError = class(Exception);

	{ T2chCustomIniFile }

	T2chCustomIniFile = class(TPersistent)
	private
		FInternalIniFile: TMemIniFile;
	protected
		procedure DoUpdate(IniFile: TMemIniFile; Direction: Boolean); virtual; abstract;
	public
		constructor Create;
		destructor Destroy; override;
		procedure LoadFromFile(const FileName: string); virtual;
		procedure SaveToFile(const FileName: string); virtual;
		procedure Clear; virtual;
	end;

{ T2chBoard class }

	T2chBoard = class(TStringList)
	public
		procedure LoadFromFile(const FileName: string); override;
		procedure LoadFromStream(Stream: TStream); override;
		procedure OtherLoadFromStream(Stream: TStream); virtual;
	end;

{ T2chThreadIndex class }

	T2chThreadState = (stNormal = $20, stLog = $10, stFavorite = $40);
	T2chThreadStates = set of T2chThreadState;
	T2chResponseState = (rsNone, rsNew, rsError, rsCheck);
	TDynamicStrArray = array of string;

	E2chThreadError = class(EKatjushaError);
	T2chThreadIndex = class;
	T2chThreadDat = class;
	T2chThreadIndex = class(TPersistent)
	private
		IndexArray: TDynamicStrArray;
		FExtraIndex: string;
		FState: T2chThreadStates;
		FThreadName: string;
		FBoardName: string;
		FServerName: string;
		FBoardPath: string;
		FDateTime: TDateTime;
		FWriteTime: TDateTime;
		FNumber: Integer;
		FThreadNum: Currency;
		FBeforeResCount: Integer;		{ X }
		FResCount: Integer;					{ X }
		FNewResCount: Integer;			{ VX }
//		FInStore: Boolean;					{ qɗǂ }
		FGravity: Integer;					{ dvx? }
		FMemo: string;							{  }
		FDatSize: Integer;
		FInFavorite: Boolean;
		FDepth: Integer;						{ [x }
		FModified: Boolean;
    procedure SetThreadName(const Value: string);
		procedure SetBoardName(const Value: string);
		procedure SetServerName(const Value: string);
		procedure SetBeforeResCount(const Value: Integer);
    procedure SetBoardPath(const Value: string);
		procedure SetDateTime(const Value: TDateTime);
    procedure SetGravity(const Value: Integer);
		procedure SetMemo(const Value: string);
    procedure SetNewResCount(const Value: Integer);
		procedure SetNumber(const Value: Integer);
    procedure SetResCount(const Value: Integer);
		procedure SetThreadNum(const Value: Currency);
    procedure SetWriteTime(const Value: TDateTime);
		procedure SetState(const Value: T2chThreadStates);
		function GetLogPath: string;
		function GetURL: string;
    procedure SetDatSize(const Value: Integer);
		procedure SetInFavorite(const Value: Boolean);
    function GetDatPath: string;
    procedure SetDepth(const Value: Integer);
	public
		ResState: T2chResponseState;
    constructor Create;
		procedure Assign(Source: TPersistent); override;
    procedure AssignTo(Dest: TPersistent); override;
		procedure LoadFromFile(const FileName: string); virtual;
		procedure LoadFromStream(Stream: TStream); virtual;
		procedure SaveToFile(const FileName: string); virtual;
		procedure SaveToStream(Stream: TStream); virtual;
		function GetLastPrefix(Count: Integer): string;
		function GetResStartPrefix(Num: Integer): string;
		function GetResDirectPrefix(Num: Integer): string;
		function GetResRangePrefix(StartNum, EndNum: Integer): string;
		function GetThreadDat: T2chThreadDat;
		property LogPath: string read GetLogPath;
		property DatPath: string read GetDatPath;
		property URL: string read GetURL;
		property Modified: Boolean read FModified;
		property State: T2chThreadStates read FState write SetState;
		property ThreadName: string read FThreadName write SetThreadName;
		property BoardName: string read FBoardName write SetBoardName;
		property ServerName: string read FServerName write SetServerName;
		property BoardPath: string read FBoardPath write SetBoardPath;
		property DateTime: TDateTime read FDateTime write SetDateTime;
		property WriteTime: TDateTime read FWriteTime write SetWriteTime;
		property Number: Integer read FNumber write SetNumber;
		property ThreadNum: Currency read FThreadNum write SetThreadNum;
		property BeforeResCount: Integer read FBeforeResCount write SetBeforeResCount;
		property ResCount: Integer read FResCount write SetResCount;
		property NewResCount: Integer read FNewResCount write SetNewResCount;
		property Gravity: Integer read FGravity write SetGravity;
		property Memo: string read FMemo write SetMemo;
		property DatSize: Integer read FDatSize write SetDatSize;
		property InFavorite: Boolean read FInFavorite write SetInFavorite;
		property Depth: Integer read FDepth write SetDepth;
	end;
	T2chThreadGetUrl = function(ThreadIdx: T2chThreadIndex): string of object;
	T2chThreadGetParam = function(ThreadIdx: T2chThreadIndex; Num: Integer): string of object;

{ T2chThreadDat }

  E2chThreadDatError = class(Exception);
	T2chThreadDat = class(TStringList)
	private
		FCommaSplit: Boolean;
		FModified: Boolean;
		FFileName: string;
		FLoadFromFileCalled: Boolean;
		function GetDate(Index: Integer): string;
		function GetDateTime(Index: Integer): Variant;
		function GetMail(Index: Integer): string;
		function GetName(Index: Integer): string;
		function GetMessage(Index: Integer): string;
	protected
		function Get(Index: Integer): string; override;
		procedure Put(Index: Integer; const S: string); override;
	public
		procedure Save;
    procedure LoadFromFile(const FileName: string); override;
		procedure Aborn(Index: Integer; Invisible: Boolean);
		function IdAborn(const IdStr: string; const Invisible: Boolean): Integer;
		procedure LoadFromStream(Stream: TStream); override;
    procedure SaveToStream(Stream: TStream); override;
		procedure Split(Index: Integer; var StrArray: array of string);
    property Strings[Index: Integer]: string read Get write Put; default;
		property Dates[Index: Integer]: string read GetDate;
		property DateTimes[Index: Integer]: Variant read GetDateTime;
		property Mails[Index: Integer]: string read GetMail;
		property Messages[Index: Integer]: string read GetMessage;
		property Names[Index: Integer]: string read GetName;
		property Modified: Boolean read FModified;
		property CommaSplited: Boolean read FCommaSplit write FCommaSplit;
	end;

{ T2chIndexList }

	T2chThreadSortType = (tsNone, tsBoardName, tsTitle, tsMemo, tsThreadNum, tsGravity, tsBeforeResCount, tsResCount, tsNewResCount, tsResDiff, tsDateTime, tsCheckRes, tsDepth, tsAsc, tsDec);
	T2chThreadSortTypes = set of T2chThreadSortType;
	P2chThreadSortTypes = ^T2chThreadSortTypes;
	T2chCustomSortList = class(TPersistent)
	private
		InternalList: TList;
    function Get(Index: Integer): T2chThreadSortTypes;
    function GetCount: Integer;
    procedure Put(Index: Integer; const Value: T2chThreadSortTypes);
	public
		constructor Create;
		destructor Destroy; override;
		procedure Add(SortTypes: T2chThreadSortTypes);
		procedure Clear;
    procedure Assign(Source: TPersistent); override;
		property Count: Integer read GetCount;
    property Items[Index: Integer]: T2chThreadSortTypes read Get write Put; default;
	end;
	T2chCustomSortObjectList = class(TPersistent)
	private
		Internal: TStringList;
    function Get(Index: Integer): T2chCustomSortList;
    function GetCount: Integer;
    function GetNames(Index: Integer): string;
    procedure Put(Index: Integer; const Value: T2chCustomSortList);
    procedure SetNames(Index: Integer; const Value: string);
	public
		constructor Create;
		destructor Destroy; override;
		function Add(const Name: string; SortList: T2chCustomSortList): Integer;
		function Delete(Index: Integer): T2chCustomSortList;
		procedure Assign(Source: TPersistent); override;
		procedure Clear;
		procedure LoadFromXML(const FileName: string);
		procedure SaveToXML(const FileName: string);
		property Count: Integer read GetCount;
		property Names[Index: Integer]: string read GetNames write SetNames;
		property Items[Index: Integer]: T2chCustomSortList read Get write Put; default;
	end;
	T2chIndexList = class;
	T2chIndexList = class(TObjectList)
  private
		FDisplayName: string;	{ \Xbhqɖ }
		FModified: Boolean;
    function GetModified: Boolean;
    function GetModifyItemCount: Integer;	{ ύXtO }
	protected
		Lock: TCriticalSection;
		IndexList: THashList;
		function GetIndexItem(Index: Integer): T2chThreadIndex;
		procedure SetIndexItem(Index: Integer; AObject: T2chThreadIndex);
		procedure Notify(Ptr: Pointer; Action: TListNotification); override;
	public
		LibName: string;
		MasterIndex: T2chIndexList;
		constructor Create; overload;
    constructor Create(AOwnsObjects: Boolean); overload;
		constructor Create(Master: T2chIndexList; AOwnsObjects: Boolean = False); overload;
		destructor Destroy; override;
		function Add(AObject: TObject): Integer;
		function Extract(Item: T2chThreadIndex): T2chThreadIndex;
		function ThreadPathOf(const Idx: string): Integer;
		function LogPathOfObject(const LogPath: string): T2chThreadIndex;
		procedure BoardSort(SortKey1, SortKey2: T2chThreadSortTypes);
		procedure LoadFromFile(const FileName: string); virtual;
		procedure LoadFromStream(Stream: TStream); virtual;
    procedure SaveToFile(const FileName: string); virtual;
    procedure SaveToStream(Stream: TStream); virtual;
		property Items[Index: Integer]: T2chThreadIndex read GetIndexItem write SetIndexItem; default;
		property DisplayName: string read FDisplayName write FDisplayName;
		property Modified: Boolean read GetModified write FModified;
		property ModifyItemCount: Integer read GetModifyItemCount;
	end;

{ T2chSubject class }

  E2chSubjectError = class(EKatjushaError);
	T2chSubjectItem = record
		ThreadNum: Currency;
		Title: string;
		ResCount: Integer;
		Depth: Integer;
	end;
	P2chSubjectItem = ^T2chSubjectItem;
	T2chSubject = class;
	T2chSubjectIniFile = class;
	T2chSubject = class(TPersistent)
	private
		XmlInError: Boolean;
		InternalList: TStringList;
		FContentDate: TDateTime;	{ 擾 }
		function GetResCount(Index: Integer): Integer;
    function GetStrings(Index: Integer): string;
    function Get(Index: Integer): P2chSubjectItem;
    function GetCount: Integer;
		function GetDepth(Index: Integer): Integer;
		procedure XmlParserError(xmlToDomParser: TXmlToDomParser; e: TXmlParserError);
	public
		constructor Create;
		destructor Destroy; override;
		procedure Assign(Source: TPersistent); override;
		procedure Clear;
		procedure Add(const ThreadNum, Title: string; ResCount, Depth: Integer);
		procedure LoadFromFile(const FileName: string); virtual;
		procedure LoadFromStream(Stream: TStream); virtual;
		procedure LoadFromURL(const URL: string; IniFile: T2chSubjectIniFile = nil); virtual;
		procedure LoadFromXML(const FileName: string); virtual;
		procedure SaveToFile(const FileName: string); virtual;
		procedure SaveToStream(Stream: TStream); virtual;
		procedure SaveToXML(const FileName: string); virtual;
		function IndexOf(const S: string): Integer; overload;
		function IndexOf(const S: Currency): Integer; overload;
		function Diff(Dest, Source: T2chSubject): Integer;
		property Count: Integer read GetCount;
		property Depth[Index: Integer]: Integer read GetDepth;
		property ResCount[Index: Integer]: Integer read GetResCount;
		property Strings[Index: Integer]: string read GetStrings;
		property Items[Index: Integer]: P2chSubjectItem read Get; default;
		property ContentDate: TDateTime read FContentDate;
	end;
	{ TODO : ETagLast-ModifiedL^t@CiniƁAʂ̃t@Cɂ܂Ƃ߂邩YނAƂ肠iniɂ }
	T2chSubjectParamsItem = record
		ETag: string;
		LastModified: string;
	end;
	P2chSubjectParamsItem = ^T2chSubjectParamsItem;
	T2chSubjectParams = class
	private
		FList: THashList;
    function GetValue(Name: string): P2chSubjectParamsItem;
	public
		constructor Create;
		destructor Destroy; override;
		procedure LoadFromFile(const FileName: string); virtual;
		procedure LoadFromStream(Stream: TStream); virtual;
		procedure SaveToFile(const FileName: string); virtual;
		procedure SaveToStream(Stream: TStream); virtual;
		property Values[Name: string]: P2chSubjectParamsItem read GetValue;
	end;
	T2chSubjectIniFile = class(T2chCustomIniFile)
  private
    FLastModified: string;
    FETag: string;
	protected
		procedure DoUpdate(IniFile: TMemIniFile; Direction: Boolean); override;
	public
		procedure Clear; override;
		property ETag: string read FETag write FETag;
		property LastModified: string read FLastModified write FLastModified;
	end;

{ TKatjusha class }
	TKatjushaCommunicationParams = class
	public
		UserAgent: string;
		ProxyParams: TIdProxyConnectionInfo;
		ReadTimeOut: Integer;
		constructor Create;
		destructor Destroy; override;
	end;

	TKatjusha = class
	public
		constructor Create;
		destructor Destroy; override;
		function GetBoardUrl(const ServerName, BoardName: string): string;
		function GetFavoriteList(List: TStrings; IncludeFavorite: Boolean = False): Integer;
		procedure LoadPathInfo(const FileName: string);
		class procedure SetKatjushaBaseDir(const Dir: string);
		class function GetKatjushaBaseDir: string;
		class function IsKatjushaFolder: Boolean;
		class procedure ChangeKatjushaDirectoryInDebug(const Dir: string);
		class function GetCommParams: TKatjushaCommunicationParams;
		class function DefaultGetBoardUrl(const ServerName, BoardName: string): string;
		class function GetScriptManager: TObject;
		class procedure SetScriptManager(AScriptManager: TObject);
		class function GetPathInfo: TStringList;
		property PathInfo: TStringList read GetPathInfo;
	end;
	TKatjushaGetBoardUrl = function (PathInfo: TStringList; const ServerName, BoardName: string): string of object;
	T2chThreadSortTypeName = record
		SortType: T2chThreadSortType;
		Name: string;
	end;
	TParse2chURLData = record
		ServerName: string;
		BoardName: string;
		LogPath: string;
		ThreadNum: Currency;
		StartIndex: Integer;
		EndIndex: Integer;
	end;
	
const
	SortTypeName: array [0 .. 11] of T2chThreadSortTypeName =
		((SortType: tsNone; Name: 'Ȃ'),
		 (SortType: tsBoardName; Name: ''),
		 (SortType: tsTitle; Name: '^Cg'),
		 (SortType: tsMemo; Name: ''),
		 (SortType: tsThreadNum; Name: 'Xbhԍ'),
		 (SortType: tsGravity; Name: 'dvx'),
		 (SortType: tsBeforeResCount; Name: 'X'),
		 (SortType: tsResCount; Name: 'X'),
		 (SortType: tsNewResCount; Name: 'VX'),
		 (SortType: tsDateTime; Name: 'ǂݍݓ'),
		 (SortType: tsCheckRes; Name: 'V'),
		 (SortType: tsDepth; Name: '[x'));
{ ځ`񕶎 }
	KATJUSHA_ABORN = '<b>ځ`</b>,ځ`,ځ`,,';
	KATJUSHA_INVISIBLE_ABORN = '<b>ځ`</b>,ځ`,ځ`,,';
	BOARD_2CHANNEL_BRD = '2channel.brd';
	BOARD_OTHER_BRD = 'other.brd';

var
	Do2chThreadGetUrl: T2chThreadGetUrl = nil;
	Do2chThreadGetLastPrefix: T2chThreadGetParam = nil;
	Do2chThreadGetDatPath: T2chThreadGetUrl = nil;
	Do2chThreadGetResStartPrefix: T2chThreadGetParam = nil;
	DoKatjushaGetBoardUrl: TKatjushaGetBoardUrl = nil;

function SortTypeToName(SortType: T2chThreadSortType): string; overload;
function SortTypeToName(SortType: T2chThreadSortTypes): string; overload;
function Parse2chURL(const URL: string; var Data: TParse2chURLData): Boolean;
function StringSplit(Text: string; const SubStr: string; var List: array of string): Integer;

implementation

uses Math, ComCtrls, Regex, AWKFunc, XDOMIndent, FavUtils;

type
	T2chThreadSortList = class(TStringList)
	private
		SortKey1: T2chThreadSortTypes;
		SortKey2: T2chThreadSortTypes;
	end;

const
	{ Idxt@C̃Xg }
	IgnoreIdxList: array [0 .. 1] of string = ('favorite', 'favboard');

var
	KatjushaBaseDir: string;
	KatjushaCommParams: TKatjushaCommunicationParams;
	KatfavScriptManager: TKatfavScriptManager;
	KatjushaPathInfo: TStringList;

{ \[g^Cv𕶎ɕϊ }
function SortTypeToName(SortType: T2chThreadSortType): string; overload;
var
	I: Integer;
begin
	for I := Low(SortTypeName) to High(SortTypeName) do
	begin
		if SortTypeName[I].SortType = SortType then
		begin
			Result := SortTypeName[I].Name;
			Exit;
		end;
	end;

	raise EKatjushaError.Create('^Cv܂');
end;

function SortTypeToName(SortType: T2chThreadSortTypes): string; overload;
var
	I: Integer;
begin
	for I := Low(SortTypeName) to High(SortTypeName) do
	begin
		if SortTypeName[I].SortType in SortType then
		begin
			Result := SortTypeName[I].Name;
			Exit;
		end;
	end;

	raise EKatjushaError.Create('^Cv܂');
end;

function SortNameToSortType(const SortName: string): T2chThreadSortType;
var
	I: Integer;
begin
	for I := Low(SortTypeName) to High(SortTypeName) do
	begin
		if SortTypeName[I].Name = SortName then
		begin
			Result := SortTypeName[I].SortType;
			Exit;
		end;
	end;

	raise EKatjushaError.Create('^Cv܂');
end;

{ 2chURL͂ }
function Parse2chURL(const URL: string; var Data: TParse2chURLData): Boolean;
var
	UrlArray: array [0 .. 3] of string;
	Param, S: string;
{ URLToPath }
	function URLToPath(const URL: string): string;
	begin
		Result := AnsiReplaceStr(URL, '/', '_');
		Result := AnsiReplaceStr(Result, ':', '_');
	end;
begin
	Result := False;

	Data.ServerName := '';
	Data.BoardName := '';
	Data.ThreadNum := -1;

	if AnsiStartsText('http://', URL) then
	begin
		{ http://www.g-ch.jp/test/read.cgi?bbs=katjusha&key=1040554553&st=6&to=6&nofirst=true }
		if AWKMatch('http://(.+)/test/read.cgi\?(.+)$', URL, UrlArray) >= 0 then
		begin
			Data.ServerName := UrlArray[1];
			Param := UrlArray[2];

			if AWKMatch('bbs=(.+)&key=([^&]+)', Param, UrlArray) < 0 then
				Exit;

			Data.BoardName := UrlArray[1];
			Data.ThreadNum := StrToCurr(UrlArray[2]);

			Data.StartIndex := -1;
			if AWKMatch1('&st=([0-9]+)', Param, S) >= 0 then
				Data.StartIndex := StrToInt(S);
			
			Data.EndIndex := -1;
			if AWKMatch1('&to=([0-9]+)', Param, S) >= 0 then
				Data.EndIndex := StrToInt(S);

			Result := True;
		end else
		{ http://pc3.2ch.net/test/read.cgi/software/1040366058/141 }
		if AWKMatch('http://(.+)/test/read.cgi/(.+)$', URL, UrlArray) >= 0 then
		begin
			Data.ServerName := UrlArray[1];
			Param := UrlArray[2];

			if AWKMatch('^([^/]+)/([0-9]+)/(.*)$', Param, UrlArray) < 0 then
				Exit;

			Data.BoardName := UrlArray[1];
			Data.ThreadNum := StrToCurr(UrlArray[2]);

			Param := UrlArray[3];

			Data.StartIndex := -1;
			if AWKMatch1('^([0-9]+)', Param, S) >= 0 then
				Data.StartIndex := StrToInt(S);

			Data.EndIndex := -1;
			if AWKMatch1('-([0-9]+)', Param, S) >= 0 then
				Data.EndIndex := StrToInt(S);

			Result := True;
		end;

		Data.LogPath := '';
		if (Data.ServerName <> '') and (Data.BoardName <> '') and (Data.ThreadNum >= 0) then
			Data.LogPath := Format('%s/%s/%s.idx',
				[URLToPath(Data.ServerName), Data.BoardName, FormatCurr('000000000', Data.ThreadNum)]);
	end;
end;

{ ^uŋ؂ꂽXg֕ }
function TabSplit(var List: TDynamicStrArray; const str: string): Integer;
var
	I, Count: Integer;
	TmpStr: string;
begin
	TmpStr := '';
	Count := 0;

	for I := 1 to Length(str) do
	begin
		if str[I] = #$9 then
		begin
			Inc(Count);
			SetLength(List, Count);
			List[Count - 1] := TmpStr;
			TmpStr := '';
		end else
			TmpStr := TmpStr + str[I];
	end;

	if TmpStr <> '' then
	begin
		Inc(Count);
		SetLength(List, Count);
		List[Count - 1] := TmpStr;
	end;

	Result := Count;
end;

{CommaSplit}
function CommaSplit(var List: array of string; const str: string): Integer;
var
	I, Count: Integer;
	TmpStr: string;
begin
	TmpStr := '';
	Count := 0;

	for I := 1 to Length(str) do
	begin
		if str[I] = ',' then
		begin
			TmpStr := StringReplace(TmpStr, 'M', ',', [rfReplaceAll]);
			List[Count] := TmpStr;
			Inc(Count);
			TmpStr := '';
		end else
			TmpStr := TmpStr + str[I];
	end;

	if TmpStr <> '' then
	begin
		List[Count] := TmpStr;
		Inc(Count);
	end;

	Result := Count;
end;

{ StringSplit }
function StringSplit(Text: string; const SubStr: string; var List: array of string): Integer;
var
	I, Index, Count, Len: Integer;
begin
	Index := Low(List);
	Count := 0;
	Len := Length(SubStr);
	
	I := Pos(SubStr, Text);
	if I = 0 then
	begin
		List[Index] := Text;
		Result := 1;
		Exit;
	end;

	repeat
		List[Index] := Copy(Text, 1, I - 1);
		if Length(Text) < I + Len then
		begin
			Text := '';
			Break;
		end;
		Text := Copy(Text, I + Len, MaxInt);

		Inc(Index);
		Inc(Count);

		I := Pos(SubStr, Text);
	until I = 0;

	if Text <> '' then
	begin
		Inc(Count);
		List[Index] := Text;
	end;

	Result := Count;
end;

{ T2chCustomIniFile }

procedure T2chCustomIniFile.Clear;
begin
	if Assigned(FInternalIniFile) then
		FreeAndNil(FInternalIniFile);
end;

constructor T2chCustomIniFile.Create;
begin
	FInternalIniFile := nil;
end;

destructor T2chCustomIniFile.Destroy;
begin
	if Assigned(FInternalIniFile) then
		FreeAndNil(FInternalIniFile);
  inherited;
end;

procedure T2chCustomIniFile.LoadFromFile(const FileName: string);
begin
	if Assigned(FInternalIniFile) then
		FreeAndNil(FInternalIniFile);

	FInternalIniFile := TMemIniFile.Create(FileName);
	DoUpdate(FInternalIniFile, True);
end;

procedure T2chCustomIniFile.SaveToFile(const FileName: string);
var
	List: TStringList;
begin
	List := TStringList.Create;
	try
		if Assigned(FInternalIniFile) then
		begin
			DoUpdate(FInternalIniFile, False);

			if FInternalIniFile.FileName = FileName then
				FInternalIniFile.UpdateFile
			else begin
				FInternalIniFile.GetStrings(List);
				FreeAndNil(FInternalIniFile);
				FInternalIniFile := TMemIniFile.Create(FileName);
				FInternalIniFile.SetStrings(List);
				FInternalIniFile.UpdateFile;
			end;
		end else
		begin
			FInternalIniFile := TMemIniFile.Create(FileName);
			DoUpdate(FInternalIniFile, False);
			FInternalIniFile.UpdateFile;
		end;
	finally
		List.Free;
	end;
end;

{ T2chBoard }

procedure T2chBoard.LoadFromFile(const FileName: string);
var
  Stream: TFileStream;
begin
	(*** inherited; ***)
	Stream := TFileStream.Create(FileName, fmOpenRead or fmShareDenyWrite);
	try
		if AnsiCompareText(ExtractFileName(FileName), 'other.brd') = 0
			then OtherLoadFromStream(Stream)
			else LoadFromStream(Stream);
  finally
    Stream.Free;
	end;
end;

procedure T2chBoard.LoadFromStream(Stream: TStream);
var
	List, Board: TStringList;
	I: Integer;
	Tab: regex_t;
begin
	List := nil;
	Board := nil;
	AWKClearPattern(Tab);

	try
		List := TStringList.Create;
		Board := TStringList.Create;

		Clear;

		AWKCompilePattern(Tab, #9'+');

		List.LoadFromStream(Stream);
		BeginUpdate;
		for I := 0 to List.Count - 1 do
		begin
			Board.Clear;
			AWKSplit(Tab, List[I], Board);
			if (Board.Count = 2) then
				Add(Board[0])
			else if (Board.Count > 2) and (Board[1] <> '0') then
				Add(Board[1] + '/' + Board[2] + '<>' + Board[3]);
		end;
	finally
		EndUpdate;
		AWKFreePattern(Tab);
		List.Free;
		Board.Free;
	end;
end;

procedure T2chBoard.OtherLoadFromStream(Stream: TStream);
var
	List, Board: TStringList;
	I: Integer;
	Tab, LeftSpace: regex_t;
	Text: string;
begin
	List := nil;
	Board := nil;
	AWKClearPattern(Tab);
	AWKClearPattern(LeftSpace);

	try
		List := TStringList.Create;
		Board := TStringList.Create;

		(*** Clear; ***)
		Add('̑');	{ NA邩ɂ̑JeSǉ }

		AWKCompilePattern(Tab, #9'+');
		AWKCompilePattern(LeftSpace, '^['#9' ]+');
		
		List.LoadFromStream(Stream);
		BeginUpdate;
		for I := 0 to List.Count - 1 do
		begin
			{ 擪̋󔒕菜 }
			Text := AWKGSub(LeftSpace, '', List[I]);
			if Text = '' then Continue; { 󔒍s͔΂ }
			Board.Clear;
			AWKSplit(Tab, Text, Board);
			if Board.Count >= 3 then
				Add(Board[0] + '/' + Board[1] + '<>' + Board[2]);
		end;
	finally
		EndUpdate;
		AWKFreePattern(LeftSpace);
		AWKFreePattern(Tab);
		List.Free;
		Board.Free;
	end;
end;

{ TKatjusha }

class procedure TKatjusha.ChangeKatjushaDirectoryInDebug(
  const Dir: string);
begin
{$IFDEF FAV3DEBUG}
	SetCurrentDirectory(PChar(Dir));
{$ENDIF}
end;

constructor TKatjusha.Create;
begin
end;

class function TKatjusha.DefaultGetBoardUrl(const ServerName,
  BoardName: string): string;
begin
	Result := Format('http://%s/%s/', [ServerName, BoardName]);
end;

destructor TKatjusha.Destroy;
begin
  inherited;
end;

function TKatjusha.GetBoardUrl(const ServerName,
	BoardName: string): string;
begin
	if Assigned(DoKatjushaGetBoardUrl)
		then Result := DoKatjushaGetBoardUrl(KatjushaPathInfo, ServerName, BoardName)
		else Result := DefaultGetBoardUrl(ServerName, BoardName);
end;

class function TKatjusha.GetCommParams: TKatjushaCommunicationParams;
begin
	Result := KatjushaCommParams;
end;

function TKatjusha.GetFavoriteList(List: TStrings; IncludeFavorite: Boolean = False): Integer;
var
	SearchRec: TSearchRec;
	I, Count: Integer;
	Ignore: Boolean;
	FavoriteName: string;
begin
	GetFavoriteList := 0;
  Count := 0;

	if FindFirst('*.idx', faAnyFile, SearchRec) <> 0 then
		Exit;

	try
		repeat
			if ExtractFileExt(LowerCase(SearchRec.Name)) = '.idx' then
			begin
				Ignore := False;
				FavoriteName := LowerCase(ChangeFileExt(ExtractFileName(SearchRec.Name), ''));

				for I := Low(IgnoreIdxList) to High(IgnoreIdxList) do
					if FavoriteName = IgnoreIdxList[I] then
						Ignore := True;

				if IncludeFavorite and (FavoriteName = 'favorite') then
					 Ignore := False;

				if not Ignore then
				begin
					List.Add(ChangeFileExt(ExtractFileName(SearchRec.Name), ''));
					Inc(Count);
				end;
			end;
		until FindNext(SearchRec) <> 0;
	finally
		FindClose(SearchRec);
	end;
	
	GetFavoriteList := Count;
end;

class function TKatjusha.GetKatjushaBaseDir: string;
begin
	Assert(KatjushaBaseDir <> '');
	Result := KatjushaBaseDir;
end;

class function TKatjusha.GetPathInfo: TStringList;
begin
	Result := KatjushaPathInfo;
end;

class function TKatjusha.GetScriptManager: TObject;
begin
	Result := KatfavScriptManager;
end;

class function TKatjusha.IsKatjushaFolder: Boolean;
begin
	IsKatjushaFolder := False;

	if not FileExists('Katjusha.exe') then Exit;
	if not DirectoryExists('log') then Exit;
	
	IsKatjushaFolder := True;
end;

procedure TKatjusha.LoadPathInfo(const FileName: string);
begin
	try
		KatjushaPathInfo.LoadFromFile(FileName);
	except
		on EFOpenError do
		begin
			KatjushaPathInfo.Clear;
			Exit;
		end;
		else
			raise;
	end;
end;

class procedure TKatjusha.SetKatjushaBaseDir(const Dir: string);
begin
	KatjushaBaseDir := IncludeTrailingPathDelimiter(Dir);
end;

class procedure TKatjusha.SetScriptManager(AScriptManager: TObject);
begin
	KatfavScriptManager := AScriptManager as TKatfavScriptManager;
end;

{ T2chThreadIndex }

procedure T2chThreadIndex.LoadFromFile(const FileName: string);
var
	Stream: TStream;
begin
	Stream := TFileStream.Create(FileName, fmOpenRead or fmShareDenyWrite);
	try
		try
			LoadFromStream(Stream);
		except
			on E: E2chThreadError do
				raise E2chThreadError.CreateFmt('%s: %s', [FileName, E.Message]);
			else
				raise;
		end;
	finally
		Stream.Free;
	end;
end;

procedure T2chThreadIndex.LoadFromStream(Stream: TStream);
var
	IndexList: string;
	Val: Integer;
{MyStrToDateTime}
	function MyStrToDateTime(const S: string): TDateTime;
	begin
		{ yyyy/mm/dd hh:nn:ss }
		Result := EncodeDate(StrToInt(Copy(S, 1, 4)), StrToInt(Copy(S, 6, 2)), StrToInt(Copy(S, 9, 2))) +
							EncodeTime(StrToInt(Copy(S, 12, 2)), StrToInt(Copy(S, 15, 2)), StrToInt(Copy(S, 18, 2)), 0);
	end;
{LoadText}
	procedure LoadText(Stream: TStream; var Index, Extra: string);
	var
		Size, P: Integer;
		S: String;
	begin
		Size := Stream.Size - Stream.Position;
		SetString(S, nil, Size);
		Stream.Read(PChar(S)^, Size);

		P := Pos(#10, S);
		if P = 0 then Index := S
			else begin
				Index := Copy(S, 1, P - 2);
				Extra := Copy(S, P + 1, MaxInt);
			end;
	end;
begin
	LoadText(Stream, IndexList, FExtraIndex);

	TabSplit(IndexArray, IndexList);
	if High(IndexArray) < 17 then
		raise E2chThreadError.Create('IdxĂ܂B');

	FState := [];
	Val := StrToInt(IndexArray[1]);
	if (Val and $20) <> 0 then FState := FState + [stNormal];
	if (Val and $10) <> 0 then FState := FState + [stLog];
	if (Val and $40) <> 0 then FState := FState + [stFavorite];

	FGravity := StrToIntDef(IndexArray[2], 5);
	FThreadName := IndexArray[3];
	FServerName := IndexArray[4];
	FBoardPath := IndexArray[5];
	FThreadNum := StrToCurr(IndexArray[6]);
	FBeforeResCount := StrToInt(IndexArray[7]);
	FResCount := StrToInt(IndexArray[8]);
	FNewResCount := StrToIntDef(IndexArray[9], 0);
	FDateTime := MyStrToDateTime(IndexArray[10]);
	if IndexArray[11] <> '' then
		FWriteTime := MyStrToDateTime(IndexArray[11])
	else
		FWriteTime := 0;
	FBoardName := IndexArray[12];
	FDatSize := StrToInt(IndexArray[13]);
	FMemo := IndexArray[17];

	ResState := rsNone;
	if FBeforeResCount > FResCount then
		ResState := rsNew;

	{ QŃX1000zĂꍇ͑qɗƓɂ }
	if (Pos('2ch.net', FServerName) <> 0) and (FResCount >= 1000) then
		FState := FState + [stLog];
	{ ܂aaȑꍇ300 }
	if (Pos('machibbs.com', FServerName) <> 0) and (FResCount >= 300) then
		FState := FState + [stLog];
			
	FModified := False;
end;

function T2chThreadIndex.GetLogPath: string;
begin
	Result := Format('%s\%s\%s.idx', [AnsiReplaceText(ServerName, '/', '_'), BoardPath, FormatCurr('000000000', ThreadNum)]);
end;

function T2chThreadIndex.GetURL: string;
begin
	if Assigned(Do2chThreadGetUrl)
		then Result := Do2chThreadGetUrl(Self)
		else Result := Format('http://%s/test/read.cgi/%s/%s/', [ServerName, BoardPath, CurrToStr(ThreadNum)]);
end;

procedure T2chThreadIndex.Assign(Source: TPersistent);
var
	ThreadIdx: T2chThreadIndex;
begin
(*		ThreadName: string;
		BoardName: string;
		ServerName: string;
		BoardPath: string;
		DateTime: TDateTime;
		WriteTime: TDateTime;
		Number: Integer;
		ThreadNum: Currency;
		BeforeResCount: Integer;	{ X }
		ResCount: Integer;				{ X }
		NewResCount: Integer;			{ VX }
		InStore: Boolean;					{ qɗǂ }
		Gravity: Integer;					{ dvx? }*)
	if Source is T2chThreadIndex then
	begin
		ThreadIdx := T2chThreadIndex(Source);
		State := ThreadIdx.State;
		FThreadName := ThreadIdx.FThreadName;
		FBoardName := ThreadIdx.FBoardName;
		FServerName := ThreadIdx.FServerName;
		FBoardPath := ThreadIdx.FBoardPath;
		FDateTime := ThreadIdx.FDateTime;
		FWriteTime := ThreadIdx.FWriteTime;
		FNumber := ThreadIdx.FNumber;
		FThreadNum := ThreadIdx.FThreadNum;
		FBeforeResCount := ThreadIdx.FBeforeResCount;
		FResCount := ThreadIdx.FResCount;
		FNewResCount := ThreadIdx.FNewResCount;
	{	FInStore := ThreadIdx.FInStore;}
		FGravity := ThreadIdx.FGravity;
		FMemo := ThreadIdx.FMemo;
		FDatSize := ThreadIdx.FDatSize;
		ResState := ThreadIdx.ResState;
		FDepth := ThreadIdx.FDepth;

		IndexArray := Copy(ThreadIdx.IndexArray, 0, Length(ThreadIdx.IndexArray));
		FExtraIndex := ThreadIdx.FExtraIndex;
	end else
		inherited Assign(Source);
end;

procedure T2chThreadIndex.SetThreadName(const Value: string);
begin
	if FThreadName <> Value then
	begin
		FThreadName := Value;
		FModified := True;
	end;
end;

procedure T2chThreadIndex.SetBoardName(const Value: string);
begin
	if FBoardName <> Value then
	begin
		FBoardName := Value;
		FModified := True;
	end;
end;

procedure T2chThreadIndex.SetServerName(const Value: string);
begin
	if FServerName <> Value then
	begin
		FServerName := Value;
		FModified := True;
	end;
end;

procedure T2chThreadIndex.SetBeforeResCount(const Value: Integer);
begin
	if FBeforeResCount <> Value then
	begin
		FBeforeResCount := Value;
		FModified := True;
	end;
end;

procedure T2chThreadIndex.SetBoardPath(const Value: string);
begin
	if FBoardPath <> Value then
	begin
		FBoardPath := Value;
		FModified := True;
	end;
end;

procedure T2chThreadIndex.SetDateTime(const Value: TDateTime);
begin
	if FDateTime <> Value then
	begin
		FDateTime := Value;
		FModified := True;
	end;
end;

procedure T2chThreadIndex.SetGravity(const Value: Integer);
begin
	if FGravity <> Value then
	begin
		FGravity := Value;
		FModified := True;
	end;
end;

procedure T2chThreadIndex.SetMemo(const Value: string);
begin
	if FMemo <> Value then
	begin
		FMemo := Value;
		FModified := True;
	end;
end;

procedure T2chThreadIndex.SetNewResCount(const Value: Integer);
begin
	if FNewResCount <> Value then
	begin
		FNewResCount := Value;
		FModified := True;
	end;
end;

procedure T2chThreadIndex.SetNumber(const Value: Integer);
begin
	if FNumber <> Value then
	begin
		FNumber := Value;
		FModified := True;
	end;
end;

procedure T2chThreadIndex.SetResCount(const Value: Integer);
begin
	if FResCount <> Value then
	begin
		FResCount := Value;
		FModified := True;
	end;
end;

procedure T2chThreadIndex.SetThreadNum(const Value: Currency);
begin
	if FThreadNum <> Value then
	begin
		FThreadNum := Value;
		FModified := True;
	end;
end;

procedure T2chThreadIndex.SetWriteTime(const Value: TDateTime);
begin
	if FWriteTime <> Value then
	begin
		FWriteTime := Value;
		FModified := True;
	end;
end;

procedure T2chThreadIndex.SetState(const Value: T2chThreadStates);
begin
	if FState <> Value then
	begin
		FState := Value;
		FModified := True;
	end;
end;

procedure T2chThreadIndex.SaveToFile(const FileName: string);
var
	Stream: TStream;
begin
	Stream := TFileStream.Create(FileName, fmCreate);
	try
		SaveToStream(Stream);
	finally
		Stream.Free;
	end;
end;

procedure T2chThreadIndex.SaveToStream(Stream: TStream);
const
	DateFmt = 'yyyy/mm/dd hh:nn:ss';
var
	Val, I: Integer;
	IndexStr: string;
begin
	try
		Val := 0;
		if stNormal in FState then Val := Val or $20;
		if stLog in FState then Val := Val or $10;
		if stFavorite in FState then Val := Val or $40;
		IndexArray[1] := IntToStr(Val);

		IndexArray[2] := IntToStr(FGravity);
		IndexArray[3] := FThreadName;
		IndexArray[4] := FServerName;
		IndexArray[5] := FBoardPath;
		IndexArray[6] := CurrToStr(FThreadNum);
		IndexArray[7] := IntToStr(FBeforeResCount);
		IndexArray[8] := IntToStr(FResCount);
		IndexArray[9] := IntToStr(FNewResCount);
		IndexArray[10] := FormatDateTime(DateFmt, FDateTime);
		if FWriteTime = 0 then
			IndexArray[11] := ''
		else
			IndexArray[11] := FormatDateTime(DateFmt, FWriteTime);
		IndexArray[12] := FBoardName;
		IndexArray[13] := IntToStr(FDatSize);
		IndexArray[17] := FMemo;

		FModified := False;

		IndexStr := IndexArray[Low(IndexArray)];
		for I := Low(IndexArray) + 1 to High(IndexArray) do
			IndexStr := IndexStr + #$9 + IndexArray[I];
		if High(IndexArray) < 20 then
			IndexStr := IndexStr + StringOfChar(#$9, 20 - High(IndexArray));

		if FExtraIndex <> '' then
			IndexStr := IndexStr + #13#10 + FExtraIndex;

		Stream.Write(IndexStr[1], Length(IndexStr));
	finally
	end;
end;

procedure T2chThreadIndex.AssignTo(Dest: TPersistent);
begin
	if Dest is TListItem then
	begin
		with (Dest as TListItem) do
		begin
			Caption := FThreadName;
			SubItems.Clear;
			SubItems.Capacity := 8;

			SubItems.Add(IntToStr(FGravity - 5));
			SubItems.Add(IntToStr(FBeforeResCount));
			SubItems.Add(IntToStr(FResCount));
			if FNewResCount < 0 then
				SubItems.Add('')
			else
				SubItems.Add(IntToStr(FNewResCount));
			SubItems.Add(DateTimeToStr(FDateTime));
			if FWriteTime <> 0 then
				SubItems.Add(DateTimeToStr(FWriteTime))
			else
				SubItems.Add('');
			SubItems.Add(FBoardName);
			SubItems.Add(FMemo);
			case FDepth of
				Low(Integer) .. -1: SubItems.Add('-');
				0: SubItems.Add('');
				else
					SubItems.Add(IntToStr(FDepth));
			end;

			if stLog in FState then
				StateIndex := 2
			else
				case ResState of
					rsNone:		StateIndex := -1;
					rsCheck:	StateIndex := 0;
					rsNew:		StateIndex := 1;
					rsError:	StateIndex := 3;
				end;

			Data := Self;
		end;
	end else
		inherited;
end;

procedure T2chThreadIndex.SetDatSize(const Value: Integer);
begin
	if FDatSize <> Value then
	begin
		FDatSize := Value;
		FModified := True;
	end;
end;

procedure T2chThreadIndex.SetInFavorite(const Value: Boolean);
begin
	if Value and (not (stFavorite in State)) then
	begin
		State := State + [stFavorite];
		FModified := True;
	end;

	FInFavorite := Value;
end;

constructor T2chThreadIndex.Create;
begin
  inherited;
	ResState := rsNone;
	FDepth := -1;
end;

function T2chThreadIndex.GetLastPrefix(Count: Integer): string;
begin
	if Assigned(Do2chThreadGetLastPrefix)
		then Result := Do2chThreadGetLastPrefix(Self, Count)
		else Result := Format('l%d', [Count]);
end;

function T2chThreadIndex.GetDatPath: string;
begin
	if Assigned(Do2chThreadGetDatPath)
		then Result := Do2chThreadGetDatPath(Self)
		else Result := Format('http://%s/%s/dat/%s.dat', [FServerName, FBoardPath, CurrToStr(FThreadNum)]);
end;

function T2chThreadIndex.GetResStartPrefix(Num: Integer): string;
begin
	if Assigned(Do2chThreadGetResStartPrefix)
		then Result := Do2chThreadGetResStartPrefix(Self, Num)
		else Result := IntToStr(Num) + '-';
end;

procedure T2chThreadIndex.SetDepth(const Value: Integer);
begin
	{ Depth͕ۑȂ̂ModifiedύXȂ }
	FDepth := Value;
end;

function T2chThreadIndex.GetResDirectPrefix(Num: Integer): string;
var
	ScriptManager: TKatfavScriptManager;
begin
	ScriptManager := TKatjusha.GetScriptManager as TKatfavScriptManager;
	if ScriptManager = nil then
		raise E2chThreadError.Create('T2chThreadIndex: KatfavScriptManagernilłB');
	Result := ScriptManager.DoGetResDirectPrefix(Self, Num);
end;

function T2chThreadIndex.GetResRangePrefix(StartNum,
  EndNum: Integer): string;
var
	ScriptManager: TKatfavScriptManager;
begin
	ScriptManager := TKatjusha.GetScriptManager as TKatfavScriptManager;
	if ScriptManager = nil then
		raise E2chThreadError.Create('T2chThreadIndex: KatfavScriptManagernilłB');
	Result := ScriptManager.DoGetResRangePrefix(Self, StartNum, EndNum);
end;

function T2chThreadIndex.GetThreadDat: T2chThreadDat;
begin
	Result := T2chThreadDat.Create;
	try
		Result.LoadFromFile(TKatjusha.GetKatjushaBaseDir + 'log\' + ChangeFileExt(LogPath, '.dat'));
	except
		FreeAndNil(Result);
		raise;
	end;
end;

{ T2chIndexList }

function T2chIndexList.Add(AObject: TObject): Integer;
begin
	Lock.Acquire;
	try
		Add := -1;
		if not Assigned(AObject) then Exit;

		if not IndexList.Has((AObject as T2chThreadIndex).GetLogPath) then
		begin
			Add := inherited Add(AObject);
			
			{ MasterIndexɓo^ĂȂꍇ͓o^ }
			if MasterIndex <> nil then
				if MasterIndex.LogPathOfObject(T2chThreadIndex(AObject).GetLogPath) = nil then
					MasterIndex.Add(AObject);
		end;
	finally
		Lock.Release;
	end;
end;

function ThreadSortFunc(List: TStringList; Index1, Index2: Integer): Integer;
var
	Thread1, Thread2: T2chThreadIndex;
{ ResStateToIndex }
	function ResStateToIndex(Idx: T2chThreadIndex): Integer;
	begin
		case Idx.ResState of
			rsCheck, rsNew: Result := 0;
			rsNone: Result := 1;
			rsError: Result := 3;
			else
				Result := 4;
		end;

		if stLog in Idx.State then
			Result := 5;

		if (Result = 1) and (Idx.Depth = 0) then
			Result := 2;
	end;
{ DepthToIndex }
	function DepthToIndex(Depth: Integer): Integer;
	begin
		case Depth of
			Low(Integer) .. -1: Result := MaxInt - 1;
			0: Result := MaxInt;
			else
				Result := Depth;
		end;
	end;
{ ThreadCompare }
	function ThreadCompare(SortKey: T2chThreadSortTypes; Thread1, Thread2: T2chThreadIndex): Integer;
	var
		Val1, Val2: Variant;
	begin
		Val1 := Null;
		Val2 := Null;

		if tsBoardName in SortKey then
		begin
			Val1 := Thread1.BoardName;
			Val2 := Thread2.BoardName;
		end
		else if tsTitle in SortKey then
		begin
			Val1 := Thread1.ThreadName;
			Val2 := Thread2.ThreadName;
		end
		else if tsThreadNum in SortKey then
		begin
			Val1 := Thread1.ThreadNum;
			Val2 := Thread2.ThreadNum;
		end
		else if tsGravity in SortKey then
		begin
			Val1 := Thread1.Gravity;
			Val2 := Thread2.Gravity;
		end
		else if tsBeforeResCount in SortKey then
		begin
			Val1 := Thread1.BeforeResCount;
			Val2 := Thread2.BeforeResCount;
		end
		else if tsResCount in SortKey then
		begin
			Val1 := Thread1.ResCount;
			Val2 := Thread2.ResCount;
		end
		else if tsNewResCount in SortKey then
		begin
			Val1 := Thread1.NewResCount;
			Val2 := Thread2.NewResCount;
		end
		else if tsResDiff in SortKey then
		begin
			Val1 := Thread1.BeforeResCount - Thread1.ResCount;
			Val2 := Thread2.BeforeResCount - Thread2.ResCount;
			{ tsAsctsDecւă\[gʂtɂ }
			if tsAsc in SortKey
				then SortKey := SortKey - [tsAsc] + [tsDec]
				else SortKey := SortKey - [tsDec] + [tsAsc];
		end
		else if tsDateTime in SortKey then
		begin
			Val1 := Thread1.DateTime;
			Val2 := Thread2.DateTime;
		end
		else if tsMemo in SortKey then
		begin
			Val1 := Thread1.Memo;
			Val2 := Thread2.Memo;
		end
		else if tsCheckRes in SortKey then
		begin
			Val1 := ResStateToIndex(Thread1);
			Val2 := ResStateToIndex(Thread2);
		end
		else if tsDepth in SortKey then
		begin
			Val1 := DepthToIndex(Thread1.Depth);
			Val2 := DepthToIndex(Thread2.Depth);
		end;

		Assert(Val1 <> Null);
		Assert(Val2 <> Null);

		if Val1 = Val2 then
			Result := 0
		else
			if Val1 < Val2 then
				Result := -1
			else
				Result := 1;

		if tsDec in SortKey then
			Result := -Result;
	end;
begin
	Thread1 := T2chThreadIndex(List.Objects[Index1]);
	Thread2 := T2chThreadIndex(List.Objects[Index2]);

	Result := ThreadCompare((List as T2chThreadSortList).SortKey1, Thread1, Thread2);
{	if ((List as T2chThreadSortList).SortKey2 <> []) and (Result = 0) then
		Result := ThreadCompare((List as T2chThreadSortList).SortKey2, Thread1, Thread2);}
	if (Result = 0) and (List[Index1] <> List[Index2]) then
		if List[Index1] < List[Index2] then
			Result := -1
		else
			Result := 1;
end;

procedure T2chIndexList.BoardSort(SortKey1, SortKey2: T2chThreadSortTypes);
var
	I: Integer;
	List: T2chThreadSortList;
	Thread: T2chThreadIndex;
begin
	Lock.Acquire;
	try
		List := T2chThreadSortList.Create;

		try
			List.SortKey1 := SortKey1;
			List.SortKey2 := SortKey2;

			for I := Count - 1 downto 0 do
			begin
				Thread := T2chThreadIndex(Items[I]);
				List.AddObject(Format('%4d', [I]), Thread);
			end;

			List.CustomSort(ThreadSortFunc);

			for I := 0 to List.Count - 1 do
				Add(Extract(T2chThreadIndex(List.Objects[I])));
		finally
			List.Free;
		end;
	finally
		Lock.Release;
	end;
end;

constructor T2chIndexList.Create;
begin
	Create(nil, False);
end;

constructor T2chIndexList.Create(Master: T2chIndexList; AOwnsObjects: Boolean);
begin
	Lock := TCriticalSection.Create;
	IndexList := THashList.Create(300, nil, nil);
	MasterIndex := Master;
	inherited Create(AOwnsObjects);
end;

constructor T2chIndexList.Create(AOwnsObjects: Boolean);
begin
	Create(nil, AOwnsObjects);
end;

destructor T2chIndexList.Destroy;
begin
	inherited;
	IndexList.Free;
	Lock.Free;
end;

function T2chIndexList.Extract(Item: T2chThreadIndex): T2chThreadIndex;
begin
	Lock.Acquire;
	try
		Result := T2chThreadIndex(inherited Extract(Item));
		FModified := True;
	finally
		Lock.Release;
	end;
end;

function T2chIndexList.GetIndexItem(Index: Integer): T2chThreadIndex;
begin
	Lock.Acquire;
	try
		GetIndexItem := T2chThreadIndex(GetItem(Index));
	finally
		Lock.Release;
	end;
end;

function T2chIndexList.GetModified: Boolean;
var
	I: Integer;
begin
	Result := FModified;
	for I := 0 to Count - 1 do
		Result := Result or Items[I].Modified;
end;

function T2chIndexList.GetModifyItemCount: Integer;
var
	I: Integer;
begin
	Result := 0;
	for I := 0 to Count - 1 do
		if Items[I].Modified then
			Inc(Result);
end;

procedure T2chIndexList.LoadFromFile(const FileName: string);
var
	Stream: TStream;
begin
	LibName := ChangeFileExt(ExtractFileName(FileName), '');

	Stream := TFileStream.Create(FileName, fmOpenRead or fmShareDenyWrite);
	try
		LoadFromStream(Stream);
	finally
		Stream.Free;
	end;
end;

procedure T2chIndexList.LoadFromStream(Stream: TStream);
var
	I: Integer;
	List: TStringList;
	ThreadIdx: T2chThreadIndex;
begin
	List := nil;
	ThreadIdx := nil;

	try
		List := TStringList.Create;
		List.LoadFromStream(Stream);

    Clear;

		if List.Count > 0 then
			Capacity := List.Count;
			
		for I := List.Count - 1 downto 0 do
		begin
			if MasterIndex <> nil then
				ThreadIdx := MasterIndex.LogPathOfObject(List[I]);

			if ThreadIdx = nil then
			begin
				ThreadIdx := T2chThreadIndex.Create;
				try
					ThreadIdx.LoadFromFile(TKatjusha.GetKatjushaBaseDir + 'log\' + List[I]);
				except
					{ JȂꍇ͖ }
					on EFOpenError do
						Continue;
				end;
			end;

			if MasterIndex <> nil then
				MasterIndex.Add(ThreadIdx);
				
			Add(ThreadIdx);
			
			ThreadIdx := nil;
		end;
	finally
		FModified := False;
		ThreadIdx.Free;
		List.Free;
	end;
end;

function T2chIndexList.LogPathOfObject(
	const LogPath: string): T2chThreadIndex;
var
	ThreadIdx: T2chThreadIndex;
begin
	Lock.Acquire;
	try
		Result := nil;
		if IndexList.Find(LogPath, ThreadIdx) then
			Result := ThreadIdx;
	finally
		Lock.Release;
	end;
end;

procedure T2chIndexList.Notify(Ptr: Pointer; Action: TListNotification);
begin
	inherited;
	case Action of
		lnAdded: IndexList.Add(T2chThreadIndex(Ptr).GetLogPath, T2chThreadIndex(Ptr));
		lnExtracted, lnDeleted: IndexList.RemoveData(Ptr);
	end;

	FModified := True;
end;

procedure T2chIndexList.SaveToFile(const FileName: string);
var
  Stream: TStream;
begin
  Stream := TFileStream.Create(FileName, fmCreate);
  try
    SaveToStream(Stream);
  finally
    Stream.Free;
  end;
end;

procedure T2chIndexList.SaveToStream(Stream: TStream);
var
	I: Integer;
	List: TStringList;
	LogPath: string;
begin
	List := nil;

	try
		List := TStringList.Create;

		for I := Count - 1 downto 0 do
		begin
			LogPath := Items[I].GetLogPath;
			try
				if Items[I].Modified then
					Items[I].SaveToFile(KatjushaBaseDir + 'log\' + LogPath);
			except
				on E: Exception do
					ShowMessage(E.Message);
			end;
			List.Add(LogPath);
		end;
		
		List.SaveToStream(Stream);

		FModified := False;
	finally
		List.Free;
	end;
end;

procedure T2chIndexList.SetIndexItem(Index: Integer; AObject: T2chThreadIndex);
begin
	Lock.Acquire;
	try
		SetItem(Index, AObject);
	finally
		Lock.Release;
	end;
end;

function T2chIndexList.ThreadPathOf(const Idx: string): Integer;
var
	ThreadIdx: T2chThreadIndex;
begin
	Lock.Acquire;
	try
		Result := -1;
		if IndexList.Find(Idx, ThreadIdx) then
			Result := IndexOf(ThreadIdx);
	finally
		Lock.Release;
	end;
end;

{ T2chSubject }

procedure T2chSubject.Add(const ThreadNum, Title: string;
  ResCount, Depth: Integer);
var
	Item: P2chSubjectItem;
begin
	New(Item);
	Item.ThreadNum := StrToCurr(ThreadNum);
	Item.Title := Title;
	Item.ResCount := ResCount;
	Item.Depth := Depth;
	InternalList.AddObject(ThreadNum, TObject(Item));
end;

procedure T2chSubject.Assign(Source: TPersistent);
var
	I: Integer;
	Item: P2chSubjectItem;
begin
	if Source is T2chSubject then
	begin
		Clear;
		
		FContentDate := T2chSubject(Source).FContentDate;
		InternalList.Assign(T2chSubject(Source).InternalList);
		
		for I := 0 to InternalList.Count - 1 do
		begin
			New(Item);
			Item^ := P2chSubjectItem(InternalList.Objects[I])^;
			InternalList.Objects[I] := TObject(Item);
		end;
	end else
		inherited Assign(Source);
end;

procedure T2chSubject.Clear;
var
	I: Integer;
begin
	for I := 0 to InternalList.Count -1 do
		Dispose(P2chSubjectItem(InternalList.Objects[I]));

	InternalList.Clear;
end;

constructor T2chSubject.Create;
begin
	inherited;

	InternalList := TStringList.Create;
(*	InternalList.Sorted := True; { \[g͂Ȃ }*)
	XmlInError := False;
	FContentDate := -1;
end;

destructor T2chSubject.Destroy;
begin
	Clear;
	InternalList.Free;

	inherited;
end;

function T2chSubject.Diff(Dest, Source: T2chSubject): Integer;
{ SelfSourceSourceɂȂ̂DestɃRs[ }
var
	List: TList;
	I, P: Integer;
	Item: P2chSubjectItem;
begin
	List := TList.Create;

	try
		for I := 0 to Source.InternalList.Count - 1 do
		begin
			P := IndexOf(Source.InternalList[I]);
			if P < 0 then
				List.Add(Pointer(I));
		end;

		Dest.Clear;

		for I := 0 to List.Count - 1 do
		begin
			P := Integer(List[I]);
			with Source do
			begin
				Item := P2chSubjectItem(InternalList.Objects[P]);
				Dest.Add(InternalList[P], Item.Title, Item.ResCount, Item.Depth);
			end;
		end;

		Result := List.Count;
	finally
		List.Free;
	end;
end;

function T2chSubject.Get(Index: Integer): P2chSubjectItem;
begin
	Result := P2chSubjectItem(InternalList.Objects[Index]);
end;

function T2chSubject.GetCount: Integer;
begin
	Result := InternalList.Count;
end;

function T2chSubject.GetDepth(Index: Integer): Integer;
begin
	Result := P2chSubjectItem(InternalList.Objects[Index]).Depth;
end;

function T2chSubject.GetResCount(Index: Integer): Integer;
begin
	Result := P2chSubjectItem(InternalList.Objects[Index]).ResCount;
end;

function T2chSubject.GetStrings(Index: Integer): string;
begin
	Result := InternalList[Index];
end;

function T2chSubject.IndexOf(const S: string): Integer;
var
	I: Integer;
	ThreadNum: Currency;
begin
	Result := -1;

	ThreadNum := StrToCurr(S);

	for I := 0 to InternalList.Count - 1 do
		if ThreadNum = P2chSubjectItem(InternalList.Objects[I]).ThreadNum then
		begin
			Result := I;
			Exit;
		end;
end;

function T2chSubject.IndexOf(const S: Currency): Integer;
var
	I: Integer;
begin
	Result := -1;

	for I := 0 to InternalList.Count - 1 do
		if S = P2chSubjectItem(InternalList.Objects[I]).ThreadNum then
		begin
			Result := I;
			Exit;
		end;
end;

procedure T2chSubject.LoadFromFile(const FileName: string);
var
	Stream: TStream;
	AccessTime, LocalAccessTime: FILETIME;
	SysAccessTime: SYSTEMTIME;
begin
	Stream := TFileStream.Create(FileName, fmOpenRead or fmShareDenyWrite);
	try
		LoadFromStream(Stream);
		GetFileTime(TFileStream(Stream).Handle, nil, nil, @AccessTime);
		FileTimeToLocalFileTime(AccessTime, LocalAccessTime);
		FileTimeToSystemTime(LocalAccessTime, SysAccessTime);
		FContentDate := SystemTimeToDateTime(SysAccessTime);
	finally
		Stream.Free;
	end;
end;

procedure T2chSubject.LoadFromStream(Stream: TStream);
var
	r2: regex_t;
	Token: array[0 .. 1] of string;
	List: TStringList;
	I, P: Integer;
	ThreadNum, ResCount, SubStr: string;
	Item: P2chSubjectItem;
{ Numeric }
	function Numeric(const Text: string): string;
	var
		I, Count: Integer;
	begin
		Count := 0;
		for I := 1 to Length(Text) do
		begin
			if Text[I] in ['0' .. '9'] then
				Inc(Count)
			else
				Break;
		end;

		Result := Copy(Text, 1, Count);
	end;
begin
	List := nil;
	AWKClearPattern(r2);

	try
		List := TStringList.Create;

		SubStr := '<>';
		AWKCompilePattern(r2, ' ?\(([0-9]+)\)$');

		List.LoadFromStream(Stream);

		{ ܂aaȑꍇ }
		if (List.Count > 0) and (AWKMatch('^[0-9]+\.cgi,', List[0], nil) >= 0) then
		begin
			SubStr := ',';
			AWKFreePattern(r2);
			AWKCompilePattern(r2, '\(([0-9]+)\)$');
		end;
		
		for I := 0 to List.Count - 1 do
		begin
			New(Item);
			StringSplit(List[I], SubStr, Token);
			ThreadNum := Numeric(Token[0]);
 //			ThreadNum := AnsiReplaceStr(Token[0], '.dat', '');
			P := AWKMatch1(r2, Token[1], ResCount);
			Item.ThreadNum := StrToCurr(ThreadNum);
			Item.ResCount := StrToInt(ResCount);
			Item.Title := Copy(Token[1], 1, P);
			Item.Depth := I + 1;		{ [xۑ }
			InternalList.AddObject(ThreadNum, TObject(Item));
		end;
	finally
		AWKFreePattern(r2);
		List.Free;
	end;
end;

procedure T2chSubject.LoadFromURL(const URL: string; IniFile: T2chSubjectIniFile);
var
	HTTP: TIdHTTP;
	Stream: TMemoryStream;
begin
	HTTP := nil;
	Stream := nil;

	try
		HTTP := TIdHTTP.Create(nil);
		Stream := TMemoryStream.Create;

		if KatjushaCommParams.ProxyParams.ProxyServer <> '' then
			HTTP.ProxyParams.Assign(KatjushaCommParams.ProxyParams);
			
		with HTTP.Request do
		begin
			UserAgent := KatjushaCommParams.UserAgent;
			AcceptEncoding := 'gzip';
			if Assigned(IniFile) then
			begin
				if IniFile.ETag <> '' then
					CustomHeaders.Values['If-None-Match'] := IniFile.ETag;
				if IniFIle.LastModified <> '' then
					CustomHeaders.Values['If-Modified-Since'] := IniFile.LastModified;
			end;
		end;
		HTTP.ReadTimeout := KatjushaCommParams.ReadTimeOut;

		HTTP.Get(URL, Stream);

		if Assigned(IniFile) then
		begin
			with HTTP.Response do
			begin
				IniFile.LastModified := RawHeaders.Values['Last-Modified'];
				IniFile.ETag := RawHeaders.Values['ETag'];
			end;
		end;

		if HTTP.Response.ContentEncoding = 'gzip' then
			UnzipStream(Stream);

		Stream.Seek(0, soFromBeginning);
		LoadFromStream(Stream);

		FContentDate := HTTP.Response.Date;
	finally
		Stream.Free;
		HTTP.Free;
	end;
end;

procedure T2chSubject.LoadFromXML(const FileName: string);
var
	DomImpl: TDomImplementation;
	Doc: TdomDocument;
	XmlParser: TXmlToDomParser;
	I: Integer;
	Threads, Root, Element: TdomElement;
	Item: P2chSubjectItem;
begin
	DomImpl := nil;
	XmlParser := nil;
	
	try
		DomImpl := TDomImplementation.create(nil);
		XmlParser := TXmlToDomParser.create(nil);
		XmlParser.OnError := XmlParserError;
		XmlParser.OnFatalError := XmlParserError;
		XmlParser.DOMImpl := DomImpl;

		XmlInError := False;
		Doc := XmlParser.fileToDom(FileName);

		Clear;

		if XmlInError then
			raise E2chSubjectError.Create('XMLɃG[܂');

		Threads := Doc.documentElement;
		for I := 0 to Threads.childNodes.length - 1 do
		begin
			New(Item);
			Root := Threads.childNodes.item(I) as TdomElement;
			Element := Root.getFirstChildElement('Title');
			Item.Title := Element.textContent;
			Element := Root.getFirstChildElement('Content');
			Item.ResCount := StrToInt(Element.getAttribute('ResCount'));
			InternalList.AddObject(Root.getAttribute('ID'), TObject(Item));
		end;
	finally
		XmlParser.Free;
		DomImpl.Free;
	end;
end;

procedure T2chSubject.SaveToFile(const FileName: string);
var
	Stream: TStream;
begin
	Stream := TFileStream.Create(FileName, fmCreate);
	try
		SaveToStream(Stream);
	finally
		Stream.Free;
	end;
end;

procedure T2chSubject.SaveToStream(Stream: TStream);
var
	List: TStringList;
	Item: P2chSubjectItem;
	I: Integer;
begin
	List := nil;

	try
		List := TStringList.Create;

		for I := 0 to InternalList.Count - 1 do
		begin
			Item := P2chSubjectItem(InternalList.Objects[I]);
			List.Add(InternalList[I] + '.dat<>' + Item.Title + ' (' + IntToStr(Item.ResCount) + ')');
		end;

		List.SaveToStream(Stream);
	finally
		List.Free;
	end;
end;

procedure T2chSubject.SaveToXML(const FileName: string);
var
	DomImpl: TDomImplementation;
	Doc: TdomDocument;
	Root, Element: TdomElement;
	I: Integer;
	Item: P2chSubjectItem;
	Stream: TFileStream;
begin
	DomImpl := nil;
	Stream := nil;
	
	try
		DomImpl := TDomImplementation.create(nil);
		Doc := DomImpl.createDocument('Threads', nil);

		for I := 0 to InternalList.Count - 1 do
		begin
			Item := P2chSubjectItem(InternalList.Objects[I]);
			Root := Doc.createElement('Thread');
			Root.setAttribute('ID', InternalList[I]);
			Doc.documentElement.appendChild(Root);
			Element := Doc.createElement('Title');
			Element.appendChild(Doc.createTextNode(Item.Title));
			Root.appendChild(Element);
			Element := Doc.createElement('Content');
			Element.setAttribute('ResCount', IntToStr(Item.ResCount));
			Root.appendChild(Element);
		end;

		Stream := TFileStream.Create(FileName, fmCreate);
		Doc.writeCodeAsShiftJIS(Stream);
	finally
		Stream.Free;
		DomImpl.Free;
	end;
end;

procedure T2chSubject.XmlParserError(xmlToDomParser: TXmlToDomParser;
	e: TXmlParserError);
begin
	XmlInError := True;
end;

{ T2chSubjectIniFile }

procedure T2chSubjectIniFile.Clear;
begin
  inherited;
	FETag := '';
	FLastModified := '';
end;

procedure T2chSubjectIniFile.DoUpdate(IniFile: TMemIniFile;
	Direction: Boolean);
const
	SubjectSection = 'Subject';
begin
	if Direction then
	begin
		{ ǂݍ }
		FETag := IniFile.ReadString(SubjectSection, 'ETag', '');
		FLastModified := IniFile.ReadString(SubjectSection, 'LastModified', '');
	end else begin
		{  }
		IniFile.WriteString(SubjectSection, 'ETag', FETag);
		IniFile.WriteString(SubjectSection, 'LastModified', FLastModified);
	end;
end;

{ TKatjushaCommunicationParams }

constructor TKatjushaCommunicationParams.Create;
begin
	inherited;
	ProxyParams := TIdProxyConnectionInfo.Create;
end;

destructor TKatjushaCommunicationParams.Destroy;
begin
	ProxyParams.Free;
  inherited;
end;

{ T2chCustomSortList }

procedure T2chCustomSortList.Add(SortTypes: T2chThreadSortTypes);
begin
	InternalList.Add(PPointer(@SortTypes)^);
end;

procedure T2chCustomSortList.Assign(Source: TPersistent);
begin
	if Source is T2chCustomSortList
		then InternalList.Assign(T2chCustomSortList(Source).InternalList)
		else inherited;
end;

procedure T2chCustomSortList.Clear;
begin
	internalList.Clear;
end;

constructor T2chCustomSortList.Create;
begin
	inherited;
	InternalList := TList.Create;
end;

destructor T2chCustomSortList.Destroy;
begin
	InternalList.Free;
  inherited;
end;

function T2chCustomSortList.Get(Index: Integer): T2chThreadSortTypes;
var
	P: Pointer;
begin
	P := InternalList[Index];
	Result := P2chThreadSortTypes(@P)^;
end;

function T2chCustomSortList.GetCount: Integer;
begin
	Result := InternalList.Count;
end;

procedure T2chCustomSortList.Put(Index: Integer;
  const Value: T2chThreadSortTypes);
begin
	InternalList[Index] := PPointer(@Value)^;
end;

{ T2chCustomSortObjectList }

function T2chCustomSortObjectList.Add(const Name: string;
  SortList: T2chCustomSortList): Integer;
begin
	Result := Internal.AddObject(Name, SortList);
end;

procedure T2chCustomSortObjectList.Assign(Source: TPersistent);
var
	I: Integer;
	SourceList: TStringList;
	List: T2chCustomSortList;
begin
	if Source is T2chCustomSortObjectList then
	begin
		Clear;

		SourceList := T2chCustomSortObjectList(Source).Internal;
		for I := 0 to SourceList.Count - 1 do
		begin
			List := T2chCustomSortList.Create;
			List.Assign(SourceList.Objects[I] as T2chCustomSortList);
			Internal.AddObject(SourceList[I], List);
		end;
	end else
		inherited;
end;

procedure T2chCustomSortObjectList.Clear;
var
	I: Integer;
begin
	for I := 0 to Internal.Count - 1 do
	begin
		Internal.Objects[I].Free;
		Internal.Objects[I] := nil;
	end;
	
	Internal.Clear;
end;

constructor T2chCustomSortObjectList.Create;
begin
	Internal := TStringList.Create;
end;

function T2chCustomSortObjectList.Delete(
  Index: Integer): T2chCustomSortList;
begin
	Result := T2chCustomSortList(Internal.Objects[Index]);
	Internal.Delete(Index);
end;

destructor T2chCustomSortObjectList.Destroy;
begin
	Clear;
	Internal.Free;
  inherited;
end;

function T2chCustomSortObjectList.Get(Index: Integer): T2chCustomSortList;
begin
	Result := T2chCustomSortList(Internal.Objects[Index]);
end;

function T2chCustomSortObjectList.GetCount: Integer;
begin
	Result := Internal.Count;
end;

function T2chCustomSortObjectList.GetNames(Index: Integer): string;
begin
	Result := Internal[Index];
end;

procedure T2chCustomSortObjectList.Put(Index: Integer;
  const Value: T2chCustomSortList);
begin
	Internal.Objects[Index] := Value;
end;

procedure T2chCustomSortObjectList.SetNames(Index: Integer;
  const Value: string);
begin
	Internal[Index] := Value;
end;

procedure T2chCustomSortObjectList.SaveToXML(const FileName: string);
var
	DomImpl: TDomImplementation;
	Doc: TdomDocument;
	Root, Element: TdomElement;
	I, J: Integer;
	Stream: TFileStream;
begin
	DomImpl := nil;
	Stream := nil;
	Doc := nil;
	try
		DomImpl := TDomImplementation.create(nil);
		Stream := TFileStream.Create(FileName, fmCreate);
		
		Doc := TIndentedDomDocument.create(DomImpl);
		Doc.appendChild(Doc.createElement('CustomSortTypes'));

		for I := 0 to Internal.Count - 1 do
		begin
			Root := Doc.createElement('CustomSortType');
			Root.setAttribute('Name', Internal[I]);
			for J := 0 to Items[I].Count - 1 do
			begin
				Element := Doc.createElement('Item');
				Element.appendChild(Doc.createTextNode(SortTypeToName(Items[I].Items[J])));
				if tsAsc in Items[I].Items[J]
					then Element.setAttribute('Direction', '')
					else Element.setAttribute('Direction', '~');
				Root.appendChild(Element);
			end;
			Doc.documentElement.appendChild(Root);
		end;

		Doc.writeCodeAsShiftJIS(Stream);
	finally
		Stream.Free;
		Doc.Free;
		DomImpl.Free;
	end;
end;

procedure T2chCustomSortObjectList.LoadFromXML(const FileName: string);
var
	DomImpl: TDomImplementation;
	Doc: TdomDocument;
	XmlParser: TXmlToDomParser;
	CustomSortType, Item: TdomElement;
	ListItem: T2chCustomSortList;
	SortTypes: T2chThreadSortTypes;
begin
	DomImpl := nil;
	XmlParser := nil;
	
	try
		DomImpl := TDomImplementation.create(nil);
		XmlParser := TXmlToDomParser.create(nil);
		XmlParser.DOMImpl := DomImpl;

		Clear;
		
		Doc := XmlParser.fileToDom(FileName);
		if not Assigned(Doc) then Exit;
		if not Assigned(Doc.documentElement) then Exit;
		
		CustomSortType := Doc.documentElement.getFirstChildElement('CustomSortType');
		while CustomSortType <> nil do
		begin
			Item := CustomSortType.getFirstChildElement('Item');
			ListItem := T2chCustomSortList.Create;
			while Item <> nil do
			begin
				SortTypes := [SortNameToSortType(Item.textContent)];
				if Item.getAttribute('Direction') = ''
					then SortTypes := SortTypes + [tsAsc]
					else SortTypes := SortTypes + [tsDec];
				ListItem.Add(SortTypes);
				Item := Item.getNextSiblingElement('Item');
			end;
			Add(CustomSortType.getAttribute('Name'), ListItem);
			CustomSortType := CustomSortType.getNextSiblingElement('CustomSortType');
		end;
	finally
		XmlParser.Free;
		DomImpl.Free;
	end;
end;

{ T2chThreadDat }

procedure T2chThreadDat.Aborn(Index: Integer; Invisible: Boolean);
begin
	Put(Index, IfThen(Invisible, KATJUSHA_INVISIBLE_ABORN, KATJUSHA_ABORN));
	FModified := True;
end;

function T2chThreadDat.GetDateTime(Index: Integer): Variant;
var
	DateStr: string;
	MatchIdx, AYear: Integer;
	DateAndTime: array [0 .. 5] of string;
begin
	DateStr := GetDate(Index);

	{ 02/05/23 18:39 } 
	MatchIdx := AWKMatch('([0-9]+)/([0-9]+)/([0-9]+)[ ]+([0-9]+):([0-9]+)',
			DateStr, DateAndTime);
	if MatchIdx < 0 then
	begin
		{ 2002/12/29() 05:42 }
		MatchIdx := AWKMatch('([0-9]+)/([0-9]+)/([0-9]+)\([^\)]+\)[ ]+([0-9]+):([0-9]+)',
				DateStr, DateAndTime);
	end;

	if MatchIdx < 0 then
	begin
{   O͒xȂ̂ł߂ăoAg^Œlł邱ƂƂɂB
		raise E2chThreadDatError.Create('"' + DateStr + '": t܂');}
		Result := Null;
		Exit;
	end;

	AYear := StrToInt(DateAndTime[1]);
	if AYear < 100 then
		AYear := AYear + IfThen(AYear >= 70, 1900, 2000);

	try
		Result := EncodeDate(AYear, StrToInt(DateAndTime[2]), StrToInt(DateAndTime[3])) +
							EncodeTime(StrToInt(DateAndTime[4]), StrToInt(DateAndTime[5]), 0, 0);
	except
		on E: EConvertError do
		begin
{			ShowMessage(E.Message + ': "' + DateStr + '"'); }
			Result := Null;
		end;
	end;
end;

function T2chThreadDat.GetDate(Index: Integer): string;
var
	DatArray: array [0 .. 4] of string;
begin
	Split(Index, DatArray);
	Result := DatArray[2];
end;

function T2chThreadDat.GetMail(Index: Integer): string;
var
	DatArray: array [0 .. 4] of string;
begin
	Split(Index, DatArray);
	Result := DatArray[1];
end;

function T2chThreadDat.GetMessage(Index: Integer): string;
var
	DatArray: array [0 .. 4] of string;
begin
	Split(Index, DatArray);
	Result := DatArray[3];
end;

function T2chThreadDat.GetName(Index: Integer): string;
var
	DatArray: array [0 .. 4] of string;
begin
	Split(Index, DatArray);
	Result := DatArray[0];
end;

function T2chThreadDat.IdAborn(const IdStr: string;
  const Invisible: Boolean): Integer;
var
	DateStr: string;
	P, I, C: Integer;
	M: Boolean;
begin
	M := False;
	C := 0;

	for I := 0 to Count - 1 do
	begin
		DateStr := GetDate(I);
		if DateStr = 'ځ`' then Continue;

		P := Pos('ID:', DateStr);
		if ((P > 0) and (Copy(DateStr, P + 3, 8) = IdStr)) then
		begin
			Inc(C);
			Put(I, IfThen(Invisible, KATJUSHA_INVISIBLE_ABORN, KATJUSHA_ABORN));
			M := True;
		end;
	end;

	if M then
		FModified := True;

	Result := C;
end;

procedure T2chThreadDat.LoadFromStream(Stream: TStream);
var
	S: string;
begin
	inherited;

	{ LoadFromFileĂ΂ĂȂƂ̓t@CNA }
	if not FLoadFromFileCalled then
		FFileName := '';

	FModified := False;
	FCommaSplit := True;
	try
		S := inherited Get(0);
		if Pos('<>', S) > 0 then
			FCommaSplit := False;
	except
		{ O͖ }
	end;
end;

procedure T2chThreadDat.Split(Index: Integer;
  var StrArray: array of string);
begin
	if FCommaSplit then
		CommaSplit(StrArray, inherited Get(Index))
	else
		StringSplit(inherited Get(Index), '<>', StrArray);
end;

function T2chThreadDat.Get(Index: Integer): string;
begin
	Result := inherited Get(Index);
	if FCommaSplit then
	begin
		Result := StringReplace(Result, ',', '<>', [rfReplaceAll]);
		Result := StringReplace(Result, 'M', ',', [rfReplaceAll]);
	end;
end;

procedure T2chThreadDat.Put(Index: Integer; const S: string);
var
	Str: string;
begin
	if FCommaSplit and (Pos('<>', S) > 0) then
	begin
		Str := StringReplace(S,',',  'M', [rfReplaceAll]);
		Str := StringReplace(Str,'<>',  ',', [rfReplaceAll]);
		inherited Put(Index, Str);
	end else
		inherited;
end;

procedure T2chThreadDat.SaveToStream(Stream: TStream);
var
	SaveCommaSplit: Boolean;
begin
	SaveCommaSplit := FCommaSplit;
	try
		FCommaSplit := False;
		inherited;
	finally
		FCommaSplit := SaveCommaSplit;
	end;
end;

procedure T2chThreadDat.LoadFromFile(const FileName: string);
begin
	FLoadFromFileCalled := True;
	try
		FFileName := '';
		inherited;
		FFileName := FileName;
	finally
		FLoadFromFileCalled := False;
	end;
end;

procedure T2chThreadDat.Save;
begin
	Assert(FFileName <> '');
	SaveToFile(FFileName);
end;

{ T2chSubjectParams }

constructor T2chSubjectParams.Create;
begin
	FList := THashList.Create(150, nil, nil);
end;

destructor T2chSubjectParams.Destroy;
begin
	FList.Free;
  inherited;
end;

function T2chSubjectParams.GetValue(Name: string): P2chSubjectParamsItem;
var
	P: P2chSubjectParamsItem;
begin
	P := nil;
	if FList.Find(Name, P) then
		Result := P
	else begin
		New(P);
		FList.Add(Name, P);
		Result := P;
	end;
end;

procedure T2chSubjectParams.LoadFromFile(const FileName: string);
var
	Stream: TStream;
begin
	Stream := TFileStream.Create(FileName, fmOpenRead or fmShareDenyWrite);
	try
		LoadFromStream(Stream);
	finally
		Stream.Free;
	end;
end;

procedure T2chSubjectParams.LoadFromStream(Stream: TStream);
var
	List: TStringList;
	I: Integer;
	Token: array [0 .. 2] of string;
begin
	List := nil;
	try
		List := TStringList.Create;
		List.LoadFromStream(Stream);

		for I := 0 to List.Count - 1 do
		begin
			StringSplit(List[I], '<>', Token);

		end;
	finally
		List.Free;
	end;
end;

procedure T2chSubjectParams.SaveToFile(const FileName: string);
var
	Stream: TStream;
begin
	Stream := TFileStream.Create(FileName, fmCreate);
	try
		SaveToStream(Stream);
	finally
		Stream.Free;
	end;
end;

procedure T2chSubjectParams.SaveToStream(Stream: TStream);
begin

end;

initialization
	KatjushaCommParams := TKatjushaCommunicationParams.Create;
	KatjushaPathInfo := TStringList.Create;

finalization
	KatjushaCommParams.Free;
	KatjushaPathInfo.Free;
end.

