unit ThreadFind;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons;

type
  TThreadFindDlg = class(TForm)
    Label1: TLabel;
    SearchTextEdit: TEdit;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    CaseInsensitiveCheckBox: TCheckBox;
    procedure BitBtn1Click(Sender: TObject);
  private
    FSearchText: string;
    FCaseInsensitive: Boolean;
    procedure SetSearchText(const Value: string);
    procedure SetCaseInsensitive(const Value: Boolean);
    { Private 錾 }
  public
		{ Public 錾 }
		class function Execute(AOwner: TComponent; var SearchText: string; var CaseInsensitive: Boolean): Boolean;
		property SearchText: string read FSearchText write SetSearchText;
		property CaseInsensitive: Boolean read FCaseInsensitive write SetCaseInsensitive;
  end;

implementation

{$R *.dfm}

{ TThreadFindDlg }

class function TThreadFindDlg.Execute(AOwner: TComponent; var SearchText: string; var CaseInsensitive: Boolean): Boolean;
var
	ThreadFindDlg: TThreadFindDlg;
begin
	ThreadFindDlg := TThreadFindDlg.Create(AOwner);
	try
		ThreadFindDlg.SearchText := SearchText;
		ThreadFindDlg.CaseInsensitive := CaseInsensitive;
		
		Result := False;
		if ThreadFindDlg.ShowModal = mrOk then
		begin
			SearchText := ThreadFindDlg.SearchText;
			CaseInsensitive := ThreadFindDlg.CaseInsensitive;
			Result := True;
		end;
	finally
		ThreadFindDlg.Free;
	end;
end;

procedure TThreadFindDlg.SetCaseInsensitive(const Value: Boolean);
begin
	FCaseInsensitive := Value;
	CaseInsensitiveCheckBox.Checked := Value;
end;

procedure TThreadFindDlg.SetSearchText(const Value: string);
begin
	FSearchText := Value;
	SearchTextEdit.Text := Value;
end;

procedure TThreadFindDlg.BitBtn1Click(Sender: TObject);
begin
	FCaseInsensitive := CaseInsensitiveCheckBox.Checked;
	FSearchText := SearchTextEdit.Text;
end;

end.

