unit LogMover;

interface

uses
	Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, MacherieBoardView;

type
	TLogMoverParams = class;
  TLogMoverDlg = class(TForm)
    Label1: TLabel;
    BoardView: TMacherieBoardViewFrame;
    OptionGroupBox: TGroupBox;
    ClearDatFlagCheckBox: TCheckBox;
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    CopyThreadCheckBox: TCheckBox;
    DontRewriteIndexCheckBox: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure CopyThreadCheckBoxClick(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
	private
		{ Private 錾 }
	public
		{ Public 錾 }
		class function Execute(AOwner: TForm; AParams: TLogMoverParams): Boolean;
	end;
	TLogMoverParams = class(TPersistent)
	private
		FClearDatFlag: Boolean;
		FCopyThread: Boolean;
		FDontRewriteIndex: Boolean;
		FPath: string;
		FName: string;
	public
		property Name: string read FName write FName;
		property Path: string read FPath write FPath;
		property ClearDatFlag: Boolean read FClearDatFlag write FClearDatFlag;
		property CopyThread: Boolean read FCopyThread write FCopyThread;
		property DontRewriteIndex: Boolean read FDontRewriteIndex write FDontRewriteIndex;
	end;

implementation

uses Katjusha;

{$R *.dfm}

{ TLogMoverDlg }

class function TLogMoverDlg.Execute(AOwner: TForm; AParams: TLogMoverParams): Boolean;
var
	LogMoverDlg: TLogMoverDlg;
begin
	LogMoverDlg := nil;
	try
		LogMoverDlg := TLogMoverDlg.Create(AOwner);

		Result := LogMoverDlg.ShowModal = mrOk;

		if Result then
		begin
			AParams.Name := LogMoverDlg.BoardView.SelectedBoardName;
			AParams.Path := LogMoverDlg.BoardView.SelectedBoard;
			AParams.ClearDatFlag := LogMoverDlg.ClearDatFlagCheckBox.Checked;
			AParams.CopyThread := LogMoverDlg.CopyThreadCheckBox.Checked;
			AParams.DontRewriteIndex := LogMoverDlg.DontRewriteIndexCheckBox.Checked;
		end;
	finally
		LogMoverDlg.Release;
	end;
end;

procedure TLogMoverDlg.FormCreate(Sender: TObject);
var
	Board: T2chBoard;
begin
	Board := nil;

	try
		Board := T2chBoard.Create;

		Board.LoadFromFile(TKatjusha.GetKatjushaBaseDir + BOARD_2CHANNEL_BRD);
		Board.LoadFromFile(TKatjusha.GetKatjushaBaseDir + BOARD_OTHER_BRD);

		BoardView.BoardText := Board;
	finally
		Board.Free;
	end;
end;

procedure TLogMoverDlg.CopyThreadCheckBoxClick(Sender: TObject);
begin
	if CopyThreadCheckBox.Checked then
		DontRewriteIndexCheckBox.Enabled := True
	else
		with DontRewriteIndexCheckBox do
		begin
			Checked := False;
			Enabled := False;
		end;
end;

procedure TLogMoverDlg.OKBtnClick(Sender: TObject);
begin
	if BoardView.SelectedBoard = ''
		then ShowMessage('IĂB')
		else ModalResult := mrOk;
end;

end.

