unit FavUtils;

interface

uses
	Windows, Messages, SysUtils, Classes, Contnrs, Forms, IniFiles, ComCtrls, Dialogs, StrUtils, Menus,
	DMonkey, ecma_type, ecma_object, ecma_extobject, Katjusha, FavTypes;

type
	TKatfavIniFile = class
	private
		IniFile: TMemIniFile;
		FThreadListParams: TThreadListParams;
		FNewResCheckParams: TNewResCheckParams;
		procedure SetThreadListParams(const Value: TThreadListParams);
    procedure SetNewResCheckParams(const Value: TNewResCheckParams);
	public
		WindowState: TWindowState;
		TreeViewWidth: Integer;
		BodyStyle: string;
		MainFormRect: TRect;
		ProxyAddress: string;
		ProxyPort: Integer;
		TimeOut: Integer;
		ArchiveExt: string;
		ShowToolBar: Boolean;
		NoLoadFavorites: Boolean;	{ Cɓǂݍ܂Ȃ }
		BoardButtonList: string;	{ {^ }
		CoolBarBandParams: TCoolBarBandParams;	{ CoolBar }
		NoLoadFavoritesDetail: TStringList;	{ ǂ܂ȂCɓ胊Xg }
		DefaultBrowserCommand: string;	{ OuEUR}h }
		SaveConfirmation: Boolean;	{ CtH[ƂۑmF邩ǂ }
		constructor Create(const FileName: TFileName);
		destructor Destroy; override;
		procedure Update(Direction: Boolean);
		property ThreadListParams: TThreadListParams read FThreadListParams write SetThreadListParams;
		property NewResCheckParams: TNewResCheckParams read FNewResCheckParams write SetNewResCheckParams;
	end;
	TVersionInformation = class(TObject)
	private
		procedure LoadInformation(const FileName: TFileName);
	public
		Minor: Integer;
		Major: Integer;
		Build: Integer;
		constructor Create(const FileName: TFileName);
	end;
	EResCheckStorageLogException = class(Exception);
	TResCheckThread = class(TThread)
	private
		ErrorMessage: string;
		FDisplayName: string;
    FParams: TNewResCheckParams;
		procedure CatchError;
		procedure CheckComplete;
		procedure CheckJBBSShitaraba(ThreadIdx: T2chThreadIndex; var ResCount: Integer);
    procedure SetParams(const Value: TNewResCheckParams);
	protected
		procedure Execute; override;
	public
		ListView: TListView;
    constructor Create(CreateSuspended: Boolean);
    destructor Destroy; override;
		property DisplayName: string read FDisplayName write FDisplayName;
		property Params: TNewResCheckParams read FParams write SetParams;
	end;
{ {^ǗNX }
	TBoardButtonType = (bbFavorites, bbBoards);
	TBoardButtonManager = class
	private
		FToolBar: TToolBar;
		FButtonList: TStringList;
		FOnClick: TNotifyEvent;
		FPopupMenu: TPopupMenu;
    function GetList: string;
    procedure SetList(const Value: string);
    function GetButtons(Index: Integer): string;
	public
		constructor Create(ToolBar: TToolBar);
		destructor Destroy; override;
		procedure Add(ButtonType: TBoardButtonType; BoardName, BoardURL: string);
		procedure Clear;
		property List: string read GetList write SetList;
		property OnClick: TNotifyEvent read FOnClick write FOnClick;
		property PopupMenu: TPopupMenu read FPopupMenu write FPopupMenu;
		property Buttons[Index: Integer]: string read GetButtons;
	end;
{ EChEj[ǗNX }
	TWindowMenuList = class;
	TWindowMenuItem = class
	private
    FForm: TForm;
    FMenuItem: TMenuItem;
		FOwner: TWindowMenuList;
		procedure SetForm(const Value: TForm);
		procedure DoClick(Sender: TObject);
	public
		constructor Create(AForm: TForm);
		destructor Destroy; override;
		procedure Refresh;
		property Form: TForm read FForm write SetForm;
		property MenuItem: TMenuItem read FMenuItem write FMenuItem;
		property Owner: TWindowMenuList read FOwner write FOwner;
	end;
	TWindowMenuList = class(TObjectList)
  private
		FMenu: TMenuItem;
  protected
		procedure Notify(Ptr: Pointer; Action: TListNotification); override;
	public
		constructor Create(AMenu: TMenuItem);
		procedure CloseAll;
		function Add(AForm: TForm): Integer;
		procedure Refresh;
		function Remove(AForm: TForm): Integer;
		property Menu: TMenuItem read FMenu write FMenu;
	end;
	TKatfavIndexMonitor = class
  	{ TODO : Indext@CĎpNX̎ }
	end;
	EKatfavScriptError = class(Exception);
	TJ2chThreadIdx = class(TJObject)
	private
		FThreadName: string;
		FBoardName: string;
		FServerName: string;
		FBoardPath: string;
		FDateTime: TJDateObject;
		FWriteTime: TJDateObject;
		FNumber: Integer;
		FThreadNum: string;
		FBeforeResCount: Integer;		{ X }
		FResCount: Integer;					{ X }
		FNewResCount: Integer;			{ VX }
		FGravity: Integer;					{ dvx? }
		FMemo: string;							{  }
		FDatSize: Integer;
	public
    constructor Create(AFactory: TJObjectFactory; Param: TJValueList); override;
    destructor Destroy; override;
		procedure Assign(Source: TPersistent); override;
	published
		property ThreadName: string read FThreadName;
		property BoardName: string read FBoardName;
		property ServerName: string read FServerName;
		property BoardPath: string read FBoardPath;
		property DateTime: TJDateObject read FDateTime;
		property WriteTime: TJDateObject read FWriteTime;
		property Number: Integer read FNumber;
		property ThreadNum: string read FThreadNum;
		property BeforeResCount: Integer read FBeforeResCount;
		property ResCount: Integer read FResCount;
		property NewResCount: Integer read FNewResCount;
		property Gravity: Integer read FGravity;
		property Memo: string read FMemo;
		property DatSize: Integer read FDatSize;
	end;
	TKatfavScriptManager = class
	private
		DMonkey: TDMonkey;
		procedure DebugOutput(Sender: TObject; S: string);
	public
		constructor Create(const FileName: TFileName);
		destructor Destroy; override;
		function DoGetUrl(ThreadIdx: T2chThreadIndex): string;
		function DoGetLastPrefix(ThreadIdx: T2chThreadIndex; Count: Integer): string;
		function DoGetDatPath(ThreadIdx: T2chThreadIndex): string;
		function DoGetResStartPrefix(ThreadIdx: T2chThreadIndex; Num: Integer): string;
		function DoGetBoardUrl(PathInfo: TStringList; const ServerName, BoardName: string): string;
	end;
	
function MoveToRecycleBin(List: TStringList): Boolean;
function FindKatjushaForm: HWND;
procedure CallKatjusha(const URL: string);
procedure CallBrowser(const URL: string);
procedure UnzipStream(Source: TStream);
function UnzipString(const S: string): string;
procedure RemoveToolButton(ToolBar: TToolBar; Button: TToolButton = nil);
function URLToPath(const URL: string): string;
function HTML2String(const HTML: string): string;

{ MonaUtilsRsy }
function IsUrlDelimiter(const S: string; Index: Integer): Boolean;
function ExtractUrlPath(const FileName: string): string;
function ExtractUrlName(const FileName: string): string;
function ExcludeTrailingSlash(const S: string): string;

var
	KatfavUtilsDefaultBrowser: string;
	
implementation

uses ShellApi, IdHttp, IdException, IdAntiFreeze, FavMain,
  IdTCPConnection, AWKFunc, gzip;

const
	ThreadColumnSection = 'ThreadColumnSize';
	MainFormSection = 'MainForm';
	PropertySection = 'Property';
	BrowserSection = 'Browser';
	ArchiverSection = 'Archiver';
	CustomSortSection = 'CustomSort';
	ThreadListSection = 'ThreadList';
	FavoritesSection = 'Favorites';
	DblClickActionStrings: array [TThreadListDblClickAction] of string =
		('Internal', 'Katjusha', 'Browser', 'Property');
	BrowserTypeStrings: array [TThreadListBrowserType] of string =
		('Last50', 'NewRes');
	URLCopyActionStrings: array [TThreadListURLCopyAction] of string =
		('URLOnly', 'URLWithTitle');
		
function MoveToRecycleBin(List: TStringList): Boolean;
var
	FullPathList: TStringList;
	FileOp: TSHFileOpStruct;
	Buf, FileNamePos: PChar;
	I, Size: Integer;
{DequotedStr}
	function DequotedStr(const Str: string): string;
	begin
		if (Str[1] = '"') and (Str[Length(Str)] = '"') then
			Result := Copy(Str, 2, Length(Str) - 2)
		else
			Result := Str;
	end;
begin
	Buf := nil;
	Size := 0;
	
	FillChar(FileOp, SizeOf(FileOp), 0);
	FileOp.Wnd := Application.MainForm.Handle;
	FileOp.wFunc := FO_DELETE;
	FileOp.fFlags := FOF_ALLOWUNDO or FOF_SILENT or FOF_NOCONFIRMATION;

	FullPathList := TStringList.Create;
	try
		Buf := AllocMem(1024);
		for I := 0 to List.Count - 1 do
		begin
			GetFullPathName(PChar(DequotedStr(List[I])), 1024, Buf, FileNamePos);
			FullPathList.Add(Buf);
			Inc(Size, StrLen(Buf) + 1);
		end;
		Inc(Size);
		FreeMem(Buf);

		Buf := AllocMem(Size);
		FileNamePos := Buf;
		for I := 0 to FullPathList.Count - 1 do
		begin
			StrCopy(FileNamePos, PChar(FullPathList[I]));
			FileNamePos := FileNamePos + Length(FullPathList[I]) + 1;
		end;
		FileNamePos^ := Char(0);
		FileOp.pFrom := Buf;
		
		Result := (SHFileOperation(FileOp) = 0);
	finally
		FreeMem(Buf);
		FullPathList.Free;
	end;
end;

function FindKatjushaForm: HWND;
begin
	Result := FindWindow('TKatjushaMainForm', nil);
end;

procedure CallKatjusha(const URL: string);
var
	StartupInfo: TStartupInfo;
	ProcessInfo: TProcessInformation;
	Args, KagePath: string;
begin
	FillMemory(@StartupInfo, SizeOf(StartupInfo), 0);
	FillMemory(@ProcessInfo, SizeOf(ProcessInfo), 0);

	KagePath := TKatjusha.GetKatjushaBaseDir + 'Kage.exe';
	if URL <> ''
		then Args := '"' + KagePath + '" "' + URL + '"'
		else Args := '"' + KagePath + '"';
	CreateProcess(PChar(KagePath), PChar(Args), nil, nil, False, NORMAL_PRIORITY_CLASS, nil, nil, StartupInfo, ProcessInfo);
	WaitForInputIdle(ProcessInfo.hProcess, INFINITE);
	CloseHandle(ProcessInfo.hThread);
	CloseHandle(ProcessInfo.hProcess);
end;

procedure CallBrowser(const URL: string);
var
	StartupInfo: TStartupInfo;
	ProcessInfo: TProcessInformation;
	Args: string;
begin
	if KatfavUtilsDefaultBrowser = '' then
		ShellExecute(Application.MainForm.Handle, 'open', PChar(URL), nil, nil, SW_SHOW)
	else
	begin
		FillMemory(@StartupInfo, SizeOf(StartupInfo), 0);
		FillMemory(@ProcessInfo, SizeOf(ProcessInfo), 0);

		Args := '"' + KatfavUtilsDefaultBrowser + '" "' + URL + '"';

		CreateProcess(PChar(KatfavUtilsDefaultBrowser), PChar(Args), nil, nil, False,
									NORMAL_PRIORITY_CLASS, nil, nil, StartupInfo, ProcessInfo);
		WaitForInputIdle(ProcessInfo.hProcess, INFINITE);
		
		CloseHandle(ProcessInfo.hThread);
		CloseHandle(ProcessInfo.hProcess);
	end;
end;

procedure UnzipStream(Source: TStream);
var
	Str: array [0 .. 255] of Char;
	Count: Integer;
	Mem: TMemoryStream;
	GZipStream: TGzipDecompressStream;
begin
	Mem := nil;
	
	try
		Mem := TMemoryStream.Create;
		GZipStream := TGzipDecompressStream.Create(Mem);

		Source.Seek(0, soFromBeginning);
		repeat
			Count := Source.Read(Str, Sizeof(Str));
			GZipStream.Write(Str, Count);
		until Count <> SizeOf(Str);

		FreeAndNil(GZipStream);
		Source.Size := 0;
		Mem.Seek(0, soFromBeginning);
		Source.CopyFrom(Mem, Mem.Size);
	finally
		Mem.Free;
		GZipStream.Free;
	end;
end;

function UnzipString(const S: string): string;
var
	Stream: TStringStream;
	GZipStream: TGzipDecompressStream;
begin
	Stream := nil;
	GZipStream := nil;
	Result := '';

	try
		Stream := TStringStream.Create('');
		GZipStream := TGzipDecompressStream.Create(Stream);

		GZipStream.Write(PChar(S)^, Length(S));
		FreeAndNil(GZipStream);

		Result := Stream.DataString;
	finally
		GZipStream.Free;
		Stream.Free;
	end;
end;

procedure RemoveToolButton(ToolBar: TToolBar; Button: TToolButton = nil);
var
	I: Integer;
begin
	if Button <> nil then
	begin
		Button.Parent := nil;
		Button.Free;
		Exit;
	end;

	for I := ToolBar.ButtonCount - 1 downto 0 do
	begin
		Button := ToolBar.Buttons[I];
		Button.Parent := nil;
		Button.Free;
	end;
end;

{ MonaUtilsRsy }
function IsUrlDelimiter(const S: string; Index: Integer): Boolean;
begin
	Result := (Index > 0) and (Index <= Length(S)) and (S[Index] = '/')
		and (ByteType(S, Index) = mbSingleByte);
end;

function ExtractUrlName(const FileName: string): string;
var
	I: Integer;
begin
	I := LastDelimiter('/:', FileName);
	Result := Copy(FileName, I + 1, MaxInt);
end;

function ExtractUrlPath(const FileName: string): string;
var
	I: Integer;
begin
	I := LastDelimiter('/:', FileName);
	Result := Copy(FileName, 1, I);
end;

function ExcludeTrailingSlash(const S: string): string;
begin
	Result := S;
	if IsUrlDelimiter(Result, Length(Result)) then
		SetLength(Result, Length(Result)-1);
end;

function URLToPath(const URL: string): string;
begin
	Result := AnsiReplaceStr(URL, '/', '_');
	Result := AnsiReplaceStr(Result, ':', '_');
end;

function HTML2String(const HTML: string): string;
var
	Text, S: string;
	I, J: Integer;
begin
  Result := '';

	Text := AWKGSub('<[Bb][Rr]>', #13#10, HTML);
	Text := AWKGSub('<[^>]+>', '', Text);
	Text := AWKGSub('[ '#9']+', ' ', Text);

	I := 1;

	while I <= Length(Text) do
	begin
		if Text[I] = '&' then
		begin
			S := '';

			J := I + 1;
			while J <= Length(Text) do
			begin
				case Text[J] of
					'A'..'Z', 'a'..'z': begin
						S := S + Text[J];
						Inc(J);
					end;
					else Break;
				end;
			end;

			if J > Length(Text) then
			begin
				Result := Result + Copy(Text, I, MaxInt);
				Break;
			end;
			
			if Text[J] = ';' then
			begin
				if S = 'amp' then
					Result := Result + '&'
				else if S = 'gt' then
					Result := Result + '>'
				else if S = 'lt' then
					Result := Result + '<'
				else if (S = 'nbsp') or (S = 'ensp') or (S = 'thinsp') then
					Result := Result + ' '
				else if S = 'copy' then
					Result := Result + '(c)'
				else
					Result := Result + '&' + S + ';';
				I := J + 1;
			end else begin
				Result := Result + Copy(Text, I, J - I + 1);
				I := J + 1;
			end;
		end else begin
			Result := Result + Text[I];
			Inc(I);
		end;
	end;
end;

{ TKatfavIniFile }

constructor TKatfavIniFile.Create(const FileName: TFileName);
begin
	IniFile := TMemIniFile.Create(FileName);
	TimeOut := 15;
	NoLoadFavorites := False;
	FThreadListParams := TThreadListParams.Create;
	CoolBarBandParams := TCoolBarBandParams.Create;
	FNewResCheckParams := TNewResCheckParams.Create;
	NoLoadFavoritesDetail := TStringList.Create;
end;

destructor TKatfavIniFile.Destroy;
begin
	FThreadListParams.Free;
	CoolBarBandParams.Free;
	FNewResCheckParams.Free;
	NoLoadFavoritesDetail.Free;
	IniFile.Free;
end;

procedure TKatfavIniFile.SetNewResCheckParams(
  const Value: TNewResCheckParams);
begin
	FNewResCheckParams.Assign(Value);
end;

procedure TKatfavIniFile.SetThreadListParams(
  const Value: TThreadListParams);
begin
	FThreadListParams.Assign(Value);
end;

procedure TKatfavIniFile.Update(Direction: Boolean);
var
	I: Integer;
	Stream: TStringStream;

	function ReadIndex(const Section, Ident: string; Index: array of string; Default: Integer): Integer;
	var
		I: Integer;
		S: string;
	begin
		Result := Default;
		S := IniFile.ReadString(Section, Ident, Index[Default]);
		I := AnsiIndexStr(S, Index);
		if I >= 0 then Result := I;
	end;

	procedure ReadNoFavoritesDetial(List: TStringList; const S: string);
	begin
		List.Clear;
		AWKSplit(',', S, List);
	end;
begin
	Stream := TStringStream.Create('');
	try
		{ CoolBarZNV }
		CoolBarBandParams.Update(IniFile, Direction);

		{ NewResCheckZNV }
		FNewResCheckParams.Update(IniFile, Direction);
		
		if Direction then
		begin
			{ ThreadColumnZNV }
			ThreadListParams.ColumnCount := IniFile.ReadInteger(ThreadColumnSection, 'ColumnCount', ThreadListParams.ColumnCount);
			for I := 0 to ThreadListParams.ColumnCount - 1 do
				ThreadListParams.ColumnWidth[I] := IniFile.ReadInteger(ThreadColumnSection, 'Column' + IntToStr(I), ThreadListParams.ColumnWidth[I]);

			{ MainFormZNV }
			WindowState := TWindowState(IniFile.ReadInteger(MainFormSection, 'WindowState', Ord(WindowState)));
			TreeViewWidth := IniFile.ReadInteger(MainFormSection, 'TreeViewWidth', TreeViewWidth);
			MainFormRect.Top := IniFile.ReadInteger(MainFormSection, 'Top', MainFormRect.Top);
			MainFormRect.Left := IniFile.ReadInteger(MainFormSection, 'Left', MainFormRect.Left);
			MainFormRect.Bottom := IniFile.ReadInteger(MainFormSection, 'Height', MainFormRect.Bottom);
			MainFormRect.Right := IniFile.ReadInteger(MainFormSection, 'Width', MainFormRect.Right);
			ShowToolBar := IniFile.ReadBool(MainFormSection, 'ShowToolBar', ShowToolBar);
			BoardButtonList := IniFile.ReadString(MainFormSection, 'BoardButton', BoardButtonList);
			SaveConfirmation := IniFile.ReadBool(MainFormSection, 'SaveConfirmation', SaveConfirmation);
			
			{ FavoritesZNV }
			NoLoadFavorites := IniFile.ReadBool(FavoritesSection, 'NoLoad', False);
			ReadNoFavoritesDetial(NoLoadFavoritesDetail, IniFile.ReadString(FavoritesSection, 'NoLoadFavorites', ''));
			
			BodyStyle := IniFile.ReadString(PropertySection, 'BodyStyle', BodyStyle);

			{ BrowserZNV }
			ProxyAddress := IniFile.ReadString(BrowserSection, 'ProxyAddress', ProxyAddress);
			ProxyPort := IniFile.ReadInteger(BrowserSection, 'ProxyPort', 8080);
			TimeOut := IniFile.ReadInteger(BrowserSection, 'TimeOut', TimeOut);
			DefaultBrowserCommand := IniFile.ReadString(BrowserSection, 'DefaultBrowser', DefaultBrowserCommand);

			ArchiveExt := IniFile.ReadString(ArchiverSection, 'ArchiveExt', '.zip');

			ThreadListParams.DblClickAction :=
				TThreadListDblClickAction(ReadIndex(ThreadListSection, 'DblClickAction', DblClickActionStrings, Ord(daInternal)));
			ThreadListParams.BrowserType :=
				TThreadListBrowserType(ReadIndex(ThreadListSection, 'BrowserType', BrowserTypeStrings, Ord(btLast50)));
			ThreadListParams.URLCopyAction :=
				TThreadListURLCopyAction(ReadIndex(ThreadListSection, 'URLCopyAction', URLCopyActionStrings, Ord(ucURLWithTitle)));
			ThreadListParams.AlreadyGetFull := IniFile.ReadBool(ThreadListSection, 'AlreadyGetFull', False);
			ThreadListParams.UseNewThreadReport := IniFile.ReadBool(ThreadListSection, 'UseNewThreadReport', True);
			ThreadListParams.UseDepth := IniFile.ReadBool(ThreadListSection, 'UseDepth', FThreadListParams.UseDepth);
		end else begin
			IniFile.WriteInteger(ThreadColumnSection, 'ColumnCount', FThreadListParams.ColumnCount);
			for I := 0 to FThreadListParams.ColumnCount - 1 do
				IniFile.WriteInteger(ThreadColumnSection, 'Column' + IntToStr(I), FThreadListParams.ColumnWidth[I]);

			IniFile.WriteInteger(MainFormSection, 'WindowState', Ord(WindowState));
			IniFile.WriteInteger(MainFormSection, 'TreeViewWidth', TreeViewWidth);
			IniFile.WriteBool(MainFormSection, 'ShowToolBar', ShowToolBar);
			IniFile.WriteString(MainFormSection, 'BoardButton', BoardButtonList);
			IniFile.WriteBool(MainFormSection, 'SaveConfirmation', SaveConfirmation);

			{ ő剻ĂƂ̓EChETCYۑȂ }
			if WindowState = wsNormal then
			begin
				IniFile.WriteInteger(MainFormSection, 'Top', MainFormRect.Top);
				IniFile.WriteInteger(MainFormSection, 'Left', MainFormRect.Left);
				IniFile.WriteInteger(MainFormSection, 'Height', MainFormRect.Bottom);
				IniFile.WriteInteger(MainFormSection, 'Width', MainFormRect.Right);
			end;

			IniFile.WriteString(PropertySection, 'BodyStyle', BodyStyle);

			IniFile.WriteString(BrowserSection, 'ProxyAddress', ProxyAddress);
			IniFile.WriteInteger(BrowserSection, 'ProxyPort', ProxyPort);
			IniFile.WriteInteger(BrowserSection, 'TimeOut', TimeOut);
			IniFile.WriteString(BrowserSection, 'DefaultBrowser', DefaultBrowserCommand);

			IniFile.WriteString(ArchiverSection, 'ArchiveExt', ArchiveExt);

			IniFile.WriteString(ThreadListSection, 'DblClickAction', DblClickActionStrings[FThreadListParams.DblClickAction]);
			IniFile.WriteString(ThreadListSection, 'BrowserType', BrowserTypeStrings[FThreadListParams.BrowserType]);
			IniFile.WriteString(ThreadListSection, 'URLCopyAction', URLCopyActionStrings[FThreadListParams.URLCopyAction]);
			IniFile.WriteBool(ThreadListSection, 'AlreadyGetFull', FThreadListParams.AlreadyGetFull);
			IniFile.WriteBool(ThreadListSection, 'UseNewThreadReport', FThreadListParams.UseNewThreadReport);
			IniFile.WriteBool(ThreadListSection, 'UseDepth', FThreadListParams.UseDepth);
			
			IniFile.UpdateFile;
		end;
	finally
		Stream.Free;
	end;
end;

{ TResCheckThread }

procedure TResCheckThread.CatchError;
begin
	KatfavMainForm.ThreadCatchError(ErrorMessage);
end;

procedure TResCheckThread.CheckComplete;
begin
	KatfavMainForm.BoardView.Enabled := True;
	KatfavMainForm.StatusText := Format('"%s"̐V`FbN܂B', [FDisplayName]);
end;

procedure TResCheckThread.CheckJBBSShitaraba(ThreadIdx: T2chThreadIndex; var ResCount: Integer);
var
	HTTP: TIdHTTP;
	URL, Res, StorageAddr: string;
	List: TStringList;
	Stream: TMemoryStream;
	CommParams: TKatjushaCommunicationParams;
	I: Integer;
begin
	ResCount := -1;
	HTTP := nil;
	List := nil;
	Stream := nil;

	try
		HTTP := TIdHTTP.Create(nil);
		List := TStringList.Create;
		Stream := TMemoryStream.Create;
		
		URL := ThreadIdx.URL + '&LAST=2&NOFIRST=TRUE';
		{ Location: ../351/storage/1014382363.html }
		StorageAddr := Format('/storage/%s.html', [CurrToStr(ThreadIdx.ThreadNum)]);
		CommParams := TKatjusha.GetCommParams;
		
		with HTTP do
		begin
			Request.Clear;
			Request.UserAgent := CommParams.UserAgent;
			if CommParams.ProxyParams.ProxyServer <> '' then
			begin
				ProxyParams.Assign(CommParams.ProxyParams);
			end else begin
				ProxyParams.ProxyPort := 80;
				ProxyParams.ProxyServer := '';
			end;
			ReadTimeout := CommParams.ReadTimeOut;
			HandleRedirects := False;
			Response.Clear;
		end;

		try
			HTTP.Get(URL, Stream);
		except
			on E: EIdHTTPProtocolException do
				begin
					{ ߋOqɂɔ΂ꂽƂ }
					if (E.ReplyErrorCode = 302) and
						 (Pos(StorageAddr, HTTP.Response.Location) > 0) then
						raise EResCheckStorageLogException.Create('ߋOɗ܂B')
					else
						Exit;
				end;
			on EIdException do
				Exit;
		end;

		Stream.Seek(0, soFromBeginning);
		List.LoadFromStream(Stream);
		FreeAndNil(Stream);
		
		for I := 0 to List.Count - 1 do
		begin
			if Pos('<dt>', List[I]) = 1 then
			begin
				AWKMatch1('^<dt>([0-9]+)', List[I], Res);
				ResCount := StrToIntDef(Res, -1);
				Exit;
			end;
		end;
	finally
		Stream.Free;
		List.Free;
		HTTP.Free;
	end;
end;

constructor TResCheckThread.Create(CreateSuspended: Boolean);
begin
	inherited;
	FParams := TNewResCheckParams.Create;
end;

destructor TResCheckThread.Destroy;
begin
	FParams.Free;
  inherited;
end;

procedure TResCheckThread.Execute;
var
	DatDrop, Error, UpdateIndex: Boolean;
	URL: string;
	I, ResCount: Integer;
	HTTP: TIdHTTP;
	NewIdx, Idx: T2chThreadIndex;
	Item: TListItem;
	SkipServerList: TStringList;
	CommParams: TKatjushaCommunicationParams;
begin
	HTTP := nil;
	SkipServerList := nil;
	NewIdx := nil;

	UpdateIndex := False;
	if Params.UpdateIndexFile then
		if not Params.NoUpdateRunningKatjusha then
			UpdateIndex := True
		else if FindKatjushaForm = 0 then
			UpdateIndex := True;
	
	try
		HTTP := TIdHTTP.Create(nil);
		SkipServerList := TStringList.Create;
		NewIdx := T2chThreadIndex.Create;
		CommParams := TKatjusha.GetCommParams;

		while True do
		begin
			Suspend;
			if Terminated then Exit;
			
			try
				SkipServerList.Clear;
				for I := 0 to ListView.Items.Count - 1 do
				begin
					if Terminated then Exit;
					
					DatDrop := False;
					Error := False;
					Item := ListView.Items[I];
					Idx := T2chThreadIndex(ListView.Items[I].Data);
					{ ŐVIndexǂݍ }
					NewIdx.LoadFromFile(TKatjusha.GetKatjushaBaseDir + 'log\' + Idx.LogPath);
					URL := Idx.DatPath;
					
					if URL = 'none' then Continue;
					if Idx.ResCount >= 1000 then Continue;
					if stLog in Idx.State then Continue;
					{ Idx.State := Idx.State - [stLog]; }

					{ UCKȂǂłłɐV̂Ăꍇ͐Vɐݒ肷 }
					if (NewIdx.BeforeResCount > NewIdx.ResCount) or (Idx.BeforeResCount > NewIdx.ResCount) then
					begin
						Idx.ResState := rsNew;
						Item.StateIndex := 1;
						Continue;
					end;

					if SkipServerList.IndexOf(Idx.ServerName) >= 0 then
					begin
						Idx.ResState := rsError;
						Item.StateIndex := 3;
						Continue;
					end;
					
					Idx.ResState := rsCheck;
					Item.StateIndex := 0;

					if URL = 'jbbs.shitaraba.com' then
					begin
						ResCount := -1;
						DatDrop := False;
						try
							CheckJBBSShitaraba(Idx, ResCount);
						except
							on EResCheckStorageLogException do	{ ߋOqɗ }
								DatDrop := True;
							else
								raise;
						end;

						if ResCount > NewIdx.ResCount then
						begin
							Idx.ResState := rsNew;
							Item.StateIndex := 1;
							Idx.BeforeResCount := ResCount;
						end else begin
							Idx.ResState := rsNone;
							if DatDrop then
							begin
								Idx.State := Idx.State + [stLog];
								Idx.BeforeResCount := Idx.ResCount;
								Item.StateIndex := 2;
							end else begin
								Item.StateIndex := -1;
							end;
							
							if ResCount > 0 then
								Idx.BeforeResCount := ResCount
							else begin	{ G[̏ꍇ(-1) }
								ResCount := Idx.ResCount;	{ -1(G[)̏ꍇ݂͌̃Xݒ }
							end;
						end;
						Item.Assign(Idx);

						{ fBXÑCfbNXXV }
						if UpdateIndex then
						begin
							NewIdx.BeforeResCount := ResCount;
							NewIdx.State := Idx.State;
							try
								NewIdx.SaveToFile(TKatjusha.GetKatjushaBaseDir + 'log\' + Idx.LogPath);
							except
							end;
						end;
						Continue;
					end;
					
					with HTTP do
					begin
						Request.Clear;
						Request.UserAgent := CommParams.UserAgent;
						if CommParams.ProxyParams.ProxyServer <> '' then
						begin
							ProxyParams.Assign(CommParams.ProxyParams);
						end else begin
							ProxyParams.ProxyPort := 80;
							ProxyParams.ProxyServer := '';
						end;
						ReadTimeout := CommParams.ReadTimeOut;
						HandleRedirects := False;
						Response.Clear;
					end;

					try
						HTTP.Head(URL);
					except
						on E: EIdProtocolReplyError do
						begin
							if E.ReplyErrorCode = 302 then
								DatDrop := True
							else
								Error := True;
							HTTP.Disconnect;
						end;
						else
							Error := True;
							HTTP.Disconnect;
					end;

					if Error then
					begin
						Idx.ResState := rsError;
						Item.StateIndex := 3;
						SkipServerList.Add(Idx.ServerName);
					end else if DatDrop then
					begin
						Idx.State := Idx.State + [stLog];
						Idx.ResState := rsNone;
						Item.StateIndex := 2;
					end
					else if NewIdx.DatSize <> HTTP.Response.ContentLength then
					begin
						Idx.ResState := rsNew;
						Item.StateIndex := 1;
					end else begin
						Idx.ResState := rsNone;
						Item.StateIndex := -1;
					end;
				end;
			except
				on E: Exception do begin
					ErrorMessage := E.Message;
					Synchronize(CatchError);
				end;
			end;

			Synchronize(CheckComplete);
		end;
	finally
		NewIdx.Free;
		SkipServerList.Free;
		HTTP.Free;
	end;
end;

procedure TResCheckThread.SetParams(const Value: TNewResCheckParams);
begin
	FParams.Assign(Value);
end;

{ TVersionInformation }

constructor TVersionInformation.Create(const FileName: TFileName);
begin
	LoadInformation(FileName);
end;

procedure TVersionInformation.LoadInformation(const FileName: TFileName);
var
	Size: Integer;
	Data: DWORD;
	Buf, Value: PChar;
	VerList: TStringList;
begin
	VerList := TStringList.Create;

	try
		Size := GetFileVersionInfoSize(PChar(FileName), Data);
		if Size > 0 then
		begin
			Buf := AllocMem(Size);
			try
				GetFileVersionInfo(PChar(FileName), 0, Size, Buf);
				if VerQueryValue(Buf, '\StringFileInfo\041103A4\FileVersion', Pointer(Value), Data) then
				begin
					if AWKSplit('\.',Value, VerList) < 0 then Abort;

					Major := StrToInt(VerList[0]);
					Minor := StrToInt(VerList[2]);
					Build := StrToInt(VerList[3]);
				end;
			finally
				FreeMem(Buf);
			end;
		end;
	finally
		VerList.Free;
	end;
end;

{ TKatfavScriptManager }

constructor TKatfavScriptManager.Create(const FileName: TFileName);
begin
	DMonkey := TDMonkey.Create(nil);
	DMonkey.OnStderr := DebugOutput;
	DMonkey.ImportObject('ThreadIndex', TJ2chThreadIdx);
	if not DMonkey.CompileFile(FileName) then
		raise EKatfavScriptError.Create('RpCG[');

	DMonkey.Run;

	Katjusha.Do2chThreadGetUrl := DoGetUrl;
	Katjusha.Do2chThreadGetLastPrefix := DoGetLastPrefix;
	Katjusha.Do2chThreadGetDatPath := DoGetDatPath;
	Katjusha.Do2chThreadGetResStartPrefix := DoGetResStartPrefix;
	Katjusha.DoKatjushaGetBoardUrl := DoGetBoardUrl;
end;

procedure TKatfavScriptManager.DebugOutput(Sender: TObject; S: string);
begin
	ShowMessage(S);
end;

destructor TKatfavScriptManager.Destroy;
begin
	DMonkey.Free;
	inherited;
end;

function TKatfavScriptManager.DoGetBoardUrl(PathInfo: TStringList;
  const ServerName, BoardName: string): string;
var
	JStrings: TJStringsObject;
	RetValue: TJValue;
begin
	JStrings := TJStringsObject.Create(DMonkey.Factory, nil);
	try
		JStrings.IncRefCount;
		JStrings.Strings.Assign(PathInfo);
		if not DMonkey.CallFunction('GetBoardUrl', [JStrings, ServerName, BoardName], RetValue) then
		begin
			{ ĂяoɎs }
			Katjusha.DoKatjushaGetBoardUrl := nil;
			Result := TKatjusha.DefaultGetBoardUrl(ServerName, BoardName);
			Exit;
		end;
		Result := AsString(@RetValue);
	finally
		JStrings.DecRefCount;
	end;
end;

function TKatfavScriptManager.DoGetDatPath(ThreadIdx: T2chThreadIndex): string;
var
	JThread: TJ2chThreadIdx;
	RetValue: TJValue;
begin
	JThread := TJ2chThreadIdx.Create(DMonkey.Factory, nil);
	JThread.IncRefCount;
	JThread.Assign(ThreadIdx);
	if not DMonkey.CallFunction('GetDatPath', [JThread], RetValue) then
	begin
		{ ĂяoɎs }
		Katjusha.Do2chThreadGetDatPath := nil;
		Result := ThreadIdx.DatPath;
		Exit;
	end;
	Result := AsString(@RetValue);
	JThread.DecRefCount;
end;

function TKatfavScriptManager.DoGetLastPrefix(ThreadIdx: T2chThreadIndex;
  Count: Integer): string;
var
	JThread: TJ2chThreadIdx;
	RetValue: TJValue;
begin
	JThread := TJ2chThreadIdx.Create(DMonkey.Factory, nil);
	JThread.IncRefCount;
	JThread.Assign(ThreadIdx);
	if not DMonkey.CallFunction('GetLastPrefix', [JThread, Count], RetValue) then
	begin
		{ ĂяoɎs }
		Katjusha.Do2chThreadGetLastPrefix := nil;
		Result := ThreadIdx.GetLastPrefix(Count);
		Exit;
	end;
	Result := AsString(@RetValue);
	JThread.DecRefCount;
end;

function TKatfavScriptManager.DoGetResStartPrefix(
  ThreadIdx: T2chThreadIndex; Num: Integer): string;
var
	JThread: TJ2chThreadIdx;
	RetValue: TJValue;
begin
	JThread := TJ2chThreadIdx.Create(DMonkey.Factory, nil);
	JThread.IncRefCount;
	JThread.Assign(ThreadIdx);
	if not DMonkey.CallFunction('GetResStartPrefix', [JThread, Num], RetValue) then
	begin
		{ ĂяoɎs }
		Katjusha.Do2chThreadGetResStartPrefix := nil;
		Result := ThreadIdx.GetResStartPrefix(Num);
		Exit;
	end;
	Result := AsString(@RetValue);
	JThread.DecRefCount;
end;

function TKatfavScriptManager.DoGetUrl(ThreadIdx: T2chThreadIndex): string;
var
	JThread: TJ2chThreadIdx;
	RetValue: TJValue;
begin
	JThread := TJ2chThreadIdx.Create(DMonkey.Factory, nil);
	JThread.IncRefCount;
	JThread.Assign(ThreadIdx);
	if not DMonkey.CallFunction('GetUrl', [JThread], RetValue) then
	begin
		{ ĂяoɎs }
		Katjusha.Do2chThreadGetUrl := nil;
		Result := ThreadIdx.URL;
		Exit;
	end;
	Result := AsString(@RetValue);
	JThread.DecRefCount;
end;

{ TJ2chThreadIdx }

procedure TJ2chThreadIdx.Assign(Source: TPersistent);
begin
	if Source is T2chThreadIndex then
	begin
(*		FThreadName: string;
		FBoardName: string;
		FServerName: string;
		FBoardPath: string;
		FDateTime: TJDateObject;
		FWriteTime: TJDateObject;
		FNumber: Integer;
		FThreadNum: string;
		FBeforeResCount: Integer;		{ X }
		FResCount: Integer;					{ X }
		FNewResCount: Integer;			{ VX }
		FGravity: Integer;					{ dvx? }
		FMemo: string;							{  }
		FDatSize: Integer;   *)
		FThreadName := T2chThreadIndex(Source).ThreadName;
		FBoardName := T2chThreadIndex(Source).BoardName;
		FServerName := T2chThreadIndex(Source).ServerName;
		FBoardPath := T2chThreadIndex(Source).BoardPath;
		FDateTime.LocalTime := T2chThreadIndex(Source).DateTime;
		FWriteTime.LocalTime := T2chThreadIndex(Source).WriteTime;
		FNumber := T2chThreadIndex(Source).Number;
		FThreadNum := FormatCurr('000000000', T2chThreadIndex(Source).ThreadNum);
		FBeforeResCount := T2chThreadIndex(Source).BeforeResCount;
		FResCount := T2chThreadIndex(Source).ResCount;
		FNewResCount := T2chThreadIndex(Source).NewResCount;
		FGravity := T2chThreadIndex(Source).Gravity;
		FMemo := T2chThreadIndex(Source).Memo;
		FDatSize := T2chThreadIndex(Source).DatSize;
	end else
		inherited;
end;

constructor TJ2chThreadIdx.Create(AFactory: TJObjectFactory;
  Param: TJValueList);
begin
	inherited;
	RegistName('ThreadIndex');
	FDateTime := TJDateObject.Create(AFactory, nil);
	FDateTime.IncRefCount;
	FWriteTime := TJDateObject.Create(AFactory, nil);
	FWriteTime.IncRefCount;
end;

destructor TJ2chThreadIdx.Destroy;
begin
	FDateTime.DecRefCount;
	FWriteTime.DecRefCount;
  inherited;
end;

{ TBoardButtonManager }

procedure TBoardButtonManager.Add(ButtonType: TBoardButtonType; BoardName,
  BoardURL: string);
var
	Button: TToolButton;
	Index: Integer;
begin
	{ {^̒ǉ }
	Button := TToolButton.Create(FToolBar);
	Button.Left := 10000;
	Button.Parent := FToolBar;
	Button.AutoSize := True;
	Button.Caption := BoardName;
	Button.OnClick := FOnClick;
	Button.PopupMenu := FPopupMenu;
	
	if ButtonType = bbFavorites then
	begin
		Index := FButtonList.Add('Favorites:' + BoardName);
		Button.Tag := Index + 1;
	end else begin
		Index := FButtonList.Add(BoardName + '<>' + BoardURL);
		Button.Tag := Index + 1;
	end;
end;

procedure TBoardButtonManager.Clear;
begin
	RemoveToolButton(FToolBar);
	FButtonList.Clear;
end;

constructor TBoardButtonManager.Create(ToolBar: TToolBar);
begin
  inherited Create;

	FToolBar := ToolBar;
	FButtonList := TStringList.Create;
end;

destructor TBoardButtonManager.Destroy;
begin
	FreeAndNil(FButtonList);
	
  inherited;
end;

function TBoardButtonManager.GetButtons(Index: Integer): string;
begin
	Result := FButtonList[Index];
end;

function TBoardButtonManager.GetList: string;
var
	BoardText: string;
	I: Integer;
begin
	BoardText := '';

	with FToolBar do
		if ButtonCount > 0 then
		begin
			BoardText := FButtonList[Buttons[0].Tag - 1];

			for I := 1 to ButtonCount - 1 do
				if Buttons[I].Tag > 0 then
					BoardText := BoardText + '<&>' + FButtonList[Buttons[I].Tag - 1];
		end;

	Result := BoardText;
end;

procedure TBoardButtonManager.SetList(const Value: string);
var
	I: Integer;
	ButtonList, BoardList: TStringList;
	Board: string;
begin
	ButtonList := nil;
	BoardList := nil;

	RemoveToolButton(FToolBar);
	FButtonList.Clear;

	try
		ButtonList := TStringList.Create;
		BoardList := TStringList.Create;

		AWKSplit('<&>', Value, ButtonList);

		if (ButtonList.Count = 1) and (ButtonList[0] = '') then
			Exit;

		for I := 0 to ButtonList.Count - 1 do
		begin
			Board := ButtonList[I];

			if Pos('Favorites:', Board) = 1 then
			begin
				{ Cɓ }
				Board := StringReplace(Board, 'Favorites:', '', []);
				Add(bbFavorites, Board, '');
			end else begin
				{ {[h }
				BoardList.Clear;
				AWKSplit('<>', Board, BoardList);
				Add(bbBoards, BoardList[0], BoardList[1]);
			end;
		end;
	finally
		ButtonList.Free;
		BoardList.Free;
	end;
end;

{ TWindowMenuItem }

constructor TWindowMenuItem.Create(AForm: TForm);
begin
	Form := AForm;
end;

destructor TWindowMenuItem.Destroy;
begin
	FMenuItem.Free;
	
  inherited;
end;

procedure TWindowMenuItem.DoClick(Sender: TObject);
begin
	FForm.Show;
	if FForm.WindowState = wsMinimized then
		FForm.WindowState := wsNormal;
end;

procedure TWindowMenuItem.Refresh;
begin
	Assert(FMenuItem <> nil);
	Assert(FForm <> nil);
	FMenuItem.Caption := FForm.Caption;
end;

procedure TWindowMenuItem.SetForm(const Value: TForm);
begin
	FForm := Value;
	if FMenuItem <> nil then FreeAndNil(FMenuItem);
	FMenuItem := NewItem(Value.Caption, 0, False, True, DoClick, 0, Format('Item%d', [Value.Handle]));
end;

{ TWindowMenuList }

function TWindowMenuList.Add(AForm: TForm): Integer;
var
	Item: TWindowMenuItem;
begin
	Item := TWindowMenuItem.Create(AForm);
	FMenu.Add(Item.MenuItem);
	Result := inherited Add(Item);
end;

procedure TWindowMenuList.CloseAll;
var
	I: Integer;
	Form: TForm;
	Item: TWindowMenuItem;
begin
	for I := Count - 1 downto 0 do
	begin
		Item := TWindowMenuItem(Items[I]);
		Form := Item.Form;
		inherited Remove(Item);
		Form.Close;
	end;
end;

constructor TWindowMenuList.Create(AMenu: TMenuItem);
begin
	Menu := AMenu;
	{ IuWFNgIɔj }
	inherited Create(True);
end;

procedure TWindowMenuList.Notify(Ptr: Pointer; Action: TListNotification);
var
	Item: TWindowMenuItem;
begin
	Item := TWindowMenuItem(Ptr);

	if Action = lnDeleted then
		FMenu.Delete(Item.MenuItem.MenuIndex);

  inherited;
end;

procedure TWindowMenuList.Refresh;
var
	I: Integer;
begin
	for I := 0 to Count - 1 do
		TWindowMenuItem(Items[I]).Refresh;
end;

function TWindowMenuList.Remove(AForm: TForm): Integer;
var
	I, Index: Integer;
begin
	Index := -1;

	for I := 0 to Count - 1 do
		if TWindowMenuItem(Items[I]).Form = AForm then
		begin
			Index := I;
			Break;
		end;

	if Index < 0 then
	begin
		Result := Index;
		Exit;
	end;

	Result := inherited Remove(Items[Index]);
end;

end.

