unit FavTypes;

interface

uses
	SysUtils, Classes, ComCtrls, IniFiles;

type
	TThreadListDblClickAction = (daInternal, daKatjusha, daBrowser, daProperty);
	TThreadListBrowserType = (btLast50, btNewRes);
	TThreadListURLCopyAction = (ucURLOnly, ucURLWithTitle);
	TThreadListParams = class(TPersistent)
	private
		FColumnCount: Integer;
		FColumnWidthList: TList;
		FDblClickAction: TThreadListDblClickAction;
		FBrowserType: TThreadListBrowserType;
		FAlreadyGetFull: Boolean;
		FUseNewThreadReport: Boolean;
		FURLCopyAction: TThreadListURLCopyAction;
		FUseDepth: Boolean;
    function GetColumnWidth(Index: Integer): Integer;
    procedure SetColumnCount(const Value: Integer);
    procedure SetColumnWidth(Index: Integer; const Value: Integer);
	public
		constructor Create;
		destructor Destroy; override;
		procedure Assign(Source: TPersistent); override;
		property DblClickAction: TThreadListDblClickAction read FDblClickAction write FDblClickAction;
		property BrowserType: TThreadListBrowserType read FBrowserType write FBrowserType;
		property AlreadyGetFull: Boolean read FAlreadyGetFull write FAlreadyGetFull;
		property UseNewThreadReport: Boolean read FUseNewThreadReport write FUseNewThreadReport;
		property URLCopyAction: TThreadListURLCopyAction read FURLCopyAction write FURLCopyAction;
		property UseDepth: Boolean read FUseDepth write FUseDepth;
		property ColumnCount: Integer read FColumnCount write SetColumnCount;
		property ColumnWidth[Index: Integer]: Integer read GetColumnWidth write SetColumnWidth;
	end;
	TNewResCheckParams = class(TPersistent)
	private
		FUseSavedSubject: Boolean;	{ {[h^u̔\ɕۑĂSubject.txtǂݍ }
		FUpdateIndexFile: Boolean; 	{ Idxt@CVXōXV }
		FNoUpdateRunningKatjusha: Boolean; { `NIdxXVȂ }
	public
		constructor Create;
		procedure Assign(Source: TPersistent); override;
		procedure Update(IniFile: TMemIniFile; Direction: Boolean);
		property UseSavedSubject: Boolean read FUseSavedSubject write FUseSavedSubject;
		property UpdateIndexFile: Boolean read FUpdateIndexFile write FUpdateIndexFile;
		property NoUpdateRunningKatjusha: Boolean read FNoUpdateRunningKatjusha write FNoUpdateRunningKatjusha;
	end;
	TCoolBarBandInfo = record
		BandId: Integer;
		BandWidth: Integer;
		BandBreak: Boolean;
	end;
	PCoolBarBandInfo = ^TCoolBarBandInfo;
	TCoolBarBandParams = class(TPersistent)
	private
		FInternalList: TList;
    function Get(Index: Integer): PCoolBarBandInfo;
	public
		constructor Create;
		destructor Destroy; override;
		procedure Add(BandId, BandWidth: Integer; BandBreak: Boolean);
		procedure Update(IniFile: TMemIniFile; Direction: Boolean);
		procedure Clear;
		procedure Save(CoolBar: TCoolBar);
		procedure Load(CoolBar: TCoolBar);
		property Items[Index: Integer]: PCoolBarBandInfo read Get;
	end;
{ XSpNX }
	TFullTextSearchTargetThread = (fttSelected, fttAll, fttFixed);
	TFullTextSearchTarget = (ftsAll, ftsName, ftsMail, ftsDate, ftsID, ftsMessage);
	TFullTextSearchConfig = class(TPersistent)
	private
		FSearchText: string;
		FCaseInsensitive: Boolean;
		FUseRegularExpression: Boolean;
		FIgnoreTag: Boolean;
		FIgnoreSpace: Boolean;
		FTarget: TFullTextSearchTarget;
		FTargetThread: TFullTextSearchTargetThread;
	public
		procedure Assign(Source: TPersistent); override;
		property SearchText: string read FSearchText write FSearchText;
		property CaseInsensitive: Boolean read FCaseInsensitive write FCaseInsensitive;
		property UseRegularExpression: Boolean read FUseRegularExpression write FUseRegularExpression;
		property IgnoreSpace: Boolean read FIgnoreSpace write FIgnoreSpace;
		property IgnoreTag: Boolean read FIgnoreTag write FIgnoreTag;
		property TargetThread: TFullTextSearchTargetThread read FTargetThread write FTargetThread;
		property Target: TFullTextSearchTarget read FTarget write FTarget;
	end;

implementation

uses Controls;

{ TThreadListParams }

procedure TThreadListParams.Assign(Source: TPersistent);
begin
	if Source is TThreadListParams then
	begin
		FDblClickAction := TThreadListParams(Source).FDblClickAction;
		FBrowserType := TThreadListParams(Source).BrowserType;
		FAlreadyGetFull := TThreadListParams(Source).FAlreadyGetFull;
		FUseNewThreadReport := TThreadListParams(Source).FUseNewThreadReport;
		FURLCopyAction := TThreadListParams(Source).FURLCopyAction;
		FUseDepth := TThreadListParams(Source).FUseDepth;
		FColumnCount := TThreadListParams(Source).FColumnCount;
		FColumnWidthList.Assign(TThreadListParams(Source).FColumnWidthList);
	end else
		inherited;
end;

constructor TThreadListParams.Create;
begin
	FDblClickAction := daInternal;
	FBrowserType := btLast50;
	FAlreadyGetFull := False;
	FUseNewThreadReport := True;
	FURLCopyAction := ucURLWithTitle;
	FUseDepth := False;
	FColumnCount := 0;

	FColumnWidthList := TList.Create;
end;

destructor TThreadListParams.Destroy;
begin
	FColumnWidthList.Free;
  inherited;
end;                                 

function TThreadListParams.GetColumnWidth(Index: Integer): Integer;
begin
	Result := Integer(FColumnWidthList[Index]);
end;

procedure TThreadListParams.SetColumnCount(const Value: Integer);
begin
	FColumnCount := Value;
	FColumnWidthList.Count := Value;
end;

procedure TThreadListParams.SetColumnWidth(Index: Integer;
  const Value: Integer);
begin
	FColumnWidthList[Index] := Pointer(Value);
end;

{ TCoolBarBandParams }

procedure TCoolBarBandParams.Add(BandId, BandWidth: Integer; BandBreak: Boolean);
var
	P: PCoolBarBandInfo;
begin
	New(P);
	P.BandId := BandId;
	P.BandWidth := BandWidth;
	P.BandBreak := BandBreak;
	FInternalList.Add(P);
end;

procedure TCoolBarBandParams.Clear;
var
	I: Integer;
begin
	for I := 0 to FInternalList.Count - 1 do
		Dispose(PCoolBarBandInfo(FInternalList[I]));

	FInternalList.Clear;
end;

constructor TCoolBarBandParams.Create;
begin
	FInternalList := TList.Create;
end;

destructor TCoolBarBandParams.Destroy;
begin
	Clear;
	FreeAndNil(FInternalList);
  inherited;
end;

function TCoolBarBandParams.Get(Index: Integer): PCoolBarBandInfo;
begin
	Result := PCoolBarBandInfo(FInternalList[Index]);
end;

procedure TCoolBarBandParams.Load(CoolBar: TCoolBar);
var
	I: Integer;
	Band: TCoolBand;
begin
	with CoolBar do
		for I := 0 to FInternalList.Count - 1 do
		begin
			Band := TCoolBand(Bands.FindItemID(PCoolBarBandInfo(FInternalList[I]).BandId));
			Band.Index := I;
			Band.Break := PCoolBarBandInfo(FInternalList[I]).BandBreak;
			Band.Width := PCoolBarBandInfo(FInternalList[I]).BandWidth;
		end;
end;

procedure TCoolBarBandParams.Save(CoolBar: TCoolBar);
var
	I: Integer;
begin
	Clear;
	
	with CoolBar do
	begin
		for I := 0 to Bands.Count - 1 do
			Add(Bands[I].ID, Bands[I].Width, Bands[I].Break);
 	end;
end;

procedure TCoolBarBandParams.Update(IniFile: TMemIniFile;
	Direction: Boolean);
const
	CoolBarSection = 'CoolBar';
var
	I, Count: Integer;
	Band: string;
begin
	if Direction then
	begin
		Clear;
		Count := IniFile.ReadInteger(CoolBarSection, 'BandCount', 0);
		if Count = 0 then Exit;

		for I := 0 to Count - 1 do
		begin
			Band := 'Band' + IntToStr(I);
			Add(IniFile.ReadInteger(CoolBarSection, Band + 'Id', 0),
					IniFile.ReadInteger(CoolBarSection, Band + 'Width', 0),
					IniFile.ReadBool(CoolBarSection, Band + 'Break', False));
		end;
	end else begin
		for I := 0 to FInternalList.Count - 1 do
		begin
			Band := 'Band' + IntToStr(I);
			IniFile.WriteInteger(CoolBarSection, Band + 'Id', PCoolBarBandInfo(FInternalList[I]).BandId);
			IniFile.WriteInteger(CoolBarSection, Band + 'Width', PCoolBarBandInfo(FInternalList[I]).BandWidth);
			IniFile.WriteBool(CoolBarSection, Band + 'Break', PCoolBarBandInfo(FInternalList[I]).BandBreak);
		end;

		IniFile.WriteInteger(CoolBarSection, 'BandCount', FInternalList.Count);
	end;
end;

{ TNewResCheckParams }

procedure TNewResCheckParams.Assign(Source: TPersistent);
begin
	if Source is TNewResCheckParams then
	begin
		FUseSavedSubject := TNewResCheckParams(Source).FUseSavedSubject;
		FUpdateIndexFile := TNewResCheckParams(Source).FUpdateIndexFile;
		FNoUpdateRunningKatjusha := TNewResCheckParams(Source).FNoUpdateRunningKatjusha;
	end else
		inherited;
end;

constructor TNewResCheckParams.Create;
begin
	FUseSavedSubject := True;
	FUpdateIndexFile := False;
	FNoUpdateRunningKatjusha := False;
end;

procedure TNewResCheckParams.Update(IniFile: TMemIniFile;
	Direction: Boolean);
const
	NewResCheckSection = 'NewResCheck';
begin
	if Direction then
	begin
		FUseSavedSubject := IniFile.ReadBool(NewResCheckSection, 'UseSavedSubject', FUseSavedSubject);
		FUpdateIndexFile := IniFile.ReadBool(NewResCheckSection, 'UpdateIndexFile', FUpdateIndexFile);
		FNoUpdateRunningKatjusha := IniFile.ReadBool(NewResCheckSection, 'NoUpdateRunningKatjusha', FNoUpdateRunningKatjusha);
	end else begin
		IniFile.WriteBool(NewResCheckSection, 'UseSavedSubject', FUseSavedSubject);
		IniFile.WriteBool(NewResCheckSection, 'UpdateIndexFile', FUpdateIndexFile);
		IniFile.WriteBool(NewResCheckSection, 'NoUpdateRunningKatjusha', FNoUpdateRunningKatjusha);
	end;
end;

{ TFullTextSearchConfig }

procedure TFullTextSearchConfig.Assign(Source: TPersistent);
begin
	if Source is TFullTextSearchConfig then
	begin
		FSearchText := TFullTextSearchConfig(Source).FSearchText;
		FCaseInsensitive := TFullTextSearchConfig(Source).FCaseInsensitive;
		FUseRegularExpression := TFullTextSearchConfig(Source).FUseRegularExpression;
		FIgnoreSpace := TFullTextSearchConfig(Source).FIgnoreSpace;
		FIgnoreTag := TFullTextSearchConfig(Source).IgnoreTag;
		FTargetThread := TFullTextSearchConfig(Source).FTargetThread;
		FTarget := TFullTextSearchConfig(Source).FTarget;
	end else
		inherited;
end;

end.

