unit CustomSortList;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
	Dialogs, StdCtrls, Buttons, Katjusha;

type
  TCustomSortListDlg = class(TForm)
    ListBox1: TListBox;
    EditBtn: TBitBtn;
    Label1: TLabel;
    AddBtn: TBitBtn;
    DelBtn: TBitBtn;
    OkBtn: TBitBtn;
    BitBtn1: TBitBtn;
    procedure FormShow(Sender: TObject);
    procedure AddBtnClick(Sender: TObject);
    procedure EditBtnClick(Sender: TObject);
    procedure OkBtnClick(Sender: TObject);
    procedure DelBtnClick(Sender: TObject);
    procedure ListBox1DblClick(Sender: TObject);
  private
		{ Private 錾 }
		CustomSortObjectList: T2chCustomSortObjectList;
  public
		{ Public 錾 }
		class function Execute(CustomSortList: T2chCustomSortObjectList): Boolean;
  end;


implementation

uses CustomSortEdit;

{$R *.dfm}

{ TCustomSortListDlg }

class function TCustomSortListDlg.Execute(
	CustomSortList: T2chCustomSortObjectList): Boolean;
var
	CustomSortListDlg: TCustomSortListDlg;
	List: T2chCustomSortObjectList;
begin
	List := nil;
	CustomSortListDlg := TCustomSortListDlg.Create(Application.MainForm);
	try
		List := T2chCustomSortObjectList.Create;
		List.Assign(CustomSortList);
		CustomSortListDlg.CustomSortObjectList := List;
		Result := CustomSortListDlg.ShowModal = mrOk;
		if Result then
			CustomSortList.Assign(List);
	finally
		CustomSortListDlg.Free;
		List.Free;
	end;
end;

procedure TCustomSortListDlg.FormShow(Sender: TObject);
var
	I: Integer;
begin
	Assert(Assigned(CustomSortObjectList));

	for I := 0 to CustomSortObjectList.Count - 1 do
		ListBox1.Items.AddObject(CustomSortObjectList.Names[I], CustomSortObjectList[I]);
	for I := CustomSortObjectList.Count - 1 downto 0 do
		CustomSortObjectList.Delete(I);
end;

procedure TCustomSortListDlg.AddBtnClick(Sender: TObject);
var
	SortList: T2chCustomSortList;
	SortListName: string;
begin
	SortList := T2chCustomSortList.Create;
	try
		SortListName := Format('JX^\[g%d', [ListBox1.Items.Count + 1]);
		if TCustomSortEditDlg.Execute(SortListName, SortList) then
			ListBox1.Items.AddObject(SortListName, SortList);
	except
		SortList.Free;
		raise;
	end;
end;

procedure TCustomSortListDlg.EditBtnClick(Sender: TObject);
var
	SortListName: string;
begin
	if ListBox1.ItemIndex < 0 then Exit;

	with ListBox1 do
	begin
		SortListName := Items[ItemIndex];
		if TCustomSortEditDlg.Execute(SortListName, T2chCustomSortList(Items.Objects[ItemIndex])) then
			Items[ItemIndex] := SortListName;
	end;
end;

procedure TCustomSortListDlg.OkBtnClick(Sender: TObject);
var
	I: Integer;
begin
	CustomSortObjectList.Clear;
	
	for I := 0 to ListBox1.Items.Count - 1 do
	begin
		CustomSortObjectList.Add(ListBox1.Items[I], T2chCustomSortList(ListBox1.Items.Objects[I]));
	end;
end;

procedure TCustomSortListDlg.DelBtnClick(Sender: TObject);
begin
	if ListBox1.ItemIndex < 0 then Exit;

	with ListBox1 do
	begin
		Items.Objects[ItemIndex].Free;
		Items.Delete(ItemIndex);
	end;
end;

procedure TCustomSortListDlg.ListBox1DblClick(Sender: TObject);
begin
	EditBtnClick(Self);
end;

end.

