unit AwkFunc;

interface

uses Sysutils, Classes, regex;

type
	EAWKFuncError = class(Exception);

procedure FreeReRegisters(var Registers: re_registers);
procedure AWKCompilePattern(var r: regex_t; const RegExp: string);
function AWKGSub(var r: regex_t; const SubStr: string; Text: string): string; overload;
function AWKGSub(const RegExp: string; const SubStr: string; Text: string): string; overload;
function AWKMatch(const RegExp: string; Text: string; StringList: TStringList): Integer; overload;
function AWKMatch(const RegExp: string; Text: string; var List: array of string): Integer; overload;
function AWKMatch1(var r: regex_t; Text: string; var MatchText: string): Integer; overload;
function AWKMatch1(const RegExp: string; Text: string; var MatchText: string): Integer; overload;
function AWKSplit(var r: regex_t; const OrgText: string; StringList: TStringList): Integer; overload;
function AWKSplit(var r: regex_t; const OrgText: string; var List: array of string): Integer; overload;
function AWKSplit(const RegExp: string; const OrgText: string; StringList: TStringList): Integer; overload;
function AWKSplit(const RegExp: string; const OrgText: string; var List: array of string): Integer; overload;

implementation

procedure FreeReRegisters(var Registers: re_registers);
begin
	if Registers.pstart <> nil then FreeMem(Registers.pstart);
	if Registers.pend <> nil then FreeMem(Registers.pend);
	
	Registers.pstart := nil;
	Registers.pend := nil;
end;

procedure AWKCompilePattern(var r: regex_t; const RegExp: string);
var
	ErrorStr: PChar;
begin
	FillChar(r, SizeOf(r), 0);

	ErrorStr := re_compile_pattern(PChar(RegExp), Length(RegExp), r);
	if ErrorStr <> nil then
		raise EAWKFuncError.Create('K\̃RpCɎs܂: ' + ErrorStr);
end;

function AWKGSub(var r: regex_t; const SubStr: string; Text: string): string;
var
	regs: re_registers;
	I, Index: Integer;
	Str: string;
begin
  Result := '';

	FillChar(regs, SizeOf(regs), 0);

	try
		while True do
		begin
			Index := re_search(r, PChar(Text), Length(Text), 0, Length(Text), regs);
			if Index < 0 then Break;

			Result := Result + Copy(Text, 1, regs.pstart^[0]);
			Text := Copy(Text, regs.pend^[0] + 1, Length(Text) - regs.pend^[0]);

			Str := SubStr;
			for I := 1 to regs.num_regs - 1 do
			begin
				if regs.pstart[I] < 0 then Break;
				Str := StringReplace(Str, '\' + IntToStr(I),
														 Copy(Text, regs.pstart^[I] + 1, regs.pend^[I] - regs.pstart^[I]),
														 [rfReplaceAll]);
			end;

			Result := Result + Str;

			{ pstart & pendĊtȂ悤ɂ }
			r.bits := r.bits or REGS_FIXED;
		end;

		Result := Result + Text;
	finally
		{ rėpۂɊt悤ɂ }
		r.bits := r.bits and (not REGS_FIXED);
		FreeReRegisters(regs);
	end;
end;

function AWKGSub(const RegExp: string; const SubStr: string; Text: string): string;
var
	r: regex_t;
begin
	AWKCompilePattern(r, RegExp);
	Result := AWKGSub(r, SubStr, Text);
end;

function AWKMatch(const RegExp: string; Text: string; StringList: TStringList): Integer;
var
	regs: re_registers;
	r: regex_t;
	ErrorStr: PChar;
	I, Index: Integer;
begin
	Result := -1;
	
	FillChar(regs, SizeOf(regs), 0);
	FillChar(r, SizeOf(r), 0);

	ErrorStr := re_compile_pattern(PChar(RegExp), Length(RegExp), r);
	if ErrorStr <> nil then
		raise EAWKFuncError.Create('K\̃RpCɎs܂: ' + ErrorStr);

	try
		Index := re_search(r, PChar(Text), Length(Text), 0, Length(Text), regs);
		if Index < 0 then Exit;

		if StringList <> nil then
			for I := 0 to regs.num_regs - 1 do
			begin
				if regs.pstart[I] < 0 then Break;
				StringList.Add(Copy(Text, regs.pstart^[I] + 1, regs.pend^[I] - regs.pstart^[I]));
			end;

    Result := Index;
	finally
		FreeReRegisters(regs);
	end;
end;

function AWKMatch(const RegExp: string; Text: string; var List: array of string): Integer;
var
	regs: re_registers;
	r: regex_t;
	ErrorStr: PChar;
	I, Index, Count: Integer;
begin
	Result := -1;
	Count := Low(List);
	
	FillChar(regs, SizeOf(regs), 0);
	FillChar(r, SizeOf(r), 0);

	ErrorStr := re_compile_pattern(PChar(RegExp), Length(RegExp), r);
	if ErrorStr <> nil then
		raise EAWKFuncError.Create('K\̃RpCɎs܂: ' + ErrorStr);

	try
		Index := re_search(r, PChar(Text), Length(Text), 0, Length(Text), regs);
		if Index < 0 then Exit;

		for I := 0 to regs.num_regs - 1 do
		begin
			if regs.pstart[I] < 0 then Break;
			List[Count] := Copy(Text, regs.pstart^[I] + 1, regs.pend^[I] - regs.pstart^[I]);
			Inc(Count);
		end;

    Result := Index;
	finally
		FreeReRegisters(regs);
	end;
end;

function AWKMatch1(var r: regex_t; Text: string; var MatchText: string): Integer; overload;
var
	regs: re_registers;
	Index: Integer;
begin
	Result := -1;
	
	FillChar(regs, SizeOf(regs), 0);

	try
		Index := re_search(r, PChar(Text), Length(Text), 0, Length(Text), regs);
		if Index < 0 then Exit;

		MatchText := '';
		
		if (regs.num_regs > 1) and (regs.pstart^[1] >= 0) then
			MatchText := Copy(Text, regs.pstart^[1] + 1, regs.pend^[1] - regs.pstart^[1]);

    Result := Index;
	finally
		FreeReRegisters(regs);
	end;
end;

function AWKMatch1(const RegExp: string; Text: string; var MatchText: string): Integer; overload;
var
	r: regex_t;
begin
	AWKCompilePattern(r, RegExp);
	Result := AWKMatch1(r, Text, MatchText);
end;

function AWKSplit(var r: regex_t; const OrgText: string; StringList: TStringList): Integer; overload;
var
	regs: re_registers;
	Index, Count: Integer;
	Text: string;
begin
	Count := 0;
	
	FillChar(regs, SizeOf(regs), 0);

	try
		Result := -1;
		Text := OrgText;

		while True do
		begin
			Index := re_search(r, PChar(Text), Length(Text), 0, Length(Text), regs);
			if Index < 0 then Break;

			if regs.pstart^[0] = 0 then
			begin
				StringList.Add('');
				Text := Copy(Text, regs.pend^[0] + 1, Length(Text) - regs.pend^[0]);
			end else begin
				StringList.Add(Copy(Text, 1, regs.pstart^[0]));
				Text := Copy(Text, regs.pend^[0] + 1, Length(Text) - regs.pend^[0]);
			end;

			Inc(Count);

			{ pstart & pendĊtȂ悤ɂ }
			r.bits := r.bits or REGS_FIXED;
		end;

		StringList.Add(Text);
		Inc(Count);

		Result := Count;
	finally
		{ rėpۂɊt悤ɂ }
		r.bits := r.bits and (not REGS_FIXED);
		FreeReRegisters(regs);
	end;
end;

function AWKSplit(var r: regex_t; const OrgText: string; var List: array of string): Integer; overload;
var
	regs: re_registers;
	Index, Count: Integer;
	Text: string;
begin
	Count := 0;
	
	FillChar(regs, SizeOf(regs), 0);

	try
		Result := -1;
		Text := OrgText;

		while True do
		begin
			Index := re_search(r, PChar(Text), Length(Text), 0, Length(Text), regs);
			if Index < 0 then Break;

			if regs.pstart^[0] = 0 then
			begin
				List[Count] := '';
				Text := Copy(Text, regs.pend^[0] + 1, Length(Text) - regs.pend^[0]);
			end else begin
				List[Count] := Copy(Text, 1, regs.pstart^[0]);
				Text := Copy(Text, regs.pend^[0] + 1, Length(Text) - regs.pend^[0]);
			end;

			Inc(Count);

			{ pstart & pendĊtȂ悤ɂ }
			r.bits := r.bits or REGS_FIXED;
		end;

		List[Count] := Text;
		Inc(Count);

		Result := Count;
	finally
		{ rėpۂɊt悤ɂ }
		r.bits := r.bits and (not REGS_FIXED);
		FreeReRegisters(regs);
	end;
end;

function AWKSplit(const RegExp: string; const OrgText: string; StringList: TStringList): Integer; overload;
var
	r: regex_t;
begin
	AWKCompilePattern(r, RegExp);
	Result := AWKSplit(r, OrgText, StringList);
end;

function AWKSplit(const RegExp: string; const OrgText: string; var List: array of string): Integer; overload;
var
	r: regex_t;
begin
	AWKCompilePattern(r, RegExp);
	Result := AWKSplit(r, OrgText, List);
end;

initialization
	re_set_syntax(RE_SYNTAX_GNU_AWK);

end.

