# -*- coding:utf-8-unix -*-
#
# $Id: hde-openssl098.spec,v 1.8 2009/03/25 23:37:19 taizo Exp $
# This file and all modifications and/or additions are under
# the same license as package itself.
#

%define vendor_name	hde
%define target		openssl
%define ver_alias	098
%define distro		HDE, Inc.
%define name		openssl
%define ver		0.9.8
%define ver_alpha	k
%define rel		10
%define openssldir	/var/%{vendor_name}/ssl
%define _prefix		/usr/local/%{vendor_name}
%define _bindir		%{_prefix}/bin
%define _sbindir	%{_prefix}/sbin
%define _libdir		%{_prefix}/lib
%define _includedir	%{_prefix}/include
%define _datadir	%{_prefix}/share
%define _defaultdocdir  %{_datadir}/doc/packages
%define _infodir	%{_datadir}/info
%define _mandir		%{_datadir}/man

Summary:	Secure Sockets Layer and cryptography libraries and tools
Name:		%{vendor_name}-%{target}%{ver_alias}
Version:	%{ver}%{ver_alpha}
Release:	%{rel}
Source0:	http://www.openssl.org/source/openssl-%{version}.tar.gz
Source1:	ca-bundle.crt
Source2:	Makefile.certificate
Source3:	make-dummy-cert
Patch0:		hde-openssl098-sonamever.patch 
License:	Freely distributable
Group:		System Environment/Libraries
URL:		http://www.openssl.org/
Vendor:		HDE, Inc.
Distribution:	HDE, Inc.
BuildRoot:	%{_tmppath}/%{name}-%{ver}-root

PreReq: /sbin/ldconfig
BuildRequires: bc
#NoSource: 0

%description
The OpenSSL Project is a collaborative effort to develop a robust,
commercial-grade, fully featured, and Open Source toolkit implementing the
Secure Sockets Layer (SSL v2/v3) and Transport Layer Security (TLS v1)
protocols with full-strength cryptography world-wide. The project is
managed by a worldwide community of volunteers that use the Internet to
communicate, plan, and develop the OpenSSL tookit and its related
documentation. 

OpenSSL is based on the excellent SSLeay library developed from Eric A.
Young and Tim J. Hudson.  The OpenSSL toolkit is licensed under an
Apache-style licence, which basically means that you are free to get and
use it for commercial and non-commercial purposes. 

This package contains the base OpenSSL cryptography and SSL/TLS 
libraries and tools.

%package devel
Summary: Secure Sockets Layer and cryptography static libraries and headers
Group: Development/Libraries
Requires: %{name} = %{version}-%{release}
%description devel
The OpenSSL Project is a collaborative effort to develop a robust,
commercial-grade, fully featured, and Open Source toolkit implementing the
Secure Sockets Layer (SSL v2/v3) and Transport Layer Security (TLS v1)
protocols with full-strength cryptography world-wide. The project is
managed by a worldwide community of volunteers that use the Internet to
communicate, plan, and develop the OpenSSL tookit and its related
documentation. 

OpenSSL is based on the excellent SSLeay library developed from Eric A.
Young and Tim J. Hudson.  The OpenSSL toolkit is licensed under an
Apache-style licence, which basically means that you are free to get and
use it for commercial and non-commercial purposes. 

This package contains the the OpenSSL cryptography and SSL/TLS 
static libraries and header files required when developing applications.

%prep
rm -rf $RPM_BUILD_ROOT

%setup -q -n %{target}-%{version}
# Set path to perl 
#perl util/perlpath.pl /usr/bin/perl
perl -pi -e "s,/usr/local/ssl,%{openssldir},g" crypto/opensslconf.h

#%patch0 -p1

%build
%define CONFIG_FLAGS -DSSL_ALLOW_ADH --prefix=%{_prefix} --openssldir=%{openssldir} no-rc5 no-rsaref no-idea no-asm

%ifarch i386 i486 i586 i686
./Configure %{CONFIG_FLAGS} linux-elf shared
%endif
%ifarch ppc
./Configure %{CONFIG_FLAGS} linux-ppc shared
%endif
%ifarch alpha
./Configure %{CONFIG_FLAGS} linux-alpha shared
%endif

make
make rehash
make test

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT%{_libdir}
mkdir -p $RPM_BUILD_ROOT%{_libdir}/pkgconfig
make install MANDIR=%{_mandir} LIBDIR=%{_libdir} INSTALL_PREFIX="$RPM_BUILD_ROOT"
chmod +x  $RPM_BUILD_ROOT%{_libdir}/pkgconfig


# rename man 
#for x in $RPM_BUILD_ROOT%{_mandir}/man*/* 
#        do mv ${x} ${x}ssl
#done
## Remove duplicated manuals
rm -f $RPM_BUILD_ROOT%{_mandir}/man1/passwd.1*
rm -f $RPM_BUILD_ROOT%{_mandir}/man3/err.3*
rm -f $RPM_BUILD_ROOT%{_mandir}/man3/rand.3*

rm -f "$RPM_BUILD_ROOT%{_mandir}/man7/Modes of DES.7"

# Install RSAref stuff
#install -m644 rsaref/rsaref.h $RPM_BUILD_ROOT%{_includedir}/openssl/
#install -m644 libRSAglue.a $RPM_BUILD_ROOT%{_libdir}/

# Make backwards-compatibility symlink to ssleay
ln -s ./openssl $RPM_BUILD_ROOT%{_bindir}/ssleay

rm -f $RPM_BUILD_ROOT%{_libdir}/libcrypto.so
rm -f $RPM_BUILD_ROOT%{_libdir}/libcrypto.so.0
rm -f $RPM_BUILD_ROOT%{_libdir}/libssl.so
rm -f $RPM_BUILD_ROOT%{_libdir}/libssl.so.0
#ln -s ./libcrypto.so.%{ver} $RPM_BUILD_ROOT%{_libdir}/libcrypto.so
#ln -s ./libssl.so.%{ver} $RPM_BUILD_ROOT%{_libdir}/libssl.so


# Install shared libs
#chmod 0755 $RPM_BUILD_ROOT%{_libdir}/lib*.so*
#cp -a lib*.so* $RPM_BUILD_ROOT%{_libdir}

install -m644 %{SOURCE1} $RPM_BUILD_ROOT%{openssldir}/certs/ca-bundle.crt
ln -s certs/ca-bundle.crt $RPM_BUILD_ROOT%{openssldir}/cert.pem
install -m644 %{SOURCE2} $RPM_BUILD_ROOT%{openssldir}/certs/Makefile
install -m755 %{SOURCE3} $RPM_BUILD_ROOT%{openssldir}/certs/make-dummy-cert

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(0644,root,root,0755)
%doc CHANGES CHANGES.SSLeay LICENSE NEWS README doc
%attr(0755,root,root) %{_bindir}/*
%attr(0755,root,root) %{_libdir}/*.so.*
%attr(0755,root,root) %{_libdir}/engines/*
%config %attr(0644,root,root) %{_libdir}/pkgconfig/*
%attr(0644,root,root) %{_mandir}/man1/*
%attr(0644,root,root) %{_mandir}/man5/*
#%attr(0755,root,root) %{openssldir}/misc/*
#%config %attr(0644,root,root) %{openssldir}/openssl.cnf 
%dir %attr(0755,root,root) %{openssldir}/certs
%attr(0644,root,root) %{openssldir}/certs/*
%attr(0644,root,root) %{openssldir}/cert.pem
#%dir %attr(0755,root,root) %{openssldir}/misc
#%dir %attr(0750,root,root) %{openssldir}/private

%files devel
%defattr(0644,root,root,0755)
%{_libdir}/*.a
%dir %{_includedir}/openssl
%{_includedir}/openssl/*
%{_mandir}/man3/*
%{_mandir}/man7/*
#%{_libdir}/pkgconfig/openssl.pc

%post
/sbin/ldconfig -n %{_libdir}

%postun
if [ "$1" = "0" ]; then
  /sbin/ldconfig -n %{_libdir}
fi

%changelog
* Thu Mar 25 2009 HDE Package Maintainer <info@hde.co.jp> 0.9.8k-10
- update version 0.9.8k.

* Thu Jan 8 2009 HDE Package Maintainer <info@hde.co.jp> 0.9.8j-9
- update version 0.9.8j.

* Tue Sep 16 2008 HDE Package Maintainer <info@hde.co.jp> - 0.9.8i-8
- update version 0.9.8i.

* Thu May 29 2008 HDE Package Maintainer <info@hde.co.jp> - 0.9.8h-7
- update version 0.9.8h.

* Tue Oct 23 2007 HDE Package Maintainer <info@hde.co.jp> - 0.9.8g-6
- update version 0.9.8g.

* Fri Oct 12 2007 HDE Package Maintainer <info@hde.co.jp> - 0.9.8f-1
- update version 0.9.8f.

* Thu Apr 19 2007 Taizo ITO <taizo.ito@hde.co.jp> - 0.9.8e-5
- enabled rc2 algorithm.

* Thu Mar 29 2007 Taizo ITO <taizo.ito@hde.co.jp> - 0.9.8e-4
- initial build.

