/**
* Kandata
* Copyright (C) 2003. Yoshinori Watanabe
* 
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
* 
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
* 
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
package securitytest.client;

import java.io.*;
import java.awt.*;

import java.awt.event.*;
import javax.swing.*;
import kandata.client.*;
import kandata.*;

/** NCAgAvP[V */
public class SecurityTestClient extends JFrame implements KandataClient {
	static {
		System.out.println("SecurityTestClient loaded.");
	}
	KandataConnector connector;

	public SecurityTestClient() {
		super("Kandata-SecurityTest");
		this.getContentPane().setLayout(new GridLayout(5,5));
		this.getContentPane().add(new JButton(new FileWriteAction()));

		this.setSize(300,300);
		this.setVisible(true);
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				try {
					connector.disconnect();
				}
				catch (KandataClientException ex) { ex.printStackTrace(); }
				catch (KandataServerException ex) { ex.printStackTrace(); }
				System.exit(0);
			}
		});
	}

	/** NCAgAvP[VJn. */
	public void init(KandataConnector connector) {
		this.connector = connector;
	}
	class FileWriteAction extends AbstractAction {
		FileWriteAction() {
			super("SecurityTestDir fBNg쐬");
		}
		public void actionPerformed(ActionEvent event) {
			File dir = new File("SecurityTestDir");
			System.out.println("SecurityTestDir fBNg쐬");
			dir.mkdir();
		}
	}
}
