/**
* Kandata
* Copyright (C) 2003. Yoshinori Watanabe
* 
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
* 
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
* 
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
package roomreservation.server;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import kandata.server.*;
import roomreservation.common.*;

/**
 * c\VXẽT[oAvP[V.
 * NCAg̗v󂯁AAvP[VWbNł RoomReservation 
 * zMĂ܂B
 */
public class RoomReservationServer implements KandataServer {

	RoomReservation app;
	KandataServerContext serverContext;
	String classPath = "";

	/**
	 * KandataT[oNꂽƂɌĂ΂܂B
	 */
	public void init(KandataServerContext serverContext) {
		System.out.println("RoomReservationServer.init()");
		// T[oReLXgێ܂B
		this.serverContext = serverContext;

		// AvP[VWbN쐬܂B
		app = new RoomReservation(serverContext);

		// AvP[VWbN̏s܂B
		try {
			app.init();
		} catch (Exception e) {}

		// KandataANV̓o^
		serverContext.putAction("getRoomList",        new GetRoomListAction());
		serverContext.putAction("getReservationList", new GetReservationListAction());
		serverContext.putAction("registReservation",  new RegistReservationAction());
		serverContext.putAction("cancelReservation",  new CancelReservationAction());
	}

	/**
	 * KandataT[oIƂĂ΂܂B
	 */
	public void exit() {
		// AvP[VWbN̏Is܂B
		app.exit();
	}

	/** NCAgڑꂽƂɌĂ΂܂B*/
	public void connected(KandataClientContext context) {
		// Oo͂Ȃ...
	}

	/**
	 * NCAgؒfꂽƂɌĂ΂܂B
	 * Kandata͏]WebAvƂ͈قȂAؒfꂽCxgm邱Ƃł܂B
	 */
	public void disconnected(KandataClientContext context) {
		// Oo͂Ȃ...
	}

	/**
	 * ۓIActionłB
	 * ځAKandataAction̂ł͂ȂAԂɂ̗lȒۃNX
	 * ͂ނƗǂł傤BׂẴR}hɋʂȑOA㏈Lq
	 * Ƃł܂B
	 */
	abstract class AbstractAction implements KandataAction {
		/** TuNX͂̃\bhł܂B*/
		public final Object execute(KandataEvent event) {
			// OóANCAg̔F؂Ȃ
			// logger.debug("enter");

			// TuNXŎR}hs܂B
			Object result = executeCommand(event);
			//logger.debug("exit");
			return result;
		}
		/** TuNXׂR}h */
		public abstract Object executeCommand(KandataEvent event);
	}

	/** ̈ꗗ擾. */
	class GetRoomListAction extends AbstractAction {
		public Object executeCommand(KandataEvent event) {
			return app.getRoomList();
		}
	}
	/** ŐV̗\󋵂̈ꗗ擾. */
	class GetReservationListAction extends AbstractAction {
		public Object executeCommand(KandataEvent event) {
			return app.getReservationList((String) event.getArg(0));
		}
	}
	/** \񂷂. */
	class RegistReservationAction extends AbstractAction {
		public Object executeCommand(KandataEvent event) {
			boolean rc = app.registReservation((Reservation) event.getArg(0));
			return new Boolean(rc);
		}
	}
	/** \LZ. */
	class CancelReservationAction extends AbstractAction {
		public Object executeCommand(KandataEvent event) {
			app.cancelReservation((Reservation) event.getArg(0));
			return null;
		}
	}
}


