/**
* Kandata
* Copyright (C) 2003. Yoshinori Watanabe
* 
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
* 
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
* 
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
package kandata.client.http;

import java.io.*;
import java.net.*;
import java.lang.reflect.*;
import kandata.client.*;
import kandata.KandataServerException;

/**
 * HTTPgăT[oɐڑ.
 * NCAgAv͂̃NXɂċNǍ
 * ̃NXɂăT[oƒʐMsB
 */
public class HttpConnector implements KandataConnector {
	static final boolean TRACE_ENABLE = true;
	static final void TRACE(String message) { if (TRACE_ENABLE) System.out.println(message); }

	private URL url = null;
	private HttpURLConnection conn = null;
	HttpClassLoader httpClassLoader;
	private String id = null;

	/**
	 * HttpConnector.
	 * ̃NX main()łłȂ.
	 */
	private HttpConnector() {
		httpClassLoader = new HttpClassLoader(this);
	}

	/**
	 * ڑ.
	 */
	public void connect(URL url) throws KandataClientException, KandataServerException {
		TRACE("HttpConnector.connect("+url+")");
		this.url = url;
		try {
			this.conn = (HttpURLConnection) url.openConnection();
			this.conn.setDoOutput(true);
		} catch (IOException ex) {
			throw new KandataClientException("connect failed.", ex);
		}
		id = (String) invoke("@connect", null);
	}

	/**
	 * ؒf.
	 * ConnectorC^[tF[X̎
	 */
	public void disconnect() throws KandataClientException, KandataServerException {
		TRACE("HttpConnector.disconnect()");
		// ؒfʒm
		invoke("@disconnect", null);
		// ؒf
		if (conn != null) {
			conn.disconnect();
			conn = null;
		}
	}

	/**
	 * T[õ\bhĂяo.
	 * ConnectorC^[tF[X̎
	 */
	public Object invoke(String command, Object[] args) throws KandataClientException, KandataServerException {
		TRACE("HttpConnector.invoke("+command+", args);");
		if (args != null) {
			for (int i=0; i<args.length; i++) {
				TRACE("\targs["+i+"]="+args[i]);
			}
		}
		try {
			conn = (HttpURLConnection) url.openConnection();
			conn.setDoOutput(true);
			// POST\bhg
			ObjectOutputStream out = new ObjectOutputStream(conn.getOutputStream());
			out.writeObject(id);
			out.writeObject(command);
			out.writeInt(((args!=null) ? args.length : 0));
			if (args != null) {
				for (int i=0; i<args.length; i++) {
					out.writeObject(args[i]);
				}
			}
			out.close();

			conn.connect();

			ObjectInputStream in = new HttpObjectInputStream(conn.getInputStream(), httpClassLoader);
			Object ret = in.readObject();
			KandataServerException ex = (KandataServerException) in.readObject();
			in.close();
			TRACE("\treturn "+ret);
			conn.disconnect();
			// T[oKandataServerExceptionĂAO𔭐B
			if (ex != null) throw ex;
			return ret;
		} catch (IOException ex) {
			throw new KandataClientException("invoke failed.", ex);
		} catch (ClassNotFoundException ex) {
			throw new KandataClientException("invoke failed.", ex);
		}
	}

	/**
	 * T[õ\[X擾.
	 * ConnectorC^[tF[X̎
	 */
	public byte[] getResource(String path) throws KandataClientException, KandataServerException {
		TRACE("HttpConnector.getResource("+url+")");
		return (byte[]) invoke("@getResource", new Object[] { path });
	}

	/**
	 * T[oɂNCAg̃NXt@C擾.
	 */
	public byte[] getClass(String classname) throws KandataClientException, KandataServerException {
		TRACE("HttpConnector.getClass("+url+")");
		return (byte[]) invoke("@getClass", new Object[] { classname });
	}

	/**
	 * Gg̃NX擾.
	 */
	public String getEntryClassName() throws KandataClientException, KandataServerException {
		return (String) invoke("@getEntryClassName", null);
	}

	/**
	 * KandataAvP[Vs.
	 */
	public static void main(String[] args) throws Exception {
		// ȂƂɂ͎gp@\.
		if (args.length < 1) {
			System.err.println("usage: java kandata.client.http.HttpConnector <url> [<client-type> [<version>]]");
			System.exit(-1);
		}
		String url = args[0];
		String clientType = args.length > 1 ? args[1] : null;	// TODO:ǂĎgH
		String version    = args.length > 2 ? args[2] : null;	// TODO:ǂĎgH
		// T[oɐڑ
		HttpConnector connector = new HttpConnector();
		connector.connect(new URL(args[0]));

		// GgNX炤
		String entry_classname = connector.getEntryClassName();

		// ZLeB}l[Wݒ肷BTODO:ǂăAvƂɃZLeBݒ肷H
//		System.out.println("SecurityManager="+System.getSecurityManager());
//		System.setSecurityManager(new java.rmi.RMISecurityManager());
//		System.out.println("SecurityManager="+System.getSecurityManager());

		// NCAgAvAHttpClassLoaderēǂݍ݁AsB
		Class entry_class = Class.forName(entry_classname, true, connector.httpClassLoader);
		KandataClient client = (KandataClient) entry_class.newInstance();
		client.init(connector);
	}
}
