
/**
 * JMichelle (Java Midori Shell)
 * Copyright (C) 2000 Midori IGA 
 *   (http://www01.u-page.so-net.ne.jp/db3/midori/midosoft.html)
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package jp.ne.nifty.iga.midori.shell.eng;

import gnu.regexp.*;
import jp.ne.nifty.iga.midori.shell.dir.*;
import jp.ne.nifty.iga.midori.shell.io.*;
import jp.ne.nifty.iga.midori.shell.util.*;
import java.io.*;
import java.text.Collator;
import java.util.Vector;

/**
 * JMichelle (Java Midori Shell) : History
 */
public class MdShellListSelection
{
	/**
	 * Command complement function.
	 */
	public static final Object fullfillByList(MdShellEnv shellenv,Vector vecCommandList,MdShellDisplayFormatterInterface formatter,String strRead)
		throws IOException
	{
		if(strRead==null
		|| strRead.length()<=0)
		{
			return null;
		}

		Collator collator=shellenv.getCollatorInstance();

		{
			Vector vecCommandMatch=new Vector(128);
			int iStrReadLength=strRead.length();
			for(int iLoop=0;iLoop<vecCommandList.size();iLoop++)
			{
				String strComp=formatter.format(vecCommandList.elementAt(iLoop));
				if(strComp==null)
				{
					// skipping...
					continue;
				}

				if(collator.equals(strRead,strComp))
				{
					//shellenv.getOut().println("Perfect agreement.");
					return vecCommandList.elementAt(iLoop);
				}

				if(strComp.charAt(0)=='$')
				{
					// $ means hidden command.
					continue;
				}

				try{
					RE rex=new RE(strRead,RE.REG_ICASE,RESyntax.RE_SYNTAX_GREP);
					if(rex.getMatch(strComp)!=null
					|| rex.isMatch(strComp))
					{
						vecCommandMatch.addElement(vecCommandList.elementAt(iLoop));
					}
				}catch(REException ex){
					System.out.println(ex.toString());
					//ex.printStackTrace();
				}

				// 2000/09/19
				// it for string matching
				// old implementation
				// 
				//if(strRead.length()>strComp.length())
				//{
				//	// It is short of length before the comparison.
				//	continue;
				//}
				//
				//String strCompShort=strComp.substring(0,iStrReadLength);
				//if(collator.equals(strRead,strCompShort))
				//{
				//	// A partial hit.
				//	vecCommandMatch.addElement(vecCommandList.elementAt(iLoop));
				//}
			}
			switch(vecCommandMatch.size())
			{
				case 0:
					// isn't done because no more than one was found.
					break;
				case 1:
					// this is adopted because it was exactly found.
					shellenv.getOut().println(formatter.format(vecCommandMatch.elementAt(0)));
					return vecCommandMatch.elementAt(0);
				default:
					// It was very much found.
					showVectorListWithNumberAndString(shellenv,vecCommandMatch,formatter);
					shellenv.getOut().print("select number: ");
					return selectFromList(shellenv,vecCommandMatch,formatter,shellenv.getNextLine());
			}
		}
		return null;
	}

	/**
	 * The function which does a number or a character choice from the list
	 */
	public static final Object selectFromList(MdShellEnv shellenv,Vector vecCommandList,MdShellDisplayFormatterInterface formatter,String strRead)
	{
		if(strRead==null
		|| strRead.length()<=0)
		{
			return null;
		}

		// Only token of the temporary beginning is taken out by making it do and hitting it, 
		// and it disposes of it.
		strRead=MdShellUtilString.readFirstCommandToken(strRead);

		try{
			// It is complemented if it can be complemented.
			Object objFind=fullfillByList(shellenv,vecCommandList,formatter,strRead);
			if(objFind!=null)
			{
				return objFind;
			}
		}catch(IOException ex){
			shellenv.getOut().println(ex.toString());
			ex.printStackTrace();
		}

		int iSelectNumber=MdShellUtilString.parseInt(strRead)-1;
		if(iSelectNumber<0
		|| iSelectNumber>=vecCommandList.size())
		{
			//shellenv.getOut().println("Number designation is ineffective. ["+(iSelectNumber+1)+"]");
			return null;
		}

		String strCommand=formatter.format(vecCommandList.elementAt(iSelectNumber));
		shellenv.getOut().println("get ["+strCommand+"]");
		return vecCommandList.elementAt(iSelectNumber);
	}

	/**
	 * The list stored in Vector is indicated together with the choice number.
	 */
	public static final void showVectorListWithNumberAndString(MdShellEnv shellenv,Vector vecCommandMatch,MdShellDisplayFormatterInterface formatter)
	{
		for(int iLoop=0;iLoop<vecCommandMatch.size();iLoop++)
		{
			shellenv.getOut().println(" "+(iLoop+1)+"  "+formatter.format(vecCommandMatch.elementAt(iLoop)));
		}
	}
}


