/*
 * Decompiled with CFR 0.152.
 */
package kandata.client.http;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import kandata.KandataServerException;
import kandata.client.KandataClient;
import kandata.client.KandataClientException;
import kandata.client.KandataConnector;
import kandata.client.http.HttpClassLoader;
import kandata.client.http.HttpObjectInputStream;

public class HttpConnector
implements KandataConnector {
    static final boolean TRACE_ENABLE = true;
    private URL url = null;
    private HttpURLConnection conn = null;
    HttpClassLoader httpClassLoader = new HttpClassLoader(this);
    private String id = null;

    static final void TRACE(String message) {
        System.out.println(message);
    }

    private HttpConnector() {
    }

    public void connect(URL url) throws KandataClientException, KandataServerException {
        HttpConnector.TRACE("HttpConnector.connect(" + url + ")");
        this.url = url;
        try {
            this.conn = (HttpURLConnection)url.openConnection();
            this.conn.setDoOutput(true);
        }
        catch (IOException ex) {
            throw new KandataClientException("connect failed.", ex);
        }
        this.id = (String)this.invoke("@connect", null);
    }

    public void disconnect() throws KandataClientException, KandataServerException {
        HttpConnector.TRACE("HttpConnector.disconnect()");
        this.invoke("@disconnect", null);
        if (this.conn != null) {
            this.conn.disconnect();
            this.conn = null;
        }
    }

    public Object invoke(String command, Object[] args) throws KandataClientException, KandataServerException {
        HttpConnector.TRACE("HttpConnector.invoke(" + command + ", args);");
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                HttpConnector.TRACE("\targs[" + i + "]=" + args[i]);
                ++i;
            }
        }
        try {
            this.conn = (HttpURLConnection)this.url.openConnection();
            this.conn.setDoOutput(true);
            ObjectOutputStream out = new ObjectOutputStream(this.conn.getOutputStream());
            out.writeObject(this.id);
            out.writeObject(command);
            out.writeInt(args != null ? args.length : 0);
            if (args != null) {
                int i = 0;
                while (i < args.length) {
                    out.writeObject(args[i]);
                    ++i;
                }
            }
            out.close();
            this.conn.connect();
            HttpObjectInputStream in = new HttpObjectInputStream(this.conn.getInputStream(), this.httpClassLoader);
            Object ret = in.readObject();
            KandataServerException ex = (KandataServerException)in.readObject();
            in.close();
            HttpConnector.TRACE("\treturn " + ret);
            this.conn.disconnect();
            if (ex != null) {
                throw ex;
            }
            return ret;
        }
        catch (IOException ex) {
            throw new KandataClientException("invoke failed.", ex);
        }
        catch (ClassNotFoundException ex) {
            throw new KandataClientException("invoke failed.", ex);
        }
    }

    public byte[] getResource(String path) throws KandataClientException, KandataServerException {
        HttpConnector.TRACE("HttpConnector.getResource(" + this.url + ")");
        return (byte[])this.invoke("@getResource", new Object[]{path});
    }

    public byte[] getClass(String classname) throws KandataClientException, KandataServerException {
        HttpConnector.TRACE("HttpConnector.getClass(" + this.url + ")");
        return (byte[])this.invoke("@getClass", new Object[]{classname});
    }

    public String getEntryClassName() throws KandataClientException, KandataServerException {
        return (String)this.invoke("@getEntryClassName", null);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("usage: java kandata.client.http.HttpConnector <url> [<client-type> [<version>]]");
            System.exit(-1);
        }
        String url = args[0];
        String clientType = args.length > 1 ? args[1] : null;
        String version = args.length > 2 ? args[2] : null;
        HttpConnector connector = new HttpConnector();
        connector.connect(new URL(args[0]));
        String entry_classname = connector.getEntryClassName();
        Class<?> entry_class = Class.forName(entry_classname, true, connector.httpClassLoader);
        KandataClient client = (KandataClient)entry_class.newInstance();
        client.init(connector);
    }
}

