/*
 * Decompiled with CFR 0.152.
 */
package kandata;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;
import kandata.KandataServerException;
import kandata.client.KandataClient;
import kandata.client.KandataClientException;
import kandata.client.KandataConnector;
import kandata.server.KandataAction;
import kandata.server.KandataClientContext;
import kandata.server.KandataEvent;
import kandata.server.KandataServer;
import kandata.server.KandataServerContext;

public class DebugConnector
implements KandataConnector,
KandataServerContext {
    static final boolean TRACE_ENABLE = true;
    static KandataServer server = null;
    private static final String CONFIG_FILENAME = "kandata.properties";
    protected KandataClientContext clientContext = new KandataClientContext(System.currentTimeMillis());
    protected String serverClassName;
    protected String serverResourcePath;
    protected String clientEntryClassName;
    protected String clientClassPath;
    protected String clientResourcePath;
    private HashMap actionMap = new HashMap();

    static final void TRACE(String message) {
        System.out.println(message);
    }

    static final void TRACE(Throwable ex) {
        ex.printStackTrace(System.out);
    }

    public void connect() throws KandataClientException {
        DebugConnector.TRACE("DebugConnector.connect()");
        this.loadConfiguration(CONFIG_FILENAME);
        server.init(this);
        server.connected(this.clientContext);
    }

    public void disconnect() throws KandataClientException {
        DebugConnector.TRACE("DebugConnector.disconnect()");
        server.disconnected(this.clientContext);
        server.exit();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getResource(String path) throws KandataClientException {
        DebugConnector.TRACE("DebugConnector.getResource(" + path + ") " + this.clientResourcePath + path);
        InputStream in = null;
        try {
            try {
                File file = new File(this.clientResourcePath + path);
                in = new FileInputStream(file);
                byte[] buf = new byte[(int)file.length()];
                in.read(buf);
                byte[] byArray = buf;
                Object var7_7 = null;
                if (in == null) return byArray;
                try {
                    in.close();
                    return byArray;
                }
                catch (IOException e) {
                    // empty catch block
                }
                return byArray;
            }
            catch (IOException e) {
                throw new KandataClientException("\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f :" + this.clientResourcePath + path, e);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (in == null) throw throwable;
            try {}
            catch (IOException e) {
                throw throwable;
            }
            in.close();
            throw throwable;
        }
    }

    public String getResourcePath() {
        return this.serverResourcePath;
    }

    public void putAction(String command, KandataAction action) {
        this.actionMap.put(command, action);
    }

    public Object invoke(String command, Object[] args) throws KandataServerException {
        DebugConnector.TRACE("DebugConnector.invoke(" + command + ")");
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                DebugConnector.TRACE("  args[" + i + "]=" + args[i]);
                ++i;
            }
        }
        Object ret = command.charAt(0) == '@' ? this.invokeSystemCommand(this.clientContext, command, args) : this.invokeCommand(this.clientContext, command, args);
        DebugConnector.TRACE("   ret=" + ret);
        return ret;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object invokeSystemCommand(KandataClientContext context, String command, Object[] args) throws KandataServerException {
        if (command.equals("@getEntryClassName")) {
            return this.clientEntryClassName;
        }
        if (!command.equals("@getResource")) {
            DebugConnector.TRACE("\u672a\u5b9a\u7fa9\u306e\u30b3\u30de\u30f3\u30c9\u3067\u3059 command=" + command);
            throw new KandataServerException("no such command:" + command, null);
        }
        path = this.clientResourcePath + (String)args[0];
        DebugConnector.TRACE("path=" + path);
        in = null;
        try {
            try {
                file = new File(path);
                buf = new byte[(int)file.length()];
                in = new FileInputStream(file);
                in.read(buf, 0, (int)file.length());
                var8_10 = buf;
                var10_11 = null;
                if (in == null) return var8_10;
            }
            catch (IOException e) {
                DebugConnector.TRACE(e);
                var7_9 = null;
                var10_12 = null;
                if (in == null) return var7_9;
                try {
                    in.close();
                    return var7_9;
                }
                catch (IOException e) {
                    // empty catch block
                }
                return var7_9;
            }
        }
        catch (Throwable var9_17) {
            var10_13 = null;
            if (in == null) throw var9_17;
            ** try [egrp 2[TRYBLOCK] [2 : 165->173)] { 
lbl38:
            // 1 sources

            in.close();
            throw var9_17;
lbl40:
            // 1 sources

            catch (IOException e) {
                // empty catch block
            }
            throw var9_17;
        }
        ** try [egrp 2[TRYBLOCK] [2 : 165->173)] { 
lbl45:
        // 1 sources

        in.close();
        return var8_10;
lbl47:
        // 1 sources

        catch (IOException e) {
            // empty catch block
        }
        return var8_10;
    }

    protected Object invokeCommand(KandataClientContext context, String command, Object[] args) throws KandataServerException {
        KandataEvent event = new KandataEvent(context, command, args);
        KandataAction action = (KandataAction)this.actionMap.get(command);
        if (action == null) {
            throw new KandataServerException("no such command:" + command, null);
        }
        Object result = action.execute(event);
        return result;
    }

    public String getEntryClassName() throws KandataClientException, KandataServerException {
        return (String)this.invoke("@getEntryClassName", null);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void loadConfiguration(String fname) {
        FileInputStream in = null;
        in = new FileInputStream(fname);
        Properties prop = new Properties();
        prop.load(in);
        String appname = prop.getProperty("application.name");
        this.serverClassName = prop.getProperty("application.serverclassname");
        this.serverResourcePath = prop.getProperty("application.serverresourcepath");
        this.clientEntryClassName = prop.getProperty("application.cliententryclassname");
        this.clientClassPath = prop.getProperty("application.clientclasspath");
        this.clientResourcePath = prop.getProperty("application.clientresourcepath");
        in.close();
        DebugConnector.TRACE("application.name=" + appname);
        DebugConnector.TRACE("application.serverclassname=" + this.serverClassName);
        DebugConnector.TRACE("application.serverresourcepath=" + this.serverResourcePath);
        DebugConnector.TRACE("application.cliententryclassname=" + this.clientEntryClassName);
        DebugConnector.TRACE("application.clientclasspath=" + this.clientClassPath);
        DebugConnector.TRACE("application.clientresourcepath=" + this.clientResourcePath);
        Object var6_6 = null;
        if (in == null) return;
        try {
            in.close();
            return;
        }
        catch (IOException e2) {}
        return;
        {
            catch (IOException e) {
                DebugConnector.TRACE(e);
                Object var6_7 = null;
                if (in == null) return;
                try {
                    in.close();
                    return;
                }
                catch (IOException e2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("usage: java kandata.DebugConnector <server-classname> [<client-type> [<version>]]");
            System.exit(-1);
        }
        String classname = args[0];
        String clientType = args.length > 1 ? args[1] : null;
        String version = args.length > 2 ? args[2] : null;
        Class<?> serverClass = Class.forName(classname);
        server = (KandataServer)serverClass.newInstance();
        DebugConnector connector = new DebugConnector();
        connector.connect();
        String entry_classname = connector.getEntryClassName();
        Class<?> entry_class = Class.forName(entry_classname);
        KandataClient client = (KandataClient)entry_class.newInstance();
        client.init(connector);
    }
}

