/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.nifty.iga.midori.shell.util.dir;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.Vector;
import jp.ne.nifty.iga.midori.shell.dir.MdShellDirNodeInterface;
import jp.ne.nifty.iga.midori.shell.dir.MdShellFileSizeComparator;
import jp.ne.nifty.iga.midori.shell.dir.MdShellFileTimestampComparator;
import jp.ne.nifty.iga.midori.shell.eng.MdShellEnv;
import jp.ne.nifty.iga.midori.shell.io.MdShellDirLongListFormatter;
import jp.ne.nifty.iga.midori.shell.util.MdShellUtilString;

public class Dir {
    private boolean isRecursive = false;
    private boolean isSortByTimeStamp = false;
    private boolean isSortByFileSize = false;
    static /* synthetic */ Class class$jp$ne$nifty$iga$midori$shell$util$dir$Dir;

    public int process(MdShellEnv shellenv, String[] strArgs) {
        Vector vecList = this.buildData(shellenv, strArgs);
        if (vecList == null) {
            return -2;
        }
        this.showData(shellenv, vecList);
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public Vector buildData(MdShellEnv shellenv, String[] strArgs) {
        int c;
        LongOpt[] longOptions = new LongOpt[]{new LongOpt("help", 0, null, 63), new LongOpt("recursive", 0, null, 82), new LongOpt("version", 0, null, 86)};
        Getopt g = new Getopt("dir", strArgs, "ailrRStV?", longOptions);
        while ((c = g.getopt()) != -1) {
            void var5_5;
            switch (var5_5) {
                case 82: {
                    this.isRecursive = true;
                    break;
                }
                case 83: {
                    this.isSortByFileSize = true;
                    break;
                }
                case 116: {
                    this.isSortByTimeStamp = true;
                    break;
                }
                case 86: {
                    break;
                }
                case 63: {
                    BufferedReader reader = new BufferedReader(new InputStreamReader((class$jp$ne$nifty$iga$midori$shell$util$dir$Dir == null ? (class$jp$ne$nifty$iga$midori$shell$util$dir$Dir = Dir.class$("jp.ne.nifty.iga.midori.shell.util.dir.Dir")) : class$jp$ne$nifty$iga$midori$shell$util$dir$Dir).getResourceAsStream("DirUsage.txt")));
                    try {
                        String strLine = null;
                        while ((strLine = reader.readLine()) != null) {
                            shellenv.getOut().println(strLine);
                        }
                        reader.close();
                    }
                    catch (IOException ex) {
                        System.out.println(ex.toString());
                        ex.printStackTrace();
                    }
                    return null;
                }
            }
        }
        String strFileRegExp = "";
        int optind = g.getOptind();
        if (optind < strArgs.length) {
            strFileRegExp = MdShellUtilString.eraseChar(strArgs[g.getOptind()], '*');
        }
        Vector vecList = null;
        vecList = this.isRecursive ? shellenv.getCurrentDirectory().listDirectoryWithSubDirectory(shellenv, 1, strFileRegExp) : shellenv.getCurrentDirectory().listDirectory(shellenv, 1, strFileRegExp);
        if (this.isSortByTimeStamp) {
            Collections.sort(vecList, new MdShellFileTimestampComparator());
        }
        if (this.isSortByFileSize) {
            Collections.sort(vecList, new MdShellFileSizeComparator());
        }
        return vecList;
    }

    public void showData(MdShellEnv shellenv, Vector vecList) {
        int iBaseLength = shellenv.getCurrentDirectory().getName().length();
        MdShellDirLongListFormatter formatter = new MdShellDirLongListFormatter();
        int index = 0;
        while (index < vecList.size()) {
            MdShellDirNodeInterface path = (MdShellDirNodeInterface)vecList.elementAt(index);
            shellenv.getOut().println(formatter.format(path));
            ++index;
        }
        NumberFormat numberfmt = NumberFormat.getNumberInstance();
        shellenv.getOut().println("     total: " + numberfmt.format(formatter.iTotalDirectoryCount) + " directories: " + numberfmt.format(formatter.iTotalFileCount) + " files: total " + numberfmt.format(formatter.iTotalFileLength) + " bytes");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

