/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.nifty.iga.midori.shell.eng;

import gnu.regexp.RE;
import gnu.regexp.REException;
import gnu.regexp.RESyntax;
import java.io.IOException;
import java.text.Collator;
import java.util.Vector;
import jp.ne.nifty.iga.midori.shell.eng.MdShellEnv;
import jp.ne.nifty.iga.midori.shell.io.MdShellDisplayFormatterInterface;
import jp.ne.nifty.iga.midori.shell.util.MdShellUtilString;

public class MdShellListSelection {
    public static final Object fullfillByList(MdShellEnv shellenv, Vector vecCommandList, MdShellDisplayFormatterInterface formatter, String strRead) throws IOException {
        if (strRead == null || strRead.length() <= 0) {
            return null;
        }
        Collator collator = shellenv.getCollatorInstance();
        Vector vecCommandMatch = new Vector(128);
        int iStrReadLength = strRead.length();
        int iLoop = 0;
        while (iLoop < vecCommandList.size()) {
            String strComp = formatter.format(vecCommandList.elementAt(iLoop));
            if (strComp != null) {
                if (collator.equals(strRead, strComp)) {
                    return vecCommandList.elementAt(iLoop);
                }
                if (strComp.charAt(0) != '$') {
                    try {
                        RE rex = new RE(strRead, 2, RESyntax.RE_SYNTAX_GREP);
                        if (rex.getMatch(strComp) != null || rex.isMatch(strComp)) {
                            vecCommandMatch.addElement(vecCommandList.elementAt(iLoop));
                        }
                    }
                    catch (REException ex) {
                        System.out.println(ex.toString());
                    }
                }
            }
            ++iLoop;
        }
        switch (vecCommandMatch.size()) {
            case 0: {
                break;
            }
            case 1: {
                shellenv.getOut().println(formatter.format(vecCommandMatch.elementAt(0)));
                return vecCommandMatch.elementAt(0);
            }
            default: {
                MdShellListSelection.showVectorListWithNumberAndString(shellenv, vecCommandMatch, formatter);
                shellenv.getOut().print("select number: ");
                return MdShellListSelection.selectFromList(shellenv, vecCommandMatch, formatter, shellenv.getNextLine());
            }
        }
        return null;
    }

    public static final Object selectFromList(MdShellEnv shellenv, Vector vecCommandList, MdShellDisplayFormatterInterface formatter, String strRead) {
        if (strRead == null || strRead.length() <= 0) {
            return null;
        }
        strRead = MdShellUtilString.readFirstCommandToken(strRead);
        try {
            Object objFind = MdShellListSelection.fullfillByList(shellenv, vecCommandList, formatter, strRead);
            if (objFind != null) {
                return objFind;
            }
        }
        catch (IOException ex) {
            shellenv.getOut().println(ex.toString());
            ex.printStackTrace();
        }
        int iSelectNumber = MdShellUtilString.parseInt(strRead) - 1;
        if (iSelectNumber < 0 || iSelectNumber >= vecCommandList.size()) {
            return null;
        }
        String strCommand = formatter.format(vecCommandList.elementAt(iSelectNumber));
        shellenv.getOut().println("get [" + strCommand + "]");
        return vecCommandList.elementAt(iSelectNumber);
    }

    public static final void showVectorListWithNumberAndString(MdShellEnv shellenv, Vector vecCommandMatch, MdShellDisplayFormatterInterface formatter) {
        int iLoop = 0;
        while (iLoop < vecCommandMatch.size()) {
            shellenv.getOut().println(" " + (iLoop + 1) + "  " + formatter.format(vecCommandMatch.elementAt(iLoop)));
            ++iLoop;
        }
    }
}

