/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.nifty.iga.midori.shell.eng;

import java.io.IOException;
import java.io.InputStream;
import java.text.Collator;
import java.util.Vector;
import jp.ne.nifty.iga.midori.shell.MdShellVersion;
import jp.ne.nifty.iga.midori.shell.eng.MdShellCancelException;
import jp.ne.nifty.iga.midori.shell.eng.MdShellEnv;
import jp.ne.nifty.iga.midori.shell.eng.MdShellException;
import jp.ne.nifty.iga.midori.shell.eng.MdShellListSelection;
import jp.ne.nifty.iga.midori.shell.io.MdShellDefaultStringFormatter;
import jp.ne.nifty.iga.midori.shell.io.MdShellUtilExec;
import jp.ne.nifty.iga.midori.shell.util.MdShellUtilString;

public class MdShellEngine {
    private MdShellEnv shellenv;
    private Vector vecCommandHistory = new Vector(1024);

    public MdShellEngine(MdShellEnv shellenv) {
        this.shellenv = shellenv;
        this.init();
    }

    public void init() {
        this.shellenv.init();
    }

    public void close() {
    }

    public int process() {
        try {
            this.shellenv.getOut().println("JMichelle (Java Midori Shell) " + MdShellVersion.getVersion() + ", " + "Copyright(C) 2000 Midori IGA");
            while (true) {
                Thread.yield();
                this.shellenv.getOut().print(this.shellenv.getCurrentDirectory().getName() + "> ");
                this.shellenv.clearLine();
                String strRead = this.shellenv.getNextLine();
                if (strRead == null) continue;
                try {
                    if (!this.processCommand(this.shellenv.getIn(), strRead)) continue;
                }
                catch (MdShellCancelException ex) {
                    continue;
                }
                catch (MdShellException mdShellException) {
                    continue;
                }
                break;
            }
        }
        catch (IOException ex) {
            this.shellenv.getOut().println(ex.toString());
            ex.printStackTrace();
        }
        return 0;
    }

    public boolean processCommand(InputStream inStream, String strReadLine) throws MdShellException, IOException {
        Collator collator = this.shellenv.getCollatorInstance();
        String strCommand = MdShellUtilString.readFirstCommandToken(strReadLine);
        if (strCommand == null) {
            return false;
        }
        if (collator.equals(strCommand, "!!")) {
            if (this.vecCommandHistory.size() <= 0) {
                return false;
            }
            String strHistoryCommand = (String)this.vecCommandHistory.elementAt(this.vecCommandHistory.size() - 1);
            return this.processCommand(inStream, strHistoryCommand);
        }
        if (strCommand.length() >= 2 && strCommand.charAt(0) == '!') {
            MdShellDefaultStringFormatter formatter = new MdShellDefaultStringFormatter();
            String strHistoryCommand = formatter.format(MdShellListSelection.selectFromList(this.shellenv, this.vecCommandHistory, formatter, strCommand.substring(1)));
            if (strHistoryCommand == null) {
                throw new MdShellCancelException();
            }
            return this.processCommand(inStream, strHistoryCommand);
        }
        MdShellDefaultStringFormatter formatter = new MdShellDefaultStringFormatter();
        Object objFilledCommand = MdShellListSelection.fullfillByList(this.shellenv, this.shellenv.getCommandList().getImplementedCommandList(), formatter, "^" + strCommand);
        if (objFilledCommand != null) {
            strCommand = formatter.format(objFilledCommand);
        }
        if (collator.equals(strCommand, "exit") || collator.equals(strCommand, "quit")) {
            return true;
        }
        if (collator.equals(strCommand, "exec")) {
            this.shellenv.getOut().print("input command: ");
            String strSubCommand = this.shellenv.getNextLine();
            if (strSubCommand == null) {
                throw new MdShellCancelException();
            }
            if (collator.equals(strSubCommand, "")) {
                this.showCommandHistory();
                this.shellenv.getOut().print("select command: ");
                MdShellDefaultStringFormatter formatter2 = new MdShellDefaultStringFormatter();
                strSubCommand = formatter2.format(MdShellListSelection.selectFromList(this.shellenv, this.vecCommandHistory, formatter2, this.shellenv.getNextLine()));
                if (strSubCommand == null) {
                    throw new MdShellCancelException();
                }
                this.shellenv.getOut().println("get from history [" + strSubCommand + "]");
            } else {
                strSubCommand = this.shellenv.getOriginalReadLine();
            }
            MdShellUtilExec.exec(this.shellenv, strSubCommand);
        } else if (collator.equals(strCommand, "history") || collator.equals(strCommand, "!")) {
            this.showCommandHistory();
        } else if (collator.equals(strCommand, "menu")) {
            Vector vecMenu = this.shellenv.getCommandList().getFilteredCommandListForDisplay();
            Vector vecMenuCommand = this.shellenv.getCommandList().getFilteredCommandList();
            MdShellListSelection.showVectorListWithNumberAndString(this.shellenv, vecMenu, new MdShellDefaultStringFormatter());
            this.shellenv.getOut().print("select menu: ");
            MdShellDefaultStringFormatter formatter3 = new MdShellDefaultStringFormatter();
            String strMenu = formatter3.format(MdShellListSelection.selectFromList(this.shellenv, vecMenuCommand, formatter3, this.shellenv.getNextLine()));
            if (strMenu != null) {
                return this.processCommand(inStream, strMenu);
            }
        } else if (!this.shellenv.getCommandList().processCommand(this.shellenv, strCommand)) {
            if (collator.equals(strCommand, "")) {
                return false;
            }
            MdShellUtilExec.exec(this.shellenv, this.shellenv.getOriginalReadLine());
        }
        this.vecCommandHistory.addElement(strReadLine);
        return false;
    }

    public void showCommandHistory() {
        MdShellListSelection.showVectorListWithNumberAndString(this.shellenv, this.vecCommandHistory, new MdShellDefaultStringFormatter());
    }
}

