/*
 * Decompiled with CFR 0.152.
 */
package gnu.regexp;

import gnu.regexp.CharIndexed;
import gnu.regexp.CharIndexedCharArray;
import gnu.regexp.CharIndexedInputStream;
import gnu.regexp.CharIndexedString;
import gnu.regexp.CharIndexedStringBuffer;
import gnu.regexp.CharUnit;
import gnu.regexp.IntPair;
import gnu.regexp.REException;
import gnu.regexp.REMatch;
import gnu.regexp.REMatchEnumeration;
import gnu.regexp.RESyntax;
import gnu.regexp.REToken;
import gnu.regexp.RETokenAny;
import gnu.regexp.RETokenBackRef;
import gnu.regexp.RETokenChar;
import gnu.regexp.RETokenEnd;
import gnu.regexp.RETokenOneOf;
import gnu.regexp.RETokenPOSIX;
import gnu.regexp.RETokenRange;
import gnu.regexp.RETokenRepeated;
import gnu.regexp.RETokenStart;
import java.io.InputStream;
import java.util.Vector;

public class RE
extends REToken {
    private static final String s_version = "1.0.8";
    private REToken firstToken;
    private REToken lastToken;
    private int m_numSubs;
    public static final int REG_ICASE = 2;
    public static final int REG_DOT_NEWLINE = 4;
    public static final int REG_MULTILINE = 8;
    public static final int REG_NOTBOL = 16;
    public static final int REG_NOTEOL = 32;
    public static final int REG_ANCHORINDEX = 64;

    public static final String version() {
        return s_version;
    }

    public RE(Object pattern) throws REException {
        this(pattern, 0, RESyntax.RE_SYNTAX_PERL5, 0, 0);
    }

    public RE(Object pattern, int cflags) throws REException {
        this(pattern, cflags, RESyntax.RE_SYNTAX_PERL5, 0, 0);
    }

    public RE(Object pattern, int cflags, RESyntax syntax) throws REException {
        this(pattern, cflags, syntax, 0, 0);
    }

    private RE(REToken f_first, REToken f_last, int f_subs, int f_subIndex) {
        super(f_subIndex);
        this.firstToken = f_first;
        this.lastToken = f_last;
        this.m_numSubs = f_subs;
    }

    /*
     * Unable to fully structure code
     */
    private RE(Object patternObj, int cflags, RESyntax syntax, int myIndex, int nextSub) throws REException {
        super(myIndex);
        if (patternObj instanceof String) {
            pattern = ((String)patternObj).toCharArray();
        } else if (patternObj instanceof char[]) {
            pattern = (char[])patternObj;
        } else if (patternObj instanceof StringBuffer) {
            pattern = new char[((StringBuffer)patternObj).length()];
            ((StringBuffer)patternObj).getChars(0, pattern.length, pattern, 0);
        } else {
            throw new IllegalArgumentException("Invalid class for pattern");
        }
        pLength = pattern.length;
        this.m_numSubs = 0;
        branches = null;
        this.lastToken = null;
        this.firstToken = null;
        insens = (cflags & 2) > 0;
        index = 0;
        unit = new CharUnit();
        minMax = new IntPair();
        currentToken = null;
        while (index < pLength) {
            block76: {
                index = RE.getCharUnit(pattern, index, unit);
                if ((unit.ch == '|' && syntax.get(14) ^ unit.bk || syntax.get(10) && unit.ch == '\n' && !unit.bk) && !syntax.get(9)) {
                    if (branches == null) {
                        branches = new Vector<RE>();
                    }
                    this.addToken(currentToken);
                    branches.addElement(new RE(this.firstToken, this.lastToken, this.m_numSubs, this.m_subIndex));
                    currentToken = null;
                    this.lastToken = null;
                    this.firstToken = null;
                    continue;
                }
                if (unit.ch == '{' && syntax.get(8) && syntax.get(11) ^ unit.bk) {
                    if (currentToken == null) {
                        throw new REException("{ without preceding token", 3, index);
                    }
                    index = this.getMinMax(pattern, index, minMax, syntax);
                    if (currentToken.getMinimumLength() == 0 && minMax.second == 0x7FFFFFFF) {
                        throw new REException("repeated argument may be empty", 1, index);
                    }
                    currentToken = RE.setRepeated(currentToken, minMax.first, minMax.second, index);
                    continue;
                }
                if (unit.ch != '[' || unit.bk) break block76;
                options = new Vector<REToken>();
                negative = false;
                lastChar = '\u0000';
                if (index == pLength) {
                    throw new REException("unmatched [", 4, index);
                }
                ch = pattern[index];
                if (ch == '^') {
                    negative = true;
                    if (++index == pLength) {
                        throw new REException("no end of list", 4, index);
                    }
                    ch = pattern[index];
                }
                if (ch != ']') ** GOTO lbl111
                lastChar = ch;
                if (++index != pLength) ** GOTO lbl111
                throw new REException("no end of list", 4, index);
lbl-1000:
                // 1 sources

                {
                    if (ch == '-' && lastChar != '\u0000') {
                        if (index == pLength) {
                            throw new REException("no end of list", 4, index);
                        }
                        ch = pattern[index];
                        if (ch == ']') {
                            options.addElement(new RETokenChar(this.m_subIndex, lastChar, insens));
                            lastChar = '-';
                        } else {
                            options.addElement(new RETokenRange(this.m_subIndex, lastChar, ch, insens));
                            lastChar = '\u0000';
                            ++index;
                        }
                    } else if (ch == '\\' && syntax.get(0)) {
                        if (index == pLength) {
                            throw new REException("no end of list", 4, index);
                        }
                        posixID = -1;
                        negate = false;
                        if (syntax.get(24)) {
                            switch (pattern[index]) {
                                case 'D': {
                                    negate = true;
                                }
                                case 'd': {
                                    posixID = 4;
                                    break;
                                }
                                case 'S': {
                                    negate = true;
                                }
                                case 's': {
                                    posixID = 9;
                                    break;
                                }
                                case 'W': {
                                    negate = true;
                                }
                                case 'w': {
                                    posixID = 0;
                                }
                            }
                        }
                        if (lastChar != '\u0000') {
                            options.addElement(new RETokenChar(this.m_subIndex, lastChar, insens));
                        }
                        if (posixID != -1) {
                            options.addElement(new RETokenPOSIX(this.m_subIndex, posixID, insens, negate));
                        } else {
                            lastChar = pattern[index];
                        }
                        ++index;
                    } else if (ch == '[' && syntax.get(2) && pattern[index] == ':') {
                        posixSet = new StringBuffer();
                        index = RE.getPosixSet(pattern, index + 1, posixSet);
                        posixId = RETokenPOSIX.intValue(posixSet.toString());
                        if (posixId != -1) {
                            options.addElement(new RETokenPOSIX(this.m_subIndex, posixId, insens, false));
                        }
                    } else {
                        if (lastChar != '\u0000') {
                            options.addElement(new RETokenChar(this.m_subIndex, lastChar, insens));
                        }
                        lastChar = ch;
                    }
                    if (index != pLength) continue;
                    throw new REException("no end of list", 4, index);
lbl111:
                    // 3 sources

                    ** while ((ch = pattern[index++]) != ']')
                }
lbl112:
                // 1 sources

                if (lastChar != '\u0000') {
                    options.addElement(new RETokenChar(this.m_subIndex, lastChar, insens));
                }
                this.addToken(currentToken);
                options.trimToSize();
                currentToken = new RETokenOneOf(this.m_subIndex, options, negative);
                continue;
            }
            if (unit.ch == '(' && syntax.get(12) ^ unit.bk) {
                pure = false;
                comment = false;
                if (index + 1 < pLength && pattern[index] == '?') {
                    switch (pattern[index + 1]) {
                        case ':': {
                            if (!syntax.get(20)) break;
                            pure = true;
                            index += 2;
                            break;
                        }
                        case '#': {
                            if (!syntax.get(23)) break;
                            comment = true;
                        }
                    }
                }
                endIndex = index;
                nextIndex = index;
                nested = 0;
                while (!((nextIndex = RE.getCharUnit(pattern, endIndex, unit)) <= 0 || nested == 0 && unit.ch == ')' && syntax.get(12) ^ unit.bk)) {
                    endIndex = nextIndex;
                    if (endIndex >= pLength) {
                        throw new REException("no end of subexpression", 8, index - 1);
                    }
                    if (unit.ch == '(' && syntax.get(12) ^ unit.bk) {
                        ++nested;
                        continue;
                    }
                    if (unit.ch != ')' || !(syntax.get(12) ^ unit.bk)) continue;
                    --nested;
                }
                if (comment) {
                    index = nextIndex;
                    continue;
                }
                this.addToken(currentToken);
                if (!pure) {
                    ++nextSub;
                    ++this.m_numSubs;
                }
                useIndex = pure != false ? 0 : nextSub;
                currentToken = new RE(String.valueOf(pattern, index, endIndex - index).toCharArray(), cflags, syntax, useIndex, nextSub);
                nextSub += ((RE)currentToken).getNumSubs();
                this.m_numSubs += ((RE)currentToken).getNumSubs();
                index = nextIndex;
                continue;
            }
            if (!syntax.get(16) && unit.ch == ')' && syntax.get(12) ^ unit.bk) {
                throw new REException("unmatched right paren", 7, index);
            }
            if (unit.ch == '^' && !unit.bk) {
                this.addToken(currentToken);
                currentToken = null;
                this.addToken(new RETokenStart(this.m_subIndex, (cflags & 8) > 0));
                continue;
            }
            if (unit.ch == '$' && !unit.bk) {
                this.addToken(currentToken);
                currentToken = null;
                this.addToken(new RETokenEnd(this.m_subIndex, (cflags & 8) > 0));
                continue;
            }
            if (unit.ch == '.' && !unit.bk) {
                this.addToken(currentToken);
                currentToken = new RETokenAny(this.m_subIndex, syntax.get(6) != false || (cflags & 4) > 0, syntax.get(7));
                continue;
            }
            if (unit.ch == '*' && !unit.bk) {
                if (currentToken == null || currentToken.getMinimumLength() == 0) {
                    throw new REException("repeated argument may be empty", 1, index);
                }
                currentToken = RE.setRepeated(currentToken, 0, 0x7FFFFFFF, index);
                continue;
            }
            if (unit.ch == '+' && !syntax.get(9) && syntax.get(1) == false ^ unit.bk) {
                if (currentToken == null || currentToken.getMinimumLength() == 0) {
                    throw new REException("repeated argument may be empty", 1, index);
                }
                currentToken = RE.setRepeated(currentToken, 1, 0x7FFFFFFF, index);
                continue;
            }
            if (unit.ch == '?' && !syntax.get(9) && syntax.get(1) == false ^ unit.bk) {
                if (currentToken == null) {
                    throw new REException("? without preceding token", 1, index);
                }
                if (currentToken instanceof RETokenRepeated && syntax.get(18)) {
                    ((RETokenRepeated)currentToken).makeStingy();
                    continue;
                }
                currentToken = RE.setRepeated(currentToken, 0, 1, index);
                continue;
            }
            if (unit.bk && Character.isDigit(unit.ch) && !syntax.get(13)) {
                this.addToken(currentToken);
                currentToken = new RETokenBackRef(this.m_subIndex, Character.digit(unit.ch, 10), insens);
                continue;
            }
            if (unit.bk && unit.ch == 'A' && syntax.get(22)) {
                this.addToken(currentToken);
                currentToken = new RETokenStart(this.m_subIndex, false);
                continue;
            }
            if (unit.bk && unit.ch == 'd' && syntax.get(19)) {
                this.addToken(currentToken);
                currentToken = new RETokenPOSIX(this.m_subIndex, 4, insens, false);
                continue;
            }
            if (unit.bk && unit.ch == 'D' && syntax.get(19)) {
                this.addToken(currentToken);
                currentToken = new RETokenPOSIX(this.m_subIndex, 4, insens, true);
                continue;
            }
            if (unit.bk && unit.ch == 'n') {
                this.addToken(currentToken);
                currentToken = new RETokenChar(this.m_subIndex, '\n', false);
                continue;
            }
            if (unit.bk && unit.ch == 'r') {
                this.addToken(currentToken);
                currentToken = new RETokenChar(this.m_subIndex, '\r', false);
                continue;
            }
            if (unit.bk && unit.ch == 's' && syntax.get(19)) {
                this.addToken(currentToken);
                currentToken = new RETokenPOSIX(this.m_subIndex, 9, insens, false);
                continue;
            }
            if (unit.bk && unit.ch == 'S' && syntax.get(19)) {
                this.addToken(currentToken);
                currentToken = new RETokenPOSIX(this.m_subIndex, 9, insens, true);
                continue;
            }
            if (unit.bk && unit.ch == 't') {
                this.addToken(currentToken);
                currentToken = new RETokenChar(this.m_subIndex, '\t', false);
                continue;
            }
            if (unit.bk && unit.ch == 'w' && syntax.get(19)) {
                this.addToken(currentToken);
                currentToken = new RETokenPOSIX(this.m_subIndex, 0, insens, false);
                continue;
            }
            if (unit.bk && unit.ch == 'W' && syntax.get(19)) {
                this.addToken(currentToken);
                currentToken = new RETokenPOSIX(this.m_subIndex, 0, insens, true);
                continue;
            }
            if (unit.bk && unit.ch == 'Z' && syntax.get(22)) {
                this.addToken(currentToken);
                currentToken = new RETokenEnd(this.m_subIndex, false);
                continue;
            }
            this.addToken(currentToken);
            currentToken = new RETokenChar(this.m_subIndex, unit.ch, insens);
        }
        this.addToken(currentToken);
        if (branches != null) {
            branches.addElement(new RE(this.firstToken, this.lastToken, this.m_numSubs, this.m_subIndex));
            branches.trimToSize();
            this.firstToken = this.lastToken = new RETokenOneOf(this.m_subIndex, branches, false);
        }
    }

    private static int getCharUnit(char[] input, int index, CharUnit unit) throws REException {
        unit.ch = input[index++];
        unit.bk = unit.ch == '\\';
        if (unit.bk) {
            if (index < input.length) {
                unit.ch = input[index++];
            } else {
                throw new REException("\\ at end of pattern.", 10, index);
            }
        }
        return index;
    }

    public boolean isMatch(Object input) {
        return this.isMatch(input, 0, 0);
    }

    public boolean isMatch(Object input, int index) {
        return this.isMatch(input, index, 0);
    }

    public boolean isMatch(Object input, int index, int eflags) {
        return this.isMatchImpl(RE.makeCharIndexed(input, index), index, eflags);
    }

    private boolean isMatchImpl(CharIndexed input, int index, int eflags) {
        if (this.firstToken == null) {
            return input.charAt(0) == '\uffff';
        }
        int[] i = this.firstToken.match(input, 0, eflags, new REMatch(this.m_numSubs, index));
        return i != null && input.charAt(i[0]) == '\uffff';
    }

    public int getNumSubs() {
        return this.m_numSubs;
    }

    void setUncle(REToken f_uncle) {
        this.lastToken.setUncle(f_uncle);
    }

    boolean chain(REToken f_next) {
        super.chain(f_next);
        if (this.lastToken != null) {
            this.lastToken.setUncle(f_next);
        }
        return true;
    }

    public int getMinimumLength() {
        int min = 0;
        REToken t = this.firstToken;
        if (t == null) {
            return 0;
        }
        do {
            min += t.getMinimumLength();
        } while ((t = t.m_next) != null);
        return min;
    }

    public REMatch[] getAllMatches(Object input) {
        return this.getAllMatches(input, 0, 0);
    }

    public REMatch[] getAllMatches(Object input, int index) {
        return this.getAllMatches(input, index, 0);
    }

    public REMatch[] getAllMatches(Object input, int index, int eflags) {
        return this.getAllMatchesImpl(RE.makeCharIndexed(input, index), index, eflags);
    }

    private REMatch[] getAllMatchesImpl(CharIndexed input, int index, int eflags) {
        Vector<REMatch> all = new Vector<REMatch>();
        REMatch m = null;
        while ((m = this.getMatchImpl(input, index, eflags, null)) != null) {
            all.addElement(m);
            index = m.getEndIndex();
            if (m.end[0] == 0) {
                ++index;
                input.move(1);
                continue;
            }
            input.move(m.end[0]);
        }
        Object[] mset = new REMatch[all.size()];
        all.copyInto(mset);
        return mset;
    }

    int[] match(CharIndexed input, int index, int eflags, REMatch mymatch) {
        if (this.firstToken == null) {
            return new int[]{index};
        }
        int oldstart = mymatch.start[this.m_subIndex];
        mymatch.start[this.m_subIndex] = index;
        int[] newIndex = this.firstToken.match(input, index, eflags, mymatch);
        if (newIndex != null) {
            int[] doables = new int[]{};
            int i = 0;
            while (i < newIndex.length) {
                int[] thisResult = this.next(input, newIndex[i], eflags, mymatch);
                if (thisResult != null) {
                    int[] temp = new int[doables.length + thisResult.length];
                    System.arraycopy(doables, 0, temp, 0, doables.length);
                    int j = 0;
                    while (j < thisResult.length) {
                        temp[doables.length + j] = thisResult[j];
                        ++j;
                    }
                    doables = temp;
                }
                ++i;
            }
            return doables.length == 0 ? null : doables;
        }
        mymatch.start[this.m_subIndex] = oldstart;
        return null;
    }

    public REMatch getMatch(Object input) {
        return this.getMatch(input, 0, 0);
    }

    public REMatch getMatch(Object input, int index) {
        return this.getMatch(input, index, 0);
    }

    public REMatch getMatch(Object input, int index, int eflags) {
        return this.getMatch(input, index, eflags, null);
    }

    public REMatch getMatch(Object input, int index, int eflags, StringBuffer buffer) {
        return this.getMatchImpl(RE.makeCharIndexed(input, index), index, eflags, buffer);
    }

    REMatch getMatchImpl(CharIndexed input, int index, int eflags, StringBuffer buffer) {
        if (!input.isValid()) {
            return null;
        }
        REMatch mymatch = new REMatch(this.m_numSubs, index);
        do {
            int[] result;
            if ((result = this.match(input, 0, eflags, mymatch)) != null) {
                mymatch.end[0] = result[0];
                mymatch.finish(input);
                return mymatch;
            }
            mymatch.clear(++index);
            if (buffer == null) continue;
            buffer.append(input.charAt(0));
        } while (input.move(1));
        return null;
    }

    public REMatchEnumeration getMatchEnumeration(Object input) {
        return this.getMatchEnumeration(input, 0, 0);
    }

    public REMatchEnumeration getMatchEnumeration(Object input, int index) {
        return this.getMatchEnumeration(input, index, 0);
    }

    public REMatchEnumeration getMatchEnumeration(Object input, int index, int eflags) {
        return new REMatchEnumeration(this, RE.makeCharIndexed(input, index), index, eflags);
    }

    public String substitute(Object input, String replace) {
        return this.substitute(input, replace, 0, 0);
    }

    public String substitute(Object input, String replace, int index) {
        return this.substitute(input, replace, index, 0);
    }

    public String substitute(Object input, String replace, int index, int eflags) {
        return this.substituteImpl(RE.makeCharIndexed(input, index), replace, index, eflags);
    }

    private String substituteImpl(CharIndexed input, String replace, int index, int eflags) {
        StringBuffer buffer = new StringBuffer();
        REMatch m = this.getMatchImpl(input, index, eflags, buffer);
        if (m == null) {
            return buffer.toString();
        }
        buffer.append(m.substituteInto(replace));
        if (input.move(m.end[0])) {
            do {
                buffer.append(input.charAt(0));
            } while (input.move(1));
        }
        return buffer.toString();
    }

    public String substituteAll(Object input, String replace) {
        return this.substituteAll(input, replace, 0, 0);
    }

    public String substituteAll(Object input, String replace, int index) {
        return this.substituteAll(input, replace, index, 0);
    }

    public String substituteAll(Object input, String replace, int index, int eflags) {
        return this.substituteAllImpl(RE.makeCharIndexed(input, index), replace, index, eflags);
    }

    /*
     * WARNING - void declaration
     */
    private String substituteAllImpl(CharIndexed input, String replace, int index, int eflags) {
        REMatch m;
        StringBuffer buffer = new StringBuffer();
        while ((m = this.getMatchImpl(input, index, eflags, buffer)) != null) {
            void var6_6;
            buffer.append(var6_6.substituteInto(replace));
            index = var6_6.getEndIndex();
            if (var6_6.end[0] == 0) {
                char ch = input.charAt(0);
                if (ch != '\uffff') {
                    buffer.append(ch);
                }
                input.move(1);
                continue;
            }
            input.move(var6_6.end[0]);
        }
        return buffer.toString();
    }

    private void addToken(REToken next) {
        if (next == null) {
            return;
        }
        if (this.firstToken == null) {
            this.lastToken = this.firstToken = next;
        } else if (this.lastToken.chain(next)) {
            this.lastToken = next;
        }
    }

    private static REToken setRepeated(REToken current, int min, int max, int index) throws REException {
        if (current == null) {
            throw new REException("repeat preceding token", 1, index);
        }
        return new RETokenRepeated(current.m_subIndex, current, min, max);
    }

    private static int getPosixSet(char[] pattern, int index, StringBuffer buf) {
        int i = index;
        while (i < pattern.length - 1) {
            if (pattern[i] == ':' && pattern[i + 1] == ']') {
                return i + 2;
            }
            buf.append(pattern[i]);
            ++i;
        }
        return index;
    }

    private int getMinMax(char[] input, int index, IntPair minMax, RESyntax syntax) throws REException {
        if (index == input.length) {
            throw new REException("no matching brace", 3, index);
        }
        int max = 0;
        CharUnit unit = new CharUnit();
        StringBuffer buf = new StringBuffer();
        while ((index = RE.getCharUnit(input, index, unit)) != input.length && Character.isDigit(unit.ch)) {
            buf.append(unit.ch);
        }
        if (buf.length() == 0) {
            throw new REException("bad brace construct", 3, index);
        }
        int min = Integer.parseInt(buf.toString());
        if (unit.ch == '}' && syntax.get(11) ^ unit.bk) {
            max = min;
        } else if (unit.ch == ',' && !unit.bk) {
            buf = new StringBuffer();
            while ((index = RE.getCharUnit(input, index, unit)) != input.length && Character.isDigit(unit.ch)) {
                buf.append(unit.ch);
            }
            if (unit.ch != '}' || !(syntax.get(11) ^ unit.bk)) {
                throw new REException("expected end of interval", 3, index);
            }
            max = buf.length() == 0 ? Integer.MAX_VALUE : Integer.parseInt(buf.toString());
        } else {
            throw new REException("invalid character in brace expression", 3, index);
        }
        minMax.first = min;
        minMax.second = max;
        return index;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        this.dump(sb);
        return sb.toString();
    }

    void dump(StringBuffer os) {
        os.append('(');
        if (this.m_subIndex == 0) {
            os.append("?:");
        }
        if (this.firstToken != null) {
            this.firstToken.dumpAll(os);
        }
        os.append(')');
    }

    private static CharIndexed makeCharIndexed(Object input, int index) {
        if (input instanceof String) {
            return new CharIndexedString((String)input, index);
        }
        if (input instanceof char[]) {
            return new CharIndexedCharArray((char[])input, index);
        }
        if (input instanceof StringBuffer) {
            return new CharIndexedStringBuffer((StringBuffer)input, index);
        }
        if (input instanceof InputStream) {
            return new CharIndexedInputStream((InputStream)input, index);
        }
        throw new IllegalArgumentException("Invalid class for input text");
    }
}

