/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.nifty.iga.midori.shell.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.StringTokenizer;
import java.util.Vector;
import jp.ne.nifty.iga.midori.shell.dir.MdShellDirDirectoryFileSystem;
import jp.ne.nifty.iga.midori.shell.dir.MdShellDirFactory;
import jp.ne.nifty.iga.midori.shell.eng.MdShellEnv;
import jp.ne.nifty.iga.midori.shell.io.MdShellStreamConnectThread;

public class MdShellUtilExec
extends Thread {
    private MdShellEnv shellenv = null;
    private String strCommand = null;

    public static int exec(MdShellEnv shellenv, String strCommand) {
        if (strCommand == null || strCommand.trim().length() == 0) {
            return -1;
        }
        if (strCommand.indexOf(38) < 0) {
            return MdShellUtilExec.internalExec(shellenv, strCommand, shellenv.getIn());
        }
        StringTokenizer toknizerTab = new StringTokenizer(strCommand, "&", false);
        strCommand = toknizerTab.nextToken();
        MdShellUtilExec.execAsync(shellenv, strCommand);
        return 0;
    }

    private static void execAsync(MdShellEnv shellenv, String strCommand) {
        if (strCommand == null || strCommand.trim().length() == 0) {
            return;
        }
        MdShellUtilExec shellutil = new MdShellUtilExec(shellenv, strCommand);
        shellutil.start();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            System.out.println(ex.toString());
        }
    }

    private static int internalExec(MdShellEnv shellenv, String strCommand, InputStream inStream) {
        Calendar calStart = Calendar.getInstance();
        SimpleDateFormat sdFormat = new SimpleDateFormat("HH:mm:ss");
        StringBuffer strbufWrk = new StringBuffer();
        strbufWrk.append(sdFormat.format(calStart.getTime()) + " ");
        if (inStream != null) {
            strbufWrk.append("An executive start.");
        } else {
            strbufWrk.append("back ground executive start.");
        }
        strbufWrk.append(" [" + strCommand + "]");
        System.out.println(strbufWrk.toString());
        Vector<String> vecList = new Vector<String>();
        StringTokenizer toknizerTab = new StringTokenizer(strCommand, " \t\n", false);
        while (toknizerTab.hasMoreTokens()) {
            String strToken = toknizerTab.nextToken();
            if (strToken == null) break;
            vecList.addElement(strToken);
        }
        String[] straryCommands = new String[vecList.size()];
        int index = 0;
        while (index < vecList.size()) {
            straryCommands[index] = (String)vecList.elementAt(index);
            if (index == 0 && shellenv.getCurrentDirectory() instanceof MdShellDirDirectoryFileSystem) {
                MdShellDirDirectoryFileSystem filesystem = (MdShellDirDirectoryFileSystem)shellenv.getCurrentDirectory();
                String strSeparator = System.getProperty("file.separator");
                File fileExistCheck = new File(MdShellDirFactory.uri2native(filesystem.getName()) + strSeparator + straryCommands[index]);
                if (fileExistCheck.exists()) {
                    straryCommands[index] = MdShellDirFactory.uri2native(filesystem.getName()) + strSeparator + straryCommands[index];
                }
            }
            ++index;
        }
        Process proc = null;
        try {
            File fileWrkDirectory = null;
            if (shellenv.getCurrentDirectory() instanceof MdShellDirDirectoryFileSystem) {
                MdShellDirDirectoryFileSystem filesystem = (MdShellDirDirectoryFileSystem)shellenv.getCurrentDirectory();
                fileWrkDirectory = new File(MdShellDirFactory.uri2native(filesystem.getName()));
            }
            proc = Runtime.getRuntime().exec(straryCommands, null, fileWrkDirectory);
        }
        catch (IOException ex) {
            System.out.println("fail to invoke command [" + strCommand + "]: " + ex.toString());
            return -1;
        }
        MdShellStreamConnectThread threadStdin = null;
        if (inStream != null) {
            threadStdin = new MdShellStreamConnectThread(inStream, proc.getOutputStream());
            threadStdin.start();
        }
        MdShellStreamConnectThread threadStdout = new MdShellStreamConnectThread(proc.getInputStream(), System.out);
        MdShellStreamConnectThread threadStderr = new MdShellStreamConnectThread(proc.getErrorStream(), System.out);
        threadStdout.start();
        threadStderr.start();
        try {
            threadStdout.join();
        }
        catch (InterruptedException ex) {
            System.out.println(ex.toString());
        }
        int i_status = proc.exitValue();
        if (threadStdin != null) {
            threadStdin.close();
        }
        threadStdout.close();
        threadStderr.close();
        try {
            proc.getOutputStream().close();
        }
        catch (IOException ex) {
            System.out.println(ex.toString());
            ex.printStackTrace();
        }
        Calendar calEnd = Calendar.getInstance();
        String strMillisec = NumberFormat.getNumberInstance().format((double)(calEnd.getTime().getTime() - calStart.getTime().getTime()) / 1000.0) + "sec";
        System.out.println();
        StringBuffer strbufWrk2 = new StringBuffer();
        strbufWrk2.append(sdFormat.format(calEnd.getTime()) + " ");
        if (inStream != null) {
            strbufWrk2.append("Executive completion.");
        } else {
            strbufWrk2.append("back ground executive completion.");
        }
        strbufWrk2.append(" " + strMillisec + " return value=" + i_status);
        System.out.println(strbufWrk2.toString());
        return i_status;
    }

    public MdShellUtilExec(MdShellEnv shellenv, String strCommand) {
        this.shellenv = shellenv;
        this.strCommand = strCommand;
    }

    public void run() {
        MdShellUtilExec.internalExec(this.shellenv, this.strCommand, null);
    }
}

