/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.nifty.iga.midori.shell.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class MdShellStreamConnectThread
extends Thread {
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private InputStream inStream = null;
    private OutputStream outStream = null;
    private int iResetSize = 1024;
    private boolean isClosing = false;

    public MdShellStreamConnectThread(InputStream inStream, OutputStream outStream, int iResetSize) {
        this.inStream = inStream;
        this.outStream = outStream;
        this.iResetSize = iResetSize;
    }

    public MdShellStreamConnectThread(InputStream inStream, OutputStream outStream) {
        this(inStream, outStream, 1024);
    }

    public void run() {
        byte[] byteBuf = new byte[this.iResetSize];
        while (!this.isClosing) {
            InputStream inputStream = this.inStream;
            synchronized (inputStream) {
                if (this.copyTransaction(byteBuf)) {
                    return;
                }
            }
        }
    }

    public void close() {
        this.isClosing = true;
        this.interrupt();
    }

    private boolean copyTransaction(byte[] byteBuf) {
        this.beginTransactionStream();
        int iRet = -1;
        try {
            iRet = this.inStream.read(byteBuf);
            if (iRet < 0) {
                return true;
            }
        }
        catch (IOException ex) {
            return true;
        }
        if (this.isClosing) {
            this.rollbackTransactionStream();
            return true;
        }
        try {
            this.outStream.write(byteBuf, 0, iRet);
            this.outStream.flush();
        }
        catch (IOException ex) {
            this.rollbackTransactionStream();
            return true;
        }
        return false;
    }

    private void beginTransactionStream() {
        this.inStream.mark(this.iResetSize);
    }

    private void rollbackTransactionStream() {
        try {
            this.inStream.reset();
        }
        catch (IOException ex2) {
            System.out.println(ex2.toString());
            ex2.printStackTrace();
        }
    }
}

