/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.nifty.iga.midori.shell.io;

import java.util.Vector;
import jp.ne.nifty.iga.midori.shell.io.MdShellFtpc;

class MdShellFtpcNode {
    private static final int CONNECTION_POOLING_TIMEOUT_MILLISEC = 10000;
    public String strHostName = null;
    public MdShellFtpc ftpc = null;
    private long lastAccessMillisec = 0L;
    private int iRefCount = 0;

    public MdShellFtpcNode(String strHostName, MdShellFtpc ftpc) {
        this.strHostName = strHostName;
        this.ftpc = ftpc;
        this.touch();
    }

    public void touch() {
        this.lastAccessMillisec = System.currentTimeMillis();
    }

    public boolean isCloseable() {
        return this.getRef() <= 0 && System.currentTimeMillis() > this.lastAccessMillisec + 10000L;
    }

    public void addRef() {
        ++this.iRefCount;
    }

    public void releaseRef() {
        --this.iRefCount;
    }

    public int getRef() {
        return this.iRefCount;
    }

    public static MdShellFtpcNode findByHostName(Vector vecFtpc, String strHostName) {
        int index = 0;
        while (index < vecFtpc.size()) {
            MdShellFtpcNode ftpcnode = (MdShellFtpcNode)vecFtpc.elementAt(index);
            if (ftpcnode.getRef() == 0 && ftpcnode.strHostName.equals(strHostName)) {
                return ftpcnode;
            }
            ++index;
        }
        return null;
    }

    public static MdShellFtpcNode findByFtpc(Vector vecFtpc, MdShellFtpc ftpc) {
        int index = 0;
        while (index < vecFtpc.size()) {
            MdShellFtpcNode ftpcnode = (MdShellFtpcNode)vecFtpc.elementAt(index);
            if (ftpcnode.ftpc == ftpc) {
                return ftpcnode;
            }
            ++index;
        }
        return null;
    }
}

