/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.nifty.iga.midori.shell.cmd;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Vector;
import jp.ne.nifty.iga.midori.shell.cmd.MdShellCmdDefault;
import jp.ne.nifty.iga.midori.shell.dir.MdShellDirFactory;
import jp.ne.nifty.iga.midori.shell.dir.MdShellDirFileAbstract;
import jp.ne.nifty.iga.midori.shell.eng.MdShellCancelException;
import jp.ne.nifty.iga.midori.shell.eng.MdShellEnv;
import jp.ne.nifty.iga.midori.shell.eng.MdShellListSelection;
import jp.ne.nifty.iga.midori.shell.io.MdShellDefaultStringFormatter;
import jp.ne.nifty.iga.midori.shell.util.MdShellSelectFileUtil;

public class MdShellCommandCodeConv
extends MdShellCmdDefault {
    public MdShellCommandCodeConv() {
        this.setCommand("codeconv");
        this.setDisplayString("code convert (like \"EUC_JP\" to \"SJIS\") [experimental]");
    }

    public void processCommand(MdShellEnv shellenv) throws MdShellCancelException {
        Vector<String> vecList = new Vector<String>();
        vecList.addElement("EUC_JP");
        vecList.addElement("ISO2022JP");
        vecList.addElement("SJIS");
        vecList.addElement("UNICODE");
        MdShellDirFileAbstract dirfileInput = MdShellSelectFileUtil.selectFile(shellenv);
        MdShellListSelection.showVectorListWithNumberAndString(shellenv, vecList, new MdShellDefaultStringFormatter());
        shellenv.getOut().print("select input code: ");
        MdShellDefaultStringFormatter formatter = new MdShellDefaultStringFormatter();
        String strInputEncoding = formatter.format(MdShellListSelection.selectFromList(shellenv, vecList, formatter, shellenv.getNextLine()));
        if (strInputEncoding == null) {
            throw new MdShellCancelException();
        }
        MdShellListSelection.showVectorListWithNumberAndString(shellenv, vecList, new MdShellDefaultStringFormatter());
        shellenv.getOut().print("select output code: ");
        String strOutputEncoding = formatter.format(MdShellListSelection.selectFromList(shellenv, vecList, formatter, shellenv.getNextLine()));
        if (strOutputEncoding == null) {
            throw new MdShellCancelException();
        }
        try {
            String strRead;
            MdShellDirFileAbstract dirfileOutput = (MdShellDirFileAbstract)MdShellDirFactory.getInstance(shellenv, dirfileInput.getName() + "." + strOutputEncoding, false);
            BufferedReader reader = new BufferedReader(new InputStreamReader(dirfileInput.getInputStream(), strInputEncoding));
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(dirfileOutput.getOutputStream(), strOutputEncoding));
            shellenv.getOut().println("converting " + dirfileInput.getName() + " to " + dirfileOutput.getName());
            while ((strRead = reader.readLine()) != null) {
                writer.write(strRead);
                writer.newLine();
            }
            writer.flush();
            writer.close();
            reader.close();
            dirfileOutput.setLastModified(dirfileInput.getLastModified());
        }
        catch (IOException ex) {
            System.out.println(ex.toString());
            ex.printStackTrace();
        }
    }
}

