/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.ole.win32;

import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.IDispatch;
import org.eclipse.swt.internal.ole.win32.IUnknown;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.ole.win32.OLE;
import org.eclipse.swt.ole.win32.OleAutomation;

public final class Variant {
    public static final int sizeof = 16;
    private short type;
    private boolean booleanData;
    private float floatData;
    private int intData;
    private short shortData;
    private String stringData;
    private int byRefPtr;
    private IDispatch dispatchData;
    private IUnknown unknownData;

    public Variant() {
        this.type = 0;
    }

    public Variant(float val) {
        this.type = (short)4;
        this.floatData = val;
    }

    public Variant(int val) {
        this.type = (short)3;
        this.intData = val;
    }

    public Variant(int ptr, short byRefType) {
        this.type = byRefType;
        this.byRefPtr = ptr;
    }

    public Variant(OleAutomation automation) {
        this.type = (short)9;
        this.dispatchData = new IDispatch(automation.getAddress());
    }

    public Variant(IDispatch idispatch) {
        this.type = (short)9;
        this.dispatchData = idispatch;
    }

    public Variant(IUnknown unknown) {
        this.type = (short)13;
        this.unknownData = unknown;
    }

    public Variant(String string) {
        this.type = (short)8;
        this.stringData = string;
    }

    public Variant(short val) {
        this.type = (short)2;
        this.shortData = val;
    }

    public Variant(boolean val) {
        this.type = (short)11;
        this.booleanData = val;
    }

    public void dispose() {
        if ((this.type & 0x4000) == 16384) {
            return;
        }
        switch (this.type) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 11: {
                break;
            }
            case 9: {
                this.dispatchData.Release();
                break;
            }
            case 13: {
                this.unknownData.Release();
            }
        }
    }

    public OleAutomation getAutomation() {
        OleAutomation oleAutomation;
        if (this.type == 0) {
            OLE.error(1010, -1);
        }
        if (this.type == 9) {
            return new OleAutomation(this.dispatchData);
        }
        int oldPtr = OS.GlobalAlloc(64, 16);
        int newPtr = OS.GlobalAlloc(64, 16);
        try {
            this.getData(oldPtr);
            int result = COM.VariantChangeType(newPtr, oldPtr, (short)0, (short)9);
            if (result != 0) {
                OLE.error(1010, result);
            }
            Variant autoVar = new Variant();
            autoVar.setData(newPtr);
            oleAutomation = autoVar.getAutomation();
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            COM.VariantClear(oldPtr);
            OS.GlobalFree(oldPtr);
            COM.VariantClear(newPtr);
            OS.GlobalFree(newPtr);
            throw throwable;
        }
        COM.VariantClear(oldPtr);
        OS.GlobalFree(oldPtr);
        COM.VariantClear(newPtr);
        OS.GlobalFree(newPtr);
        return oleAutomation;
    }

    public IDispatch getDispatch() {
        IDispatch iDispatch;
        if (this.type == 0) {
            OLE.error(1010, -1);
        }
        if (this.type == 9) {
            return this.dispatchData;
        }
        int oldPtr = OS.GlobalAlloc(64, 16);
        int newPtr = OS.GlobalAlloc(64, 16);
        try {
            this.getData(oldPtr);
            int result = COM.VariantChangeType(newPtr, oldPtr, (short)0, (short)9);
            if (result != 0) {
                OLE.error(1010, result);
            }
            Variant autoVar = new Variant();
            autoVar.setData(newPtr);
            iDispatch = autoVar.getDispatch();
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            COM.VariantClear(oldPtr);
            OS.GlobalFree(oldPtr);
            COM.VariantClear(newPtr);
            OS.GlobalFree(newPtr);
            throw throwable;
        }
        COM.VariantClear(oldPtr);
        OS.GlobalFree(oldPtr);
        COM.VariantClear(newPtr);
        OS.GlobalFree(newPtr);
        return iDispatch;
    }

    public boolean getBoolean() {
        boolean bl;
        if (this.type == 0) {
            OLE.error(1010, -1);
        }
        if (this.type == 11) {
            return this.booleanData;
        }
        int oldPtr = OS.GlobalAlloc(64, 16);
        int newPtr = OS.GlobalAlloc(64, 16);
        try {
            this.getData(oldPtr);
            int result = COM.VariantChangeType(newPtr, oldPtr, (short)0, (short)11);
            if (result != 0) {
                OLE.error(1010, result);
            }
            Variant boolVar = new Variant();
            boolVar.setData(newPtr);
            bl = boolVar.getBoolean();
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            COM.VariantClear(oldPtr);
            OS.GlobalFree(oldPtr);
            COM.VariantClear(newPtr);
            OS.GlobalFree(newPtr);
            throw throwable;
        }
        COM.VariantClear(oldPtr);
        OS.GlobalFree(oldPtr);
        COM.VariantClear(newPtr);
        OS.GlobalFree(newPtr);
        return bl;
    }

    public int getByRef() {
        if (this.type == 0) {
            OLE.error(1010, -1);
        }
        if ((this.type & 0x4000) == 16384) {
            return this.byRefPtr;
        }
        return 0;
    }

    void getData(int pData) {
        if (pData == 0) {
            OLE.error(1007);
        }
        COM.VariantInit(pData);
        if ((this.type & 0x4000) == 16384) {
            OS.MoveMemory(pData, new short[]{this.type}, 2);
            OS.MoveMemory(pData + 8, new int[]{this.byRefPtr}, 4);
            return;
        }
        switch (this.type) {
            case 0: {
                break;
            }
            case 11: {
                OS.MoveMemory(pData, new short[]{this.type}, 2);
                OS.MoveMemory(pData + 8, new int[]{this.booleanData ? -1 : 0}, 2);
                break;
            }
            case 4: {
                OS.MoveMemory(pData, new short[]{this.type}, 2);
                OS.MoveMemory(pData + 8, new float[]{this.floatData}, 4);
                break;
            }
            case 3: {
                OS.MoveMemory(pData, new short[]{this.type}, 2);
                OS.MoveMemory(pData + 8, new int[]{this.intData}, 4);
                break;
            }
            case 9: {
                this.dispatchData.AddRef();
                OS.MoveMemory(pData, new short[]{this.type}, 2);
                OS.MoveMemory(pData + 8, new int[]{this.dispatchData.getAddress()}, 4);
                break;
            }
            case 13: {
                this.unknownData.AddRef();
                OS.MoveMemory(pData, new short[]{this.type}, 2);
                OS.MoveMemory(pData + 8, new int[]{this.unknownData.getAddress()}, 4);
                break;
            }
            case 2: {
                OS.MoveMemory(pData, new short[]{this.type}, 2);
                OS.MoveMemory(pData + 8, new short[]{this.shortData}, 2);
                break;
            }
            case 8: {
                OS.MoveMemory(pData, new short[]{this.type}, 2);
                char[] data = (String.valueOf(this.stringData) + "\u0000").toCharArray();
                int ptr = COM.SysAllocString(data);
                OS.MoveMemory(pData + 8, new int[]{ptr}, 4);
                break;
            }
            default: {
                OLE.error(20);
            }
        }
    }

    public float getFloat() {
        float f;
        if (this.type == 0) {
            OLE.error(1010, -1);
        }
        if (this.type == 4) {
            return this.floatData;
        }
        int oldPtr = OS.GlobalAlloc(64, 16);
        int newPtr = OS.GlobalAlloc(64, 16);
        try {
            this.getData(oldPtr);
            int result = COM.VariantChangeType(newPtr, oldPtr, (short)0, (short)4);
            if (result != 0) {
                OLE.error(1010, result);
            }
            Variant floatVar = new Variant();
            floatVar.setData(newPtr);
            f = floatVar.getFloat();
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            COM.VariantClear(oldPtr);
            OS.GlobalFree(oldPtr);
            COM.VariantClear(newPtr);
            OS.GlobalFree(newPtr);
            throw throwable;
        }
        COM.VariantClear(oldPtr);
        OS.GlobalFree(oldPtr);
        COM.VariantClear(newPtr);
        OS.GlobalFree(newPtr);
        return f;
    }

    public int getInt() {
        int n;
        if (this.type == 0) {
            OLE.error(1010, -1);
        }
        if (this.type == 3) {
            return this.intData;
        }
        int oldPtr = OS.GlobalAlloc(64, 16);
        int newPtr = OS.GlobalAlloc(64, 16);
        try {
            this.getData(oldPtr);
            int result = COM.VariantChangeType(newPtr, oldPtr, (short)0, (short)3);
            if (result != 0) {
                OLE.error(1010, result);
            }
            Variant intVar = new Variant();
            intVar.setData(newPtr);
            n = intVar.getInt();
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            COM.VariantClear(oldPtr);
            OS.GlobalFree(oldPtr);
            COM.VariantClear(newPtr);
            OS.GlobalFree(newPtr);
            throw throwable;
        }
        COM.VariantClear(oldPtr);
        OS.GlobalFree(oldPtr);
        COM.VariantClear(newPtr);
        OS.GlobalFree(newPtr);
        return n;
    }

    public short getShort() {
        short s;
        if (this.type == 0) {
            OLE.error(1010, -1);
        }
        if (this.type == 2) {
            return this.shortData;
        }
        int oldPtr = OS.GlobalAlloc(64, 16);
        int newPtr = OS.GlobalAlloc(64, 16);
        try {
            this.getData(oldPtr);
            int result = COM.VariantChangeType(newPtr, oldPtr, (short)0, (short)2);
            if (result != 0) {
                OLE.error(1010, result);
            }
            Variant shortVar = new Variant();
            shortVar.setData(newPtr);
            s = shortVar.getShort();
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            COM.VariantClear(oldPtr);
            OS.GlobalFree(oldPtr);
            COM.VariantClear(newPtr);
            OS.GlobalFree(newPtr);
            throw throwable;
        }
        COM.VariantClear(oldPtr);
        OS.GlobalFree(oldPtr);
        COM.VariantClear(newPtr);
        OS.GlobalFree(newPtr);
        return s;
    }

    public String getString() {
        String string;
        if (this.type == 0) {
            OLE.error(1010, -1);
        }
        if (this.type == 8) {
            return this.stringData;
        }
        int oldPtr = OS.GlobalAlloc(64, 16);
        int newPtr = OS.GlobalAlloc(64, 16);
        try {
            this.getData(oldPtr);
            int result = COM.VariantChangeType(newPtr, oldPtr, (short)0, (short)8);
            if (result != 0) {
                OLE.error(1010, result);
            }
            Variant stringVar = new Variant();
            stringVar.setData(newPtr);
            string = stringVar.getString();
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            COM.VariantClear(oldPtr);
            OS.GlobalFree(oldPtr);
            COM.VariantClear(newPtr);
            OS.GlobalFree(newPtr);
            throw throwable;
        }
        COM.VariantClear(oldPtr);
        OS.GlobalFree(oldPtr);
        COM.VariantClear(newPtr);
        OS.GlobalFree(newPtr);
        return string;
    }

    public short getType() {
        return this.type;
    }

    public IUnknown getUnknown() {
        IUnknown iUnknown;
        if (this.type == 0) {
            OLE.error(1010, -1);
        }
        if (this.type == 13) {
            return this.unknownData;
        }
        int oldPtr = OS.GlobalAlloc(64, 16);
        int newPtr = OS.GlobalAlloc(64, 16);
        try {
            this.getData(oldPtr);
            int result = COM.VariantChangeType(newPtr, oldPtr, (short)0, (short)13);
            if (result != 0) {
                OLE.error(1010, result);
            }
            Variant unknownVar = new Variant();
            unknownVar.setData(newPtr);
            iUnknown = unknownVar.getUnknown();
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            COM.VariantClear(oldPtr);
            OS.GlobalFree(oldPtr);
            COM.VariantClear(newPtr);
            OS.GlobalFree(newPtr);
            throw throwable;
        }
        COM.VariantClear(oldPtr);
        OS.GlobalFree(oldPtr);
        COM.VariantClear(newPtr);
        OS.GlobalFree(newPtr);
        return iUnknown;
    }

    public void setByRef(boolean val) {
        if ((this.type & 0x4000) == 0 || (this.type & 0xB) == 0) {
            OLE.error(1010);
        }
        OS.MoveMemory(this.byRefPtr, new short[]{val ? (short)-1 : 0}, 2);
    }

    public void setByRef(float val) {
        if ((this.type & 0x4000) == 0 || (this.type & 4) == 0) {
            OLE.error(1010);
        }
        OS.MoveMemory(this.byRefPtr, new float[]{val}, 4);
    }

    public void setByRef(int val) {
        if ((this.type & 0x4000) == 0 || (this.type & 3) == 0) {
            OLE.error(1010);
        }
        OS.MoveMemory(this.byRefPtr, new int[]{val}, 4);
    }

    public void setByRef(short val) {
        if ((this.type & 0x4000) == 0 || (this.type & 2) == 0) {
            OLE.error(1010);
        }
        OS.MoveMemory(this.byRefPtr, new short[]{val}, 2);
    }

    void setData(int pData) {
        if (pData == 0) {
            OLE.error(5);
        }
        short[] dataType = new short[1];
        OS.MoveMemory(dataType, pData, 2);
        this.type = dataType[0];
        if ((this.type & 0x4000) == 16384) {
            int[] newByRefPtr = new int[1];
            OS.MoveMemory(newByRefPtr, pData + 8, 4);
            this.byRefPtr = newByRefPtr[0];
            return;
        }
        switch (this.type) {
            case 0: {
                break;
            }
            case 11: {
                short[] newBooleanData = new short[1];
                OS.MoveMemory(newBooleanData, pData + 8, 2);
                this.booleanData = newBooleanData[0] != 0;
                break;
            }
            case 4: {
                float[] newFloatData = new float[1];
                OS.MoveMemory(newFloatData, pData + 8, 4);
                this.floatData = newFloatData[0];
                break;
            }
            case 3: {
                int[] newIntData = new int[1];
                OS.MoveMemory(newIntData, pData + 8, 4);
                this.intData = newIntData[0];
                break;
            }
            case 9: {
                int[] ppvObject = new int[1];
                OS.MoveMemory(ppvObject, pData + 8, 4);
                if (ppvObject[0] == 0) {
                    this.type = 0;
                    break;
                }
                this.dispatchData = new IDispatch(ppvObject[0]);
                this.dispatchData.AddRef();
                break;
            }
            case 13: {
                int[] ppvObject = new int[1];
                OS.MoveMemory(ppvObject, pData + 8, 4);
                if (ppvObject[0] == 0) {
                    this.type = 0;
                    break;
                }
                this.unknownData = new IUnknown(ppvObject[0]);
                this.unknownData.AddRef();
                break;
            }
            case 2: {
                short[] newShortData = new short[1];
                OS.MoveMemory(newShortData, pData + 8, 2);
                this.shortData = newShortData[0];
                break;
            }
            case 8: {
                int[] hMem = new int[1];
                OS.MoveMemory(hMem, pData + 8, 4);
                if (hMem[0] == 0) {
                    this.type = 0;
                    break;
                }
                int size = COM.SysStringByteLen(hMem[0]);
                if (size > 0) {
                    char[] buffer = new char[(size + 1) / 2];
                    OS.MoveMemory(buffer, hMem[0], size);
                    this.stringData = new String(buffer);
                    break;
                }
                this.stringData = "";
                break;
            }
            default: {
                int newPData = OS.GlobalAlloc(64, 16);
                if (COM.VariantChangeType(newPData, pData, (short)0, (short)4) == 0) {
                    this.setData(newPData);
                } else if (COM.VariantChangeType(newPData, pData, (short)0, (short)3) == 0) {
                    this.setData(newPData);
                } else if (COM.VariantChangeType(newPData, pData, (short)0, (short)8) == 0) {
                    this.setData(newPData);
                }
                COM.VariantClear(newPData);
                OS.GlobalFree(newPData);
            }
        }
    }
}

